/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Asset;
import com.ibm.ram.internal.client.ant.types.AssetList;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.RelationshipType;
import com.ibm.ram.internal.client.ant.types.Search;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class RelatedAsset
extends RAMDataType {
    private String type;
    private List assetLists = new ArrayList();
    private List assets = new ArrayList();
    private List searches = new ArrayList();
    private RAMAsset[] assetArray;
    private RAMRelationshipType relationshipType;

    public void add(Asset asset) {
        asset.setParent(this);
        this.assets.add(asset);
    }

    public void add(AssetList assetList) {
        assetList.setParent(this);
        this.assetLists.add(assetList);
    }

    public void add(Search search) {
        search.setParent(this);
        this.searches.add(search);
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.assets);
        children.addAll(this.assetLists);
        children.addAll(this.searches);
        return children;
    }

    @Override
    public Object getModel() {
        return null;
    }

    protected RelatedAsset getRef() {
        return (RelatedAsset)((Object)this.getCheckedRef(RelatedAsset.class, RelatedAsset.class.getName()));
    }

    public RAMRelationshipType getRelationshipType() {
        if (this.isReference()) {
            return this.getRef().getRelationshipType();
        }
        if (this.relationshipType != null) {
            return this.relationshipType;
        }
        if (this.type != null) {
            try {
                this.relationshipType = this.getSession().getRelationshipType(this.type);
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.errorGettingObject((ProjectComponent)new RelationshipType(), this.type, e);
            }
        }
        return this.relationshipType;
    }

    protected String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type;
    }

    public RAMAsset[] getAssets() {
        if (this.isReference()) {
            return this.getRef().getAssets();
        }
        if (this.assetArray == null) {
            RAMAsset[] temp;
            RAMAsset[] next;
            this.assetArray = new RAMAsset[this.assets.size()];
            int index = 0;
            Iterator iter = this.assets.iterator();
            while (iter.hasNext()) {
                this.assetArray[index++] = ((Asset)((Object)iter.next())).getAsset();
            }
            for (AssetList list : this.assetLists) {
                next = list.getAssets();
                temp = this.assetArray;
                this.assetArray = new RAMAsset[next.length + temp.length];
                System.arraycopy(temp, 0, this.assetArray, 0, temp.length);
                System.arraycopy(next, 0, this.assetArray, temp.length, next.length);
            }
            for (Search search : this.searches) {
                next = search.getAssets();
                temp = this.assetArray;
                this.assetArray = new RAMAsset[next.length + temp.length];
                System.arraycopy(temp, 0, this.assetArray, 0, temp.length);
                System.arraycopy(next, 0, this.assetArray, temp.length, next.length);
            }
        }
        return this.assetArray;
    }

    public void setType(String type) {
        this.type = type;
    }
}

