/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.util;

import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.RepositoryIdentification;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.util.RAMSessionModificationEvent;
import com.ibm.ram.internal.client.util.SessionStore;
import com.ibm.ram.internal.common.data.AssetTypeSO;
import com.ibm.ram.internal.common.data.GroupPermissionSO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class SessionManager {
    private static SessionManager fSessionManager;
    private List fSuspendNotificationList = new ArrayList();
    private Map fSessionStores = new HashMap();

    public void releaseSession(RAMSession session) {
        this.fSessionStores.remove(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionStore getSessionStore(RAMSession session) {
        SessionStore ret = null;
        RAMSession rAMSession = session;
        synchronized (rAMSession) {
            ret = (SessionStore)this.fSessionStores.get(session);
            if (ret == null) {
                ret = new SessionStore();
                this.fSessionStores.put(session, ret);
            }
        }
        return ret;
    }

    public static synchronized void setSessionManager(SessionManager instance) {
        fSessionManager = instance;
    }

    public static synchronized SessionManager getSessionManager() {
        if (fSessionManager == null) {
            fSessionManager = new SessionManager();
        }
        return fSessionManager;
    }

    protected synchronized boolean isSuspended(RAMSession session) {
        return this.fSuspendNotificationList.contains(session);
    }

    public synchronized void suspendNotification(RAMSession session) {
        this.fSuspendNotificationList.add(session);
    }

    public synchronized void resumeNotification(RAMSession session) {
        this.fSuspendNotificationList.remove(session);
    }

    public void handleSessionModificationEvent(RAMSessionModificationEvent event) {
    }

    public AssetTypeSO[] getAssetTypeCache(AbstractRAMClient client) throws RAMRuntimeException {
        try {
            return client.getRAM1Webservice().getAllAssetTypes();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public CommunityInformation[] getCommunitiesCache(AbstractRAMClient client) throws RAMRuntimeException {
        try {
            return client.getRAM1Webservice().getMemberGroups();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public RelationshipType[] getRelationshipTypeCache(AbstractRAMClient client) throws RAMRuntimeException {
        try {
            return client.getRAM1Webservice().getAllAssetRelationTypes();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public AssetAttribute[] getAssetAttributeCache(AbstractRAMClient client) throws RAMRuntimeException {
        try {
            return client.getRAM1Webservice().getAllAttributes();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String[] getAllCatgeorySchemaURIs(AbstractRAMClient client) throws RAMRuntimeException {
        try {
            return client.getRAM1Webservice().getAllClassificationSchemaURI();
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public ResourceSet createCachedResourceSet(AbstractRAMClient client, Map serverToLocalEMFURIResourceMap, File localStroageFolder) {
        return client.createCachedResourceSet(serverToLocalEMFURIResourceMap, localStroageFolder);
    }

    public RepositoryIdentification getIdentification(AbstractRAMClient client) {
        RepositoryIdentification ret = null;
        if (ret == null) {
            try {
                String id = client.getRAM1Webservice().getUniqueID();
                ret = new RepositoryIdentification(id, client.getWebServicesPath(), client.getUserName());
            }
            catch (Exception e) {
                throw new RAMRuntimeException("Could not create repository identification", e);
            }
        }
        return ret;
    }

    public String[] copySchemasToLocalOS(AbstractRAMClient client, String[] schemauris, File localStorageFolder) throws IOException, RAMRuntimeException {
        return client.copySchemasToLocalOS(schemauris, localStorageFolder);
    }

    public GroupPermissionSO[] getCommunityPermissions(AbstractRAMClient client, int[] communityIds) {
        GroupPermissionSO[] ret = null;
        try {
            ret = client.getRAM1Webservice().getGroupPermission(communityIds);
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Could not create repository identification", e);
        }
        return ret;
    }
}

