/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.zip;

import com.ibm.ram.io.rof.BufferedReadOnlyFile;
import com.ibm.ram.io.rof.ReadOnlyFile;
import com.ibm.ram.io.rof.SimpleReadOnlyFile;
import com.ibm.ram.io.zip.CRC32Exception;
import com.ibm.ram.io.zip.LittleEndian;
import com.ibm.ram.io.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class BasicZipFile {
    private static final long LONG_MSB = Long.MIN_VALUE;
    private static final int LFH_FILE_NAME_LENGTH_OFF = 26;
    private static final Set allocatedInflaters = new HashSet();
    private static final List releasedInflaters = new LinkedList();
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String charset;
    private String comment;
    private final Map entries = new LinkedHashMap();
    private ReadOnlyFile archive;
    private int openStreams;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;

    public BasicZipFile(String name) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, new File(name), true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(String name, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, new File(name), true, false);
    }

    public BasicZipFile(String name, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, new File(name), preambled, postambled);
    }

    public BasicZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, file, true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(File file, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, file, true, false);
    }

    public BasicZipFile(File file, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, file, preambled, postambled);
    }

    public BasicZipFile(ReadOnlyFile rof) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(rof, null, true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(ReadOnlyFile rof, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(rof, null, true, false);
    }

    public BasicZipFile(ReadOnlyFile rof, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(rof, null, preambled, postambled);
    }

    private void init(ReadOnlyFile rof, File file, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        if (this.charset == null) {
            throw new NullPointerException("charset");
        }
        new String(new byte[0], this.charset);
        if (rof == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            rof = this.createReadOnlyFile(file);
        }
        this.archive = rof;
        try {
            BufferedReadOnlyFile brof = this.archive instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)this.archive : new BufferedReadOnlyFile(this.archive);
            this.mountCentralDirectory(brof, preambled, postambled);
        }
        catch (IOException failure) {
            if (file != null) {
                rof.close();
            }
            throw failure;
        }
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws FileNotFoundException, IOException {
        return new SimpleReadOnlyFile(file);
    }

    private void mountCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws ZipException, IOException {
        int numEntries = this.locateCentralDirectory(rof, preambled, postambled);
        this.preamble = Long.MAX_VALUE;
        byte[] sig = new byte[4];
        byte[] cfh = new byte[46 - sig.length];
        while (true) {
            rof.readFully(sig);
            if (LittleEndian.readUInt(sig, 0) != 33639248L) break;
            rof.readFully(cfh);
            int general = LittleEndian.readUShort(cfh, 4);
            int nameLen = LittleEndian.readUShort(cfh, 24);
            byte[] name = new byte[nameLen];
            rof.readFully(name);
            boolean utf8 = (general & 0x800) != 0;
            String charset = utf8 ? DEFAULT_CHARSET : this.charset;
            ZipEntry entry = this.createZipEntry(new String(name, charset));
            try {
                int off = 0;
                int versionMadeBy = LittleEndian.readUShort(cfh, off);
                off += 2;
                entry.setPlatform((short)(versionMadeBy >> 8));
                off += 2;
                entry.setGeneral(general);
                int method = LittleEndian.readUShort(cfh, off += 2);
                off += 2;
                if (method != 0 && method != 8) {
                    throw new ZipException(String.valueOf(entry.getName()) + ": unsupported compression method: " + method);
                }
                entry.setMethod(method);
                entry.setDosTime(LittleEndian.readUInt(cfh, off));
                entry.setCrc(LittleEndian.readUInt(cfh, off += 4));
                entry.setCompressedSize32(LittleEndian.readUInt(cfh, off += 4));
                entry.setSize32(LittleEndian.readUInt(cfh, off += 4));
                off += 4;
                int extraLen = LittleEndian.readUShort(cfh, off += 2);
                int commentLen = LittleEndian.readUShort(cfh, off += 2);
                off += 2;
                off += 2;
                off += 2;
                long lfhOff = LittleEndian.readUInt(cfh, off += 4);
                entry.setOffset32(lfhOff);
                if (extraLen > 0) {
                    byte[] extra = new byte[extraLen];
                    rof.readFully(extra);
                    entry.setExtra(extra);
                }
                if (commentLen > 0) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    entry.setComment(new String(comment, charset));
                }
                if ((lfhOff = this.mapper.location(entry.getOffset())) < this.preamble) {
                    this.preamble = lfhOff;
                }
            }
            catch (RuntimeException incompatibleZipFile) {
                ZipException exc = new ZipException(entry.getName());
                exc.initCause(incompatibleZipFile);
                throw exc;
            }
            this.entries.put(entry.getName(), entry);
            --numEntries;
        }
        if (numEntries % 65536 != 0) {
            throw new ZipException("Expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
        if (this.preamble == Long.MAX_VALUE) {
            this.preamble = 0L;
        }
    }

    private int locateCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws ZipException, IOException {
        byte[] sig = new byte[4];
        if (!preambled) {
            rof.seek(0L);
            rof.readFully(sig);
            long signature = LittleEndian.readUInt(sig, 0);
            boolean bl = preambled = signature == 67324752L || signature == 101075792L || signature == 101010256L;
        }
        if (preambled) {
            long length = rof.length();
            long max = length - 22L;
            long min = !postambled && max >= 65535L ? max - 65535L : 0L;
            long eocdrOffset = max;
            while (eocdrOffset >= min) {
                rof.seek(eocdrOffset);
                rof.readFully(sig);
                if (LittleEndian.readUInt(sig, 0) == 101010256L) {
                    int off = 0;
                    byte[] eocdr = new byte[22 - sig.length];
                    rof.readFully(eocdr);
                    long diskNo = LittleEndian.readUShort(eocdr, off);
                    long cdDiskNo = LittleEndian.readUShort(eocdr, off += 2);
                    long cdEntriesDisk = LittleEndian.readUShort(eocdr, off += 2);
                    long cdEntries = LittleEndian.readUShort(eocdr, off += 2);
                    off += 2;
                    if (diskNo != 0L || cdDiskNo != 0L || cdEntriesDisk != cdEntries) {
                        throw new ZipException("ZIP file spanning/splitting is not supported!");
                    }
                    long cdSize = LittleEndian.readUInt(eocdr, off);
                    long cdOffset = LittleEndian.readUInt(eocdr, off += 4);
                    int commentLen = LittleEndian.readUShort(eocdr, off += 4);
                    if (commentLen > 0) {
                        byte[] comment = new byte[commentLen];
                        rof.readFully(comment);
                        this.setComment(new String(comment, this.charset));
                    }
                    this.postamble = length - rof.getFilePointer();
                    try {
                        byte[] zip64eocdl = new byte[20];
                        rof.seek(eocdrOffset - 20L);
                        rof.readFully(zip64eocdl);
                        off = 0;
                        long zip64eocdlSig = LittleEndian.readUInt(zip64eocdl, off);
                        off += 4;
                        if (zip64eocdlSig != 117853008L) {
                            throw new IOException("Expected ZIP64 End Of Central Directory Locator signature!");
                        }
                        long zip64eocdrDisk = LittleEndian.readUInt(zip64eocdl, off);
                        long zip64eocdrOffset = LittleEndian.readLong(zip64eocdl, off += 4);
                        long totalDisks = LittleEndian.readUInt(zip64eocdl, off += 8);
                        if (zip64eocdrDisk != 0L || totalDisks != 1L) {
                            throw new ZipException("ZIP file spanning/splitting is not supported!");
                        }
                        byte[] zip64eocdr = new byte[56];
                        rof.seek(zip64eocdrOffset);
                        rof.readFully(zip64eocdr);
                        off = 0;
                        long zip64eocdrSig = LittleEndian.readUInt(zip64eocdr, off);
                        off += 4;
                        if (zip64eocdrSig != 101075792L) {
                            throw new ZipException("Expected ZIP64 End Of Central Directory Record signature!");
                        }
                        off += 8;
                        off += 2;
                        diskNo = LittleEndian.readUInt(zip64eocdr, off += 2);
                        cdDiskNo = LittleEndian.readUInt(zip64eocdr, off += 4);
                        cdEntriesDisk = LittleEndian.readLong(zip64eocdr, off += 4);
                        cdEntries = LittleEndian.readLong(zip64eocdr, off += 8);
                        off += 8;
                        if (diskNo != 0L || cdDiskNo != 0L || cdEntriesDisk != cdEntries) {
                            throw new ZipException("ZIP file spanning/splitting is not supported!");
                        }
                        if (cdEntries < 0L || Integer.MAX_VALUE < cdEntries) {
                            throw new ZipException("Total Number Of Entries In The Central Directory out of range!");
                        }
                        cdSize = LittleEndian.readLong(zip64eocdr, off);
                        cdOffset = LittleEndian.readLong(zip64eocdr, off += 8);
                        rof.seek(cdOffset);
                        this.mapper = new OffsetMapper(null, null);
                    }
                    catch (ZipException ze) {
                        throw ze;
                    }
                    catch (IOException iOException) {
                        long start = eocdrOffset - cdSize;
                        rof.seek(start);
                        this.mapper = (start -= cdOffset) != 0L ? new IrregularOffsetMapper(start) : new OffsetMapper(null, null);
                    }
                    return (int)cdEntries;
                }
                --eocdrOffset;
            }
        }
        throw new ZipException("Expected End Of Central Directory Record signature!");
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }

    public boolean busy() {
        return this.openStreams > 0;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getEncoding() {
        return this.getCharset();
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String name) {
        return (ZipEntry)this.entries.get(name);
    }

    public int size() {
        return this.entries.size();
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.archive.length();
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(this.archive.length() - this.postamble, this.postamble);
    }

    public boolean offsetsConsiderPreamble() {
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, false, true);
    }

    public final InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), false, true);
    }

    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    public final InputStream getCheckedInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), true, true);
    }

    public InputStream getInputStream(String name, boolean inflate) throws IOException {
        return this.getInputStream(name, false, inflate);
    }

    public final InputStream getInputStream(ZipEntry entry, boolean inflate) throws IOException {
        return this.getInputStream(entry.getName(), false, inflate);
    }

    protected InputStream getInputStream(String name, boolean check, boolean inflate) throws IOException {
        this.ensureOpen();
        if (name == null) {
            throw new NullPointerException();
        }
        ZipEntry entry = (ZipEntry)this.entries.get(name);
        if (entry == null) {
            return null;
        }
        long offset = entry.getOffset();
        offset = this.mapper.location(offset);
        this.archive.seek(offset);
        byte[] lfh = new byte[30];
        this.archive.readFully(lfh);
        long lfhSig = LittleEndian.readUInt(lfh, 0);
        if (lfhSig != 67324752L) {
            throw new ZipException(String.valueOf(name) + ": Expected Local File Header Signature!");
        }
        offset += (long)(30 + LittleEndian.readUShort(lfh, 26) + LittleEndian.readUShort(lfh, 28));
        if (check) {
            long localCrc;
            if (entry.getGeneralBit(3)) {
                byte[] dd = new byte[8];
                this.archive.seek(offset + entry.getCompressedSize());
                this.archive.readFully(dd);
                long ddSig = LittleEndian.readUInt(dd, 0);
                localCrc = ddSig == 134695760L ? LittleEndian.readUInt(dd, 4) : ddSig;
            } else {
                localCrc = LittleEndian.readUInt(lfh, 14);
            }
            if (entry.getCrc() != localCrc) {
                throw new CRC32Exception(name, entry.getCrc(), localCrc);
            }
        }
        IntervalInputStream iis = new IntervalInputStream(offset, entry.getCompressedSize());
        int bufSize = BasicZipFile.getBufferSize(entry);
        InputStream in = iis;
        switch (entry.getMethod()) {
            case 8: {
                if (inflate) {
                    iis.addDummy();
                    in = new PooledInflaterInputStream(in, bufSize);
                    if (!check) break;
                    in = new CheckedInputStream(in, entry, bufSize);
                    break;
                }
                if (!check) break;
                in = new RawCheckedInputStream(in, entry, bufSize);
                break;
            }
            case 0: {
                if (!check) break;
                in = new CheckedInputStream(in, entry, bufSize);
            }
        }
        return in;
    }

    private static final int getBufferSize(ZipEntry entry) {
        long size = entry.getSize();
        if (size > 65536L) {
            size = 65536L;
        } else if (size < 8192L) {
            size = 8192L;
        }
        return (int)size;
    }

    private final void ensureOpen() throws ZipException {
        if (this.archive == null) {
            throw new ZipException("ZIP file has been closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Inflater allocateInflater() {
        Inflater inflater = null;
        List list = releasedInflaters;
        synchronized (list) {
            Iterator i = releasedInflaters.iterator();
            while (i.hasNext()) {
                inflater = (Inflater)((Reference)i.next()).get();
                i.remove();
                if (inflater != null) break;
            }
            if (inflater == null) {
                inflater = new Inflater(true);
            }
            allocatedInflaters.add(inflater);
        }
        return inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseInflater(Inflater inflater) {
        inflater.reset();
        List list = releasedInflaters;
        synchronized (list) {
            releasedInflaters.add(new SoftReference<Inflater>(inflater));
            allocatedInflaters.remove(inflater);
        }
    }

    private static long skipWithBuffer(InputStream in, long toSkip, byte[] buf) throws IOException {
        long len;
        long total = 0L;
        while ((len = toSkip - total) > 0L) {
            if ((len = (long)in.read(buf, 0, len < (long)buf.length ? (int)len : buf.length)) < 0L) break;
            total += len;
        }
        return total;
    }

    public void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile oldArchive = this.archive;
            this.archive = null;
            oldArchive.close();
        }
    }

    private abstract class AccountedInputStream
    extends InputStream {
        private boolean closed;

        public AccountedInputStream() {
            BasicZipFile basicZipFile2 = BasicZipFile.this;
            basicZipFile2.openStreams = basicZipFile2.openStreams + 1;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                BasicZipFile basicZipFile = BasicZipFile.this;
                basicZipFile.openStreams = basicZipFile.openStreams - 1;
                super.close();
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static final class CheckedInputStream
    extends java.util.zip.CheckedInputStream {
        private final ZipEntry entry;
        private final int size;

        public CheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in, new CRC32());
            this.entry = entry;
            this.size = size;
        }

        @Override
        public long skip(long toSkip) throws IOException {
            return BasicZipFile.skipWithBuffer(this, toSkip, new byte[this.size]);
        }

        @Override
        public void close() throws IOException {
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            long actualCrc = this.getChecksum().getValue();
            if (expectedCrc != actualCrc) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }
    }

    private class IntervalInputStream
    extends AccountedInputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;

        IntervalInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.fp = start;
        }

        @Override
        public int read() throws IOException {
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int ret = BasicZipFile.this.archive.read();
            if (ret >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                if (len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return 0;
            }
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int ret = BasicZipFile.this.archive.read(b, off, len);
            if (ret > 0) {
                this.fp += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        @Override
        public int available() throws IOException {
            BasicZipFile.this.ensureOpen();
            long available = this.remaining;
            if (this.addDummyByte) {
                ++available;
            }
            return available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)available;
        }
    }

    private static class IrregularOffsetMapper
    extends OffsetMapper {
        final long start;

        IrregularOffsetMapper(long start) {
            this.start = start;
        }

        @Override
        long location(long offset) {
            return this.start + offset;
        }
    }

    private static class OffsetMapper {
        private OffsetMapper() {
        }

        long location(long offset) {
            return offset;
        }

        /* synthetic */ OffsetMapper(OffsetMapper offsetMapper, OffsetMapper offsetMapper2) {
            this();
        }
    }

    private static final class PooledInflaterInputStream
    extends InflaterInputStream {
        private boolean closed;

        public PooledInflaterInputStream(InputStream in, int size) {
            super(in, BasicZipFile.allocateInflater(), size);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                BasicZipFile.releaseInflater(this.inf);
            }
        }
    }

    private static final class RawCheckedInputStream
    extends FilterInputStream {
        private final Checksum crc = new CRC32();
        private final byte[] singleByteBuf = new byte[1];
        private final Inflater inf = BasicZipFile.access$0();
        private final byte[] infBuf;
        private final ZipEntry entry;
        private boolean closed;

        public RawCheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in);
            this.infBuf = new byte[size];
            this.entry = entry;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("input stream has been closed");
            }
        }

        @Override
        public int read() throws IOException {
            int read;
            while ((read = this.read(this.singleByteBuf, 0, 1)) == 0) {
            }
            return read > 0 ? this.singleByteBuf[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            this.ensureOpen();
            if (buf == null) {
                throw new NullPointerException();
            }
            int offPlusLen = off + len;
            if ((off | len | offPlusLen | buf.length - offPlusLen) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int read = this.in.read(buf, off, len);
            if (read >= 0) {
                this.inf.setInput(buf, off, read);
            } else {
                buf[off] = 0;
                this.inf.setInput(buf, off, 1);
            }
            try {
                int inflated;
                while ((inflated = this.inf.inflate(this.infBuf, 0, this.infBuf.length)) > 0) {
                    this.crc.update(this.infBuf, 0, inflated);
                }
            }
            catch (DataFormatException dfe) {
                IOException ioe = new IOException(dfe.toString());
                ioe.initCause(dfe);
                throw ioe;
            }
            return read;
        }

        @Override
        public long skip(long toSkip) throws IOException {
            return BasicZipFile.skipWithBuffer(this, toSkip, new byte[this.infBuf.length]);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                this.closed = true;
                BasicZipFile.releaseInflater(this.inf);
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            long actualCrc = this.crc.getValue();
            if (expectedCrc != actualCrc) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark()/reset() not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

