/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.rampackage;

import com.ibm.ram.client.LocalArchiveFolderArtifact;
import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.configuration.BuildEnvironment;
import com.ibm.ram.internal.cli.configuration.Configuration;
import com.ibm.ram.internal.cli.rampackage.Dependency;
import com.ibm.ram.internal.cli.rampackage.PackageDescriptor;
import com.ibm.ram.internal.cli.rampackage.Person;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class Package {
    private PackageDescriptor packageDescriptor;
    private String descriptorName = null;
    private String location = null;
    private boolean isZip = false;
    private RAMAsset asset = null;
    private static final String DEFAULT_TYPE = "Implementation";
    private static final String GROUP_ID_ATTRIBUTE = "Group.Id";

    public Package(String location) {
        if (location.endsWith(".zip")) {
            this.descriptorName = this.getDescriptorFromZip(location);
            this.location = location;
            this.isZip = true;
        } else {
            this.descriptorName = location;
            int lastFileSeparator = location.lastIndexOf(File.separatorChar);
            this.location = lastFileSeparator > -1 ? location.substring(0, lastFileSeparator) : location;
        }
        this.packageDescriptor = new PackageDescriptor(this.descriptorName);
    }

    public IStatus readPackageDescriptor() {
        Object status = this.packageDescriptor.getPackageDescriptorName() == null ? new Status(4, this.getClass().getName(), Messages.getString("Package.2")) : this.packageDescriptor.read();
        return status;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public PackageDescriptor getPackageDescriptor() {
        return this.packageDescriptor;
    }

    public static RAMCommunity getCommunity(RAMSession session, String name, String defaultName) {
        RAMCommunity community = null;
        try {
            RAMCommunity[] validCommunities;
            community = session.getCommunity(name);
            if (community == null) {
                community = session.getCommunity(defaultName);
            }
            if (community == null && (validCommunities = session.getCommunitiesUserCanSubmitTo()).length > 0) {
                community = validCommunities[0];
            }
        }
        catch (Exception exception) {}
        return community;
    }

    private RAMAssetType getAssetType(RAMSession session, String name) {
        RAMAssetType type;
        block5: {
            type = null;
            if (name == null) {
                name = DEFAULT_TYPE;
            }
            try {
                RAMAssetType[] allTypes;
                type = session.getAssetType(name);
                if (type != null) break block5;
                RAMAssetType[] rAMAssetTypeArray = allTypes = session.getAllAssetTypes();
                int n = allTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    RAMAssetType aType = rAMAssetTypeArray[n2];
                    if (aType.getName().equalsIgnoreCase(name)) {
                        type = aType;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return type;
    }

    public RAMAsset getAsset() {
        return this.asset;
    }

    public String getId() {
        return this.packageDescriptor.getId();
    }

    public String getVersion() {
        return this.packageDescriptor.getVersion();
    }

    public List<Dependency> getDependencies() {
        return this.packageDescriptor.getDependencies();
    }

    public boolean hasDependencies() {
        List<Dependency> dependencies = this.getDependencies();
        boolean hasDependencies = true;
        if (dependencies == null || dependencies.isEmpty()) {
            hasDependencies = false;
        }
        return hasDependencies;
    }

    public List getOwners() {
        return this.packageDescriptor.getOwners();
    }

    public Status create(RAMSession session, Configuration config) {
        return this.create(session, config, false);
    }

    public Status create(RAMSession session, Configuration config, boolean overwrite) {
        ArrayList<Status> allStatus = new ArrayList<Status>();
        boolean error = false;
        this.asset = null;
        if (session != null) {
            try {
                String shortDescription;
                boolean newAsset = false;
                if (!overwrite) {
                    AssetIdentification assetId = new AssetIdentification(this.packageDescriptor.getId(), this.packageDescriptor.getVersion());
                    try {
                        this.asset = session.getAsset(assetId);
                    }
                    catch (Exception exception) {}
                }
                if (this.asset == null) {
                    this.asset = session.createAsset(this.packageDescriptor.getId(), this.packageDescriptor.getVersion());
                    newAsset = true;
                }
                if (newAsset) {
                    this.asset.setName(this.packageDescriptor.getId());
                }
                if ((shortDescription = this.packageDescriptor.getDescription()) == null && newAsset) {
                    shortDescription = this.packageDescriptor.getId();
                }
                if (shortDescription != null) {
                    this.asset.setShortDescription(shortDescription);
                }
                this.asset.setCommunity((CommunityInformation)Package.getCommunity(session, this.packageDescriptor.getCommunity(), config.getCommunity()));
                String assetTypeName = this.packageDescriptor.getType();
                RAMAssetType assetType = this.getAssetType(session, assetTypeName);
                if (assetType != null) {
                    this.asset.setAssetType((AssetType)assetType);
                } else {
                    if (assetTypeName != null) {
                        allStatus.add(new Status(4, this.getClass().getName(), Messages.getString("Package.5")));
                    } else {
                        String message = MessageFormat.format(Messages.getString("Package.6"), DEFAULT_TYPE);
                        allStatus.add(new Status(4, this.getClass().getName(), message));
                    }
                    error = true;
                }
                HashMap<String, String[]> assetAttributes = BuildEnvironment.getInstance().getAssetAttributes();
                for (Map.Entry<String, String[]> entry : assetAttributes.entrySet()) {
                    AssetAttribute attribute = this.asset.getAssetAttribute(entry.getKey());
                    if (attribute == null) continue;
                    attribute.setValues(entry.getValue());
                }
                String groupId = this.packageDescriptor.getGroupId();
                if (groupId != null) {
                    AssetAttribute attribute = this.asset.getAssetAttribute(GROUP_ID_ATTRIBUTE);
                    if (attribute == null) {
                        AssetAttribute newAttr = new AssetAttribute();
                        newAttr.setName(GROUP_ID_ATTRIBUTE);
                        newAttr.setValues(new String[]{groupId});
                        this.asset.setAssetAttributes(new AssetAttribute[]{newAttr});
                    } else {
                        attribute.setValues(new String[]{groupId});
                    }
                }
                ArrayList<Object> ownerInfo = new ArrayList<Object>();
                List owners = this.getOwners();
                if (owners != null && owners.size() > 0) {
                    for (Person aPerson : owners) {
                        String userid = aPerson.getEmail();
                        if (userid == null) {
                            userid = aPerson.getName();
                        }
                        if (userid == null) continue;
                        RAMUser aUser = session.getUser(userid);
                        if (aUser.isRegistered()) {
                            UserInformation anOwner = new UserInformation();
                            anOwner.setUid(aUser.getUid());
                            ownerInfo.add(anOwner);
                            continue;
                        }
                        String message = MessageFormat.format(Messages.getString("Package.4"), userid, this.getId());
                        allStatus.add(new Status(0, this.getClass().getName(), message));
                    }
                }
                if (ownerInfo.size() == 0) {
                    ownerInfo.add(session.getUser());
                }
                try {
                    this.asset.setOwners(ownerInfo.toArray(new UserInformation[ownerInfo.size()]));
                }
                catch (Exception exception) {}
                RAMFolderArtifact root = (RAMFolderArtifact)this.asset.getArtifactsRoot();
                File fLocation = new File(this.location);
                if (this.isZip) {
                    LocalArchiveFolderArtifact fileArtifact = new LocalArchiveFolderArtifact(fLocation);
                    fileArtifact.setName(fLocation.getName());
                    root.addArtifact((Artifact)fileArtifact);
                } else {
                    String[] nodes;
                    String[] stringArray = nodes = fLocation.list();
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String node = stringArray[n2];
                        File f = new File(fLocation, node);
                        if (f.isFile()) {
                            LocalFileArtifact fileArtifact = new LocalFileArtifact(f);
                            fileArtifact.setName(f.getName());
                            root.addArtifact((Artifact)fileArtifact);
                        } else if (f.isDirectory()) {
                            LocalFolderArtifact folderArtifact = new LocalFolderArtifact(f);
                            root.addArtifact((Artifact)folderArtifact);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                String message = MessageFormat.format(Messages.getString("Package.1"), this.getId());
                if (e.getLocalizedMessage() != null) {
                    message = String.valueOf(message) + "\n" + e.getLocalizedMessage();
                }
                error = true;
                allStatus.add(new Status(4, this.getClass().getName(), message));
            }
        }
        return new MultiStatus(this.getClass().getName(), error ? 4 : 0, (IStatus[])allStatus.toArray(new Status[allStatus.size()]), null, null);
    }

    private String getDescriptorFromZip(String zipFileName) {
        ZipEntry ze;
        ZipFile zf;
        String descriptorName;
        block4: {
            descriptorName = null;
            zf = new ZipFile(zipFileName);
            ze = Package.getDescriptorFromZip(zf);
            if (ze != null) break block4;
            return null;
        }
        try {
            String line;
            File descriptor = File.createTempFile("package", ze.getName());
            FileWriter fw = new FileWriter(descriptor.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
            while ((line = br.readLine()) != null) {
                bw.write(line);
            }
            bw.flush();
            bw.close();
            br.close();
            descriptorName = descriptor.getCanonicalPath();
        }
        catch (Exception exception) {}
        return descriptorName;
    }

    public static ZipEntry getDescriptorFromZip(ZipFile zf) {
        ZipEntry ze = zf.getEntry("package.json");
        if (ze == null) {
            ze = zf.getEntry("pom.xml");
        }
        if (ze == null) {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry anEntry = entries.nextElement();
                String name = anEntry.getName();
                if (!name.endsWith(".pom") || name.indexOf("/") != -1 || name.indexOf("\\") != -1) continue;
                ze = anEntry;
                break;
            }
        }
        return ze;
    }

    public String toString() {
        return this.descriptorName;
    }
}

