/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.util;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.util.CategoryHelper;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AttributeHelper {
    public static final String SEPARATOR = "=";
    private String name = null;
    private String value = null;

    public AttributeHelper(String sAttribute) {
        if (sAttribute != null) {
            int index = CategoryHelper.indexOfSeparator(SEPARATOR, 0, sAttribute);
            if (index > -1) {
                this.name = sAttribute.substring(0, index);
                if (++index < sAttribute.length()) {
                    this.value = sAttribute.substring(index);
                }
            } else {
                this.name = sAttribute;
            }
            if (this.name != null && this.name.isEmpty()) {
                this.name = null;
            }
            if (this.value != null && this.value.isEmpty()) {
                this.value = null;
            }
            if (this.name != null) {
                this.name = this.name.replaceAll("\\\\=", SEPARATOR);
            }
            if (this.value != null) {
                this.value = this.value.replaceAll("\\\\=", SEPARATOR);
            }
        }
    }

    public IStatus setAttribute(RAMAsset asset) {
        Status status = null;
        String warningMessage = null;
        String errorMessage = null;
        String exceptionMessage = null;
        if (this.name == null || this.value == null) {
            errorMessage = Messages.getString("AttributeHelper.1");
        } else {
            try {
                AssetAttribute theAttribute = asset.getAssetAttribute(this.name);
                if (theAttribute == null) {
                    AssetAttribute newAttr = new AssetAttribute();
                    newAttr.setName(this.name);
                    newAttr.setValues(new String[]{this.value});
                    asset.setAssetAttributes(new AssetAttribute[]{newAttr});
                    warningMessage = MessageFormat.format(Messages.getString("AttributeHelper.4"), this.name, asset.getTypeName());
                } else {
                    theAttribute.setValues(new String[]{this.value});
                }
            }
            catch (Exception e) {
                errorMessage = MessageFormat.format(Messages.getString("AttributeHelper.3"), this.name);
                exceptionMessage = e.getLocalizedMessage();
            }
        }
        if (errorMessage == null) {
            status = new Status(0, this.getClass().getName(), warningMessage);
        } else {
            if (exceptionMessage != null) {
                errorMessage = String.valueOf(exceptionMessage) + "\n" + errorMessage;
            }
            status = new Status(4, this.getClass().getName(), errorMessage);
        }
        return status;
    }
}

