/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.util;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.internal.cli.bundles.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CategoryHelper {
    public static final String SEPARATOR = "/";
    private String schema = null;
    private String category = null;
    private String subCategory = null;

    public CategoryHelper(String path) {
        if (path != null) {
            int firstSlash = CategoryHelper.indexOfSeparator(SEPARATOR, 0, path);
            if (firstSlash > -1) {
                this.schema = path.substring(0, firstSlash);
                int categoryStart = firstSlash + 1;
                if (categoryStart < path.length()) {
                    int secondSlash = CategoryHelper.indexOfSeparator(SEPARATOR, categoryStart, path);
                    if (secondSlash > -1) {
                        this.category = path.substring(categoryStart, secondSlash);
                        int subCategoryStart = secondSlash + 1;
                        if (subCategoryStart < path.length()) {
                            this.subCategory = path.substring(subCategoryStart);
                        }
                    } else {
                        this.category = path.substring(categoryStart);
                    }
                }
            } else {
                this.schema = path;
            }
            if (this.schema != null && this.schema.isEmpty()) {
                this.schema = null;
            }
            if (this.category != null && this.category.isEmpty()) {
                this.category = null;
            }
            if (this.subCategory != null && this.subCategory.isEmpty()) {
                this.subCategory = null;
            }
            if (this.schema != null) {
                this.schema = this.schema.replaceAll("\\\\/", SEPARATOR);
            }
            if (this.category != null) {
                this.category = this.category.replaceAll("\\\\/", SEPARATOR);
            }
        }
    }

    public static int indexOfSeparator(String separator, int startingIndex, String path) {
        if (startingIndex < 0) {
            return -1;
        }
        int index = -1;
        while (index == -1 && startingIndex < path.length()) {
            int separatorIndex = path.indexOf(separator, startingIndex);
            if (separatorIndex > -1) {
                if (separatorIndex == 0) {
                    index = 0;
                    continue;
                }
                if (path.charAt(separatorIndex - 1) == '\\') {
                    startingIndex = separatorIndex + 1;
                    continue;
                }
                index = separatorIndex;
                continue;
            }
            startingIndex = path.length();
        }
        return index;
    }

    public boolean isValid() {
        return this.schema != null && this.category != null && this.subCategory != null;
    }

    public IStatus setCategory(RAMSession session, RAMAsset asset) {
        return this.setCategory(session, asset, false);
    }

    public IStatus setCategory(RAMSession session, RAMAsset asset, boolean forced) {
        Status status = null;
        String errorMessage = null;
        String exceptionMessage = null;
        if (this.isValid()) {
            RAMCategorySchema ramSchema = session.getCategorySchema(this.schema);
            if (ramSchema != null) {
                Category ramCategory = ramSchema.getCategory(this.category);
                if (ramCategory != null) {
                    try {
                        asset.categorize(ramCategory, this.subCategory, forced);
                    }
                    catch (Exception e) {
                        errorMessage = MessageFormat.format(Messages.getString("CategoryHelper.4"), this.subCategory);
                        exceptionMessage = e.getLocalizedMessage();
                    }
                } else {
                    errorMessage = MessageFormat.format(Messages.getString("CategoryHelper.1"), this.category);
                }
            } else {
                errorMessage = MessageFormat.format(Messages.getString("CategoryHelper.2"), this.schema);
            }
        } else {
            errorMessage = Messages.getString("CategoryHelper.3");
        }
        if (errorMessage == null) {
            status = new Status(0, this.getClass().getName(), null);
        } else {
            if (exceptionMessage != null) {
                errorMessage = String.valueOf(exceptionMessage) + "\n" + errorMessage;
            }
            status = new Status(4, this.getClass().getName(), errorMessage);
        }
        return status;
    }
}

