/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.util.Properties;
import java.util.StringTokenizer;

public class GetAttributesCommand
extends OutputCleartoolCommand {
    private String branchName;
    private VOB vob;
    private String objectSelector = null;

    public GetAttributesCommand(String branchName, VOB vob) {
        this.branchName = branchName;
        this.vob = vob;
        this.objectSelector = "brtype:" + branchName + "@" + vob.getTag();
    }

    public GetAttributesCommand(String objectSelector) {
        this.objectSelector = objectSelector;
    }

    @Override
    public String[] getArguments() {
        return new String[]{"describe", "-aattr", "-all", this.objectSelector};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new GetAttributesOutput(){

            @Override
            public Properties getAttributes() {
                Properties attributes = null;
                if (output != null) {
                    attributes = new Properties();
                    StringTokenizer newlineTokenizer = new StringTokenizer(output, "\r\n", false);
                    while (newlineTokenizer.hasMoreTokens()) {
                        String line = newlineTokenizer.nextToken();
                        int equalsIndex = line.indexOf(61);
                        if (equalsIndex <= -1) continue;
                        String key = line.substring(0, equalsIndex);
                        String value = line.substring(equalsIndex + 1);
                        attributes.put(key.trim(), value.trim());
                    }
                }
                return attributes;
            }
        };
    }

    public static interface GetAttributesOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Properties getAttributes();
    }
}

