/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Description;
import com.ibm.ram.internal.client.ant.types.Name;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Server;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Community
extends RAMDataType {
    private String name;
    private Description description;
    private Name newName;
    private Description newDescription;
    private RAMCommunity community;

    public void addText(String text) {
        this.setName(this.getProject().replaceProperties(text));
    }

    public void add(Name name) {
        if (this.newName != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)name);
        } else {
            this.newName = name;
        }
    }

    @Override
    public Object getModel() {
        return this.getCommunity();
    }

    @Override
    public List getChildren() {
        return null;
    }

    public String getNewName() {
        if (this.newName != null) {
            return this.newName.getValue();
        }
        return null;
    }

    public String getNewDescription() {
        if (this.newDescription != null) {
            return this.newDescription.getValue();
        }
        return null;
    }

    public void setServer(String serverId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Object ref = this.getProject().getReference(serverId);
        if (ref == null || !(ref instanceof Server)) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ServerNotDefined"), serverId));
        }
        this.setSession(((Server)((Object)ref)).getSession());
    }

    public RAMCommunity getCommunity() {
        if (this.isReference()) {
            return this.getRef().getCommunity();
        }
        if (this.community != null) {
            return this.community;
        }
        if (this.name != null) {
            try {
                this.community = this.getSession().getCommunity(this.name);
            }
            catch (RAMRuntimeException e) {
                LoggingUtil.errorGettingObject((ProjectComponent)this, this.name, e);
            }
        }
        return this.community;
    }

    public void setCommunity(RAMCommunity community) {
        this.community = community;
    }

    public String getName() {
        if (this.isReference()) {
            return this.getRef().getName();
        }
        if (this.name != null) {
            return this.name;
        }
        try {
            return this.getCommunity().getName();
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
            return null;
        }
    }

    public String getDescription() {
        if (this.isReference()) {
            return this.getRef().getDescription();
        }
        if (this.description != null) {
            return this.description.getValue();
        }
        try {
            if (this.getCommunity() != null) {
                return this.getCommunity().getDescription();
            }
        }
        catch (RAMRuntimeException e) {
            LoggingUtil.error((ProjectComponent)this, (Throwable)e);
        }
        return null;
    }

    protected Community getRef() {
        return (Community)((Object)this.getCheckedRef(Community.class, Community.class.getName()));
    }

    public void setName(String name) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.name = name;
    }

    public void add(Description description) {
        if (this.newDescription != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)description);
        } else {
            this.newDescription = description;
        }
    }
}

