/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.common.data.ArtifactReference;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Artifact;
import com.ibm.ram.internal.client.ant.types.Description;
import com.ibm.ram.internal.client.ant.types.Kind;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Value;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Reference
extends RAMDataType {
    private com.ibm.ram.common.data.Artifact artifact;
    private String description;
    private Description newDescription;
    private String kind;
    private Kind newKind;
    private String value;
    private Value newValue;
    private ArtifactReference artifactReference;

    public void add(Description description) {
        if (this.newDescription != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)description);
        } else {
            this.newDescription = description;
        }
    }

    public void add(Kind kind) {
        if (this.newKind != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)kind);
        } else {
            this.newKind = kind;
        }
    }

    public void add(Value value) {
        if (this.newValue != null) {
            LoggingUtil.warnOnlyOneChildAllowed((ProjectComponent)this, (ProjectComponent)value);
        } else {
            this.newValue = value;
        }
    }

    @Override
    public void commitModel() {
        this.getArtifactReference().setDescription(this.newDescription.getValue());
        this.getArtifactReference().setKind(this.newKind.getValue());
        this.getArtifactReference().setValue(this.newValue.getValue());
    }

    @Override
    public List getChildren() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKind() {
        return this.kind;
    }

    @Override
    public Object getModel() {
        return this.getArtifactReference();
    }

    public ArtifactReference getArtifactReference() {
        if (this.isReference()) {
            return this.getRef().getArtifactReference();
        }
        if (this.artifactReference != null) {
            return this.artifactReference;
        }
        if (this.artifact == null) {
            this.artifact = ((Artifact)this.getParent()).getArtifact();
        }
        if (this.artifact != null) {
            this.artifactReference = this.artifact.getReference();
        }
        return this.artifactReference;
    }

    protected Reference getRef() {
        return (Reference)((Object)this.getCheckedRef(Reference.class, Reference.class.getName()));
    }

    public String getValue() {
        return this.value;
    }

    public void setArtifact(com.ibm.ram.common.data.Artifact artifact) {
        this.artifact = artifact;
        this.artifactReference = null;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

