/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client.ant.types;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.internal.client.ant.LoggingUtil;
import com.ibm.ram.internal.client.ant.types.Attribute;
import com.ibm.ram.internal.client.ant.types.Category;
import com.ibm.ram.internal.client.ant.types.RAMDataType;
import com.ibm.ram.internal.client.ant.types.Server;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;

public class Search
extends RAMDataType {
    private static final String TERM_ATTRIBUTE_NAME = "attributeName";
    private static final String TERM_ATTRIBUTE_VALUE = "attributeValue";
    private static final String TERM_COMMUNITY = "community";
    private static final String TERM_DESCRIPTION = "description";
    private static final String TERM_GUID = "id";
    private static final String TERM_LAST_MODIFIED_BY = "lastModifiedBy";
    private static final String TERM_NAME = "name";
    private static final String TERM_OWNER = "owner";
    private static final String TERM_TYPE = "type";
    private static final String TERM_RATING = "rating";
    private static final String TERM_STATE = "state";
    private static final String TERM_VERSION = "version";
    private static final String TERM_RELEVANCE = "score";
    private static final String SORT_DIRECTION_ASC = "asc";
    private static final String SORT_DIRECTION_ASCENDING = "ascending";
    private static final String SORT_DIRECTION_DESC = "desc";
    private static final String SORT_DIRECTION_DESCENDING = "descending";
    private List terms = new ArrayList();
    private String query;
    private List categories = new ArrayList();
    private String maxResults;
    private String sortDirection = "ascending";
    private String sortVariable = "name";
    private RAMAsset[] results;

    public void addConfigured(Attribute attribute) {
        String[] values;
        if (attribute.getName() != null && attribute.getName().length() > 0) {
            this.addSearchTerm(TERM_ATTRIBUTE_NAME, attribute.getName());
        }
        if ((values = attribute.getValues()) != null && values.length > 0) {
            this.addSearchTerm(TERM_ATTRIBUTE_VALUE, values[0]);
        }
    }

    public void addConfigured(Category category) {
        category.setParent(this);
        this.categories.add(category);
    }

    private void addSearchTerm(String name, String value) {
        this.terms.add(new String[]{name, value});
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.categories);
        return children;
    }

    protected Search getRef() {
        return (Search)((Object)this.getCheckedRef(Search.class, Search.class.getName()));
    }

    public RAMAsset[] getAssets() {
        if (this.isReference()) {
            return this.getRef().getAssets();
        }
        if (this.results == null) {
            RAMAssetQueryBuilder queryBuilder = (RAMAssetQueryBuilder)this.getSession().createAssetQuery(null);
            if (this.query != null) {
                queryBuilder.addQueryTextField(this.query);
            }
            for (String[] term : this.terms) {
                queryBuilder.addQueryField(term[0], term[1]);
            }
            for (Category category : this.categories) {
                queryBuilder.addSearchFilter(category.getSubCategory());
            }
            if (this.maxResults != null && this.maxResults.length() > 0) {
                try {
                    queryBuilder.setMaxResults(Integer.parseInt(this.maxResults));
                }
                catch (NumberFormatException numberFormatException) {
                    LoggingUtil.warn((ProjectComponent)this, ClientMessages.getString((String)"Ant.ErrorSettingMaxSearchResults"));
                }
            }
            if (this.sortVariable != null) {
                if (this.sortVariable.equalsIgnoreCase(TERM_RELEVANCE)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_RELEVANCE);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_NAME)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_NAME);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_COMMUNITY)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_COMMUNITY_NAME);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_GUID)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_GUID);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_LAST_MODIFIED_BY)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_LAST_MODIFIED);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_RATING)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_RATING);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_STATE)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_STATE);
                } else if (this.sortVariable.equalsIgnoreCase(TERM_VERSION)) {
                    queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
                } else {
                    queryBuilder.setSortByField("[_" + this.sortVariable + "_");
                }
            }
            if (this.sortDirection != null) {
                if (SORT_DIRECTION_ASCENDING.equals(this.sortDirection) || SORT_DIRECTION_ASC.equals(this.sortDirection)) {
                    queryBuilder.setSortAscending(true);
                } else if (SORT_DIRECTION_DESCENDING.equals(this.sortDirection) || SORT_DIRECTION_DESC.equals(this.sortDirection)) {
                    queryBuilder.setSortAscending(false);
                } else {
                    LoggingUtil.warn((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.AttributeMustBeOneOfTheseValues"), "sortDirection", "ascending, asc, descending, desc"));
                }
            }
            SearchResult result = this.getSession().getAssets((SearchQuery)queryBuilder);
            this.results = (RAMAsset[])result.getAssets();
        }
        return this.results;
    }

    public String getQuery() {
        if (this.isReference()) {
            return this.getRef().getQuery();
        }
        return this.query.toString();
    }

    public void setDescription(String description) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_DESCRIPTION, description);
    }

    public void setGuid(String guid) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_GUID, guid);
    }

    public void setLastModifiedBy(String lastModified) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_LAST_MODIFIED_BY, lastModified);
    }

    public void setMaxResults(String maxResults) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.maxResults = maxResults;
    }

    public void setName(String name) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_NAME, name);
    }

    public void setOwner(String owner) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_OWNER, owner);
    }

    public void setType(String type) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_TYPE, type);
    }

    public void setState(String state) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_STATE, state);
    }

    public void setCommunity(String community) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_COMMUNITY, community);
    }

    public void setQuery(String query) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.query = query;
    }

    public void setServer(String serverId) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        Object ref = this.getProject().getReference(serverId);
        if (ref == null || !(ref instanceof Server)) {
            LoggingUtil.error((ProjectComponent)this, MessageFormat.format(ClientMessages.getString((String)"Ant.ServerNotDefined"), serverId));
        }
        this.setSession(((Server)((Object)ref)).getSession());
    }

    public void setSortVariable(String sortVariable) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.sortVariable = sortVariable;
    }

    public void setSortDirection(String sortDirection) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.sortDirection = sortDirection;
    }

    public void setVersion(String version) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.addSearchTerm(TERM_VERSION, version);
    }

    @Override
    public Object getModel() {
        return this.getAssets();
    }
}

