/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetSearchResult;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SearchCommand
extends Command {
    public static final String NAME = "search";
    public static final String OPTION_VERBOSE = "-v";
    public static boolean verbose = false;
    private AssetIdentification assetId = null;
    private static int maxResults = 100;

    public SearchCommand(String[] args) {
        super(args);
    }

    @Override
    public IStatus execute() {
        Status status = this.getRAMSession();
        if (!status.isOK()) {
            return status;
        }
        this.assetId = SearchCommand.getAssetIdentification(this.ramSession, this.packageId, this.packageVersion, this.queryString);
        if (this.assetId != null) {
            if (verbose) {
                RAMAsset anAsset = this.ramSession.getAsset(this.assetId);
                String message = MessageFormat.format(Messages.getString("SearchCommand.1"), this.assetId.getGUID(), this.assetId.getVersion(), anAsset.getName());
                status = new Status(0, this.getClass().getName(), message);
            } else {
                System.out.println(String.valueOf(this.assetId.getGUID()) + " " + this.assetId.getVersion());
            }
        } else {
            String message = null;
            if (verbose) {
                message = MessageFormat.format(Messages.getString("GetCommand.3"), this.packageId, this.packageVersion);
            }
            status = new Status(4, this.getClass().getName(), message);
        }
        this.releaseRAMSession();
        return status;
    }

    @Override
    public IStatus validate() {
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option(OPTION_VERBOSE));
        commandLine.addOption(new Option("-q", true));
        commandLine.addOption(new Option("-config", true));
        IStatus status = super.validate(commandLine);
        verbose = commandLine.getOption(OPTION_VERBOSE).isSet();
        if (!status.isOK()) {
            return status;
        }
        this.queryString = commandLine.getOption("-q").getValue();
        if ((this.packageId == null || this.packageId.isEmpty()) && (this.queryString == null || this.queryString.isEmpty())) {
            return new Status(4, this.getClass().getName(), Messages.getString("SearchCommand.2"));
        }
        this.createConfiguration(commandLine.getOption("-config").getValue());
        status = this.config.validate();
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    public AssetIdentification getAssetId() {
        return this.assetId;
    }

    public static AssetIdentification getAssetIdentification(RAMSession session, String id, String version, String queryString) {
        AssetIdentification assetId = null;
        List<AssetIdentification> assetList = SearchCommand.getAssetIdentification(session, id, version, queryString, false, 1);
        if (assetList != null && !assetList.isEmpty()) {
            assetId = assetList.get(0);
        }
        return assetId;
    }

    public static List<AssetIdentification> getAssetIdentification(RAMSession session, String id, String version, String queryString, boolean sortAscending, int numResults) {
        RAMAssetSearchResult[] assets;
        List<AssetIdentification> assetList = new ArrayList<AssetIdentification>();
        if (numResults == 0) {
            return assetList;
        }
        if (id == null && version == null && queryString == null) {
            return assetList;
        }
        if (!(id == null || id.length() <= 0 || version == null || version.length() <= 0 || version.contains("*") || queryString != null && queryString.length() != 0)) {
            AssetIdentification anId = new AssetIdentification(id, version);
            try {
                RAMAsset anAsset = session.getAsset(anId);
                if (anAsset != null) {
                    assetList.add(anAsset.getIdentification());
                }
            }
            catch (Exception exception) {}
            return assetList;
        }
        RAMAssetQueryBuilder queryBuilder = new RAMAssetQueryBuilder(session);
        SearchResult searchResult = null;
        String queryId = null;
        if (id != null && id.length() > 0) {
            id = id.replaceAll(" ", "\\\\ ");
            queryId = new String("id:(" + id + ")");
        }
        String queryVersion = null;
        if (version != null && version.length() > 0) {
            queryVersion = new String("version:(" + version + ")");
        }
        if (queryString == null || !queryString.startsWith("ramSearch:(")) {
            StringBuilder queryStringBuilder = new StringBuilder();
            if (queryString != null) {
                queryStringBuilder.append(queryString);
            }
            if (queryId != null) {
                queryStringBuilder.append(queryId);
            }
            if (queryVersion != null) {
                queryStringBuilder.append(queryVersion);
            }
            queryBuilder.addQueryTextField(queryStringBuilder.toString());
            queryBuilder.setSortAscending(sortAscending);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            queryBuilder.setSearchModes(16);
            if (numResults > -1 && numResults <= maxResults) {
                queryBuilder.setMaxResults(numResults);
                searchResult = session.getAssets((SearchQuery)queryBuilder);
            } else {
                assetList = SearchCommand.getPagedResults(session, (SearchQuery)queryBuilder, numResults);
            }
        } else {
            if (queryId != null || queryVersion != null) {
                StringBuilder sb = new StringBuilder("$txt,");
                if (queryId != null) {
                    sb.append(queryId);
                }
                if (queryVersion != null) {
                    sb.append(queryVersion);
                }
                StringBuilder queryStringBuilder = new StringBuilder(queryString);
                int insertIndex = queryString.lastIndexOf(")");
                if (insertIndex > -1) {
                    queryStringBuilder.insert(insertIndex, sb);
                } else {
                    queryStringBuilder.append((CharSequence)sb);
                }
                queryString = queryStringBuilder.toString();
            }
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.setQueryString(queryString);
            searchQuery.setSortAscending(sortAscending);
            queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
            searchQuery.setSearchModes(16);
            if (numResults > -1 && numResults <= maxResults) {
                searchQuery.setMaxResults(numResults);
                searchResult = session.getAssets(searchQuery);
            } else {
                assetList = SearchCommand.getPagedResults(session, searchQuery, numResults);
            }
        }
        if (searchResult != null && (assets = (RAMAssetSearchResult[])searchResult.getAssetSearchResults()) != null) {
            RAMAssetSearchResult[] rAMAssetSearchResultArray = assets;
            int n = assets.length;
            int n2 = 0;
            while (n2 < n) {
                RAMAssetSearchResult aResult = rAMAssetSearchResultArray[n2];
                assetList.add(aResult.getAsset().getIdentification());
                ++n2;
            }
        }
        return assetList;
    }

    /*
     * Unable to fully structure code
     */
    private static List<AssetIdentification> getPagedResults(RAMSession session, SearchQuery theQuery, int requestedResults) {
        assetList = new ArrayList<AssetIdentification>();
        theQuery.setMaxResults(SearchCommand.maxResults);
        pagedResult = null;
        try {
            pagedResult = session.getAssets(theQuery);
        }
        catch (Exception v0) {}
        if (pagedResult == null || pagedResult.getTotalResultsCount() == 0) {
            return assetList;
        }
        totalNumberOfAssets = pagedResult.getTotalResultsCount();
        if (requestedResults != -1) {
            totalNumberOfAssets = requestedResults;
        }
        assetRunningCount = 0;
        queryAssets = pagedResult.getAssetSearchResults();
        if (queryAssets != null && queryAssets.length != 0) ** GOTO lbl35
        return assetList;
lbl-1000:
        // 1 sources

        {
            j = 0;
            while (j < queryAssets.length && assetRunningCount < totalNumberOfAssets) {
                currentAsset = (RAMAsset)queryAssets[j].getAsset();
                assetList.add(currentAsset.getIdentification());
                ++assetRunningCount;
                ++j;
            }
            if (assetRunningCount >= totalNumberOfAssets) continue;
            try {
                theQuery.setResultsStartIndex(assetRunningCount);
                pagedResult = session.getAssets(theQuery);
                queryAssets = pagedResult.getAssetSearchResults();
                if (queryAssets == null) break;
                if (queryAssets.length != 0) continue;
            }
            catch (Throwable v1) {}
            break;
lbl35:
            // 3 sources

            ** while (assetRunningCount < totalNumberOfAssets)
        }
lbl36:
        // 4 sources

        return assetList;
    }
}

