/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.util;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMRelationship;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.SearchCommand;
import com.ibm.ram.internal.cli.util.CategoryHelper;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RelationshipHelper {
    public static final String SEPARATOR = ":";
    private static final int TYPE = 0;
    private static final int ID = 1;
    private static final int VERSION = 2;
    private static final int QUERY = 3;
    private static final int NUM_TOKENS = 4;
    private String[] tokens;
    private String related;

    public RelationshipHelper(String related) {
        this.related = related;
        this.tokens = new String[4];
        if (related != null) {
            int tokensFound = 0;
            int currentIndex = 0;
            while (currentIndex < related.length()) {
                String aToken;
                int separatorIndex = CategoryHelper.indexOfSeparator(SEPARATOR, currentIndex, related);
                if (tokensFound < 3 && separatorIndex > -1) {
                    if (currentIndex < separatorIndex) {
                        aToken = related.substring(currentIndex, separatorIndex);
                        if (aToken != null) {
                            aToken = aToken.replaceAll("\\\\:", SEPARATOR);
                        }
                        this.tokens[tokensFound] = aToken;
                    }
                    currentIndex = separatorIndex + 1;
                    ++tokensFound;
                    continue;
                }
                aToken = related.substring(currentIndex);
                if (aToken != null) {
                    aToken = aToken.replaceAll("\\\\:", SEPARATOR);
                }
                this.tokens[tokensFound] = aToken;
                currentIndex = related.length();
            }
        }
    }

    public String getType() {
        return this.tokens[0];
    }

    public String getId() {
        return this.tokens[1];
    }

    public String getVersion() {
        return this.tokens[2];
    }

    public String getQuery() {
        return this.tokens[3];
    }

    private boolean isValid() {
        return this.tokens[0] != null && (this.tokens[1] != null || this.tokens[2] != null || this.tokens[3] != null);
    }

    public IStatus setRelated(RAMSession session, RAMAsset asset) {
        String errorMessage;
        Status status;
        block11: {
            status = null;
            errorMessage = null;
            if (this.isValid()) {
                try {
                    RAMRelationshipType type = this.getRelationshipType(session, this.tokens[0]);
                    if (type == null) {
                        errorMessage = MessageFormat.format(Messages.getString("RelationshipHelper.2"), this.tokens[0]);
                    } else {
                        AssetIdentification assetId = SearchCommand.getAssetIdentification(session, this.tokens[1], this.tokens[2], this.tokens[3]);
                        if (assetId == null) {
                            errorMessage = MessageFormat.format(Messages.getString("RelationshipHelper.3"), this.related);
                        } else {
                            RAMAsset relatedAsset;
                            RAMRelationship relationship;
                            boolean addRelationship = true;
                            Relationship[] currentRelationships = asset.getRelationships();
                            int i = 0;
                            while (i < currentRelationships.length && addRelationship) {
                                Relationship aRelationship = currentRelationships[i];
                                if (aRelationship.getChildAssetGUID().equals(assetId.getGUID()) && aRelationship.getChildAssetVersion().equals(assetId.getVersion()) && aRelationship.getRelationshipTypeName().equalsIgnoreCase(this.tokens[0])) {
                                    addRelationship = false;
                                }
                                ++i;
                            }
                            if (addRelationship && (relationship = asset.addRelatedAsset((Asset)(relatedAsset = session.getAsset(assetId)), (RelationshipType)type)) == null) {
                                errorMessage = MessageFormat.format(Messages.getString("RelationshipHelper.4"), assetId.getGUID(), assetId.getVersion());
                            }
                        }
                    }
                    break block11;
                }
                catch (Exception e) {
                    errorMessage = MessageFormat.format(Messages.getString("RelationshipHelper.4"), this.tokens[1], this.tokens[2]);
                    String exceptionMessage = e.getLocalizedMessage();
                    if (exceptionMessage != null) {
                        errorMessage = String.valueOf(errorMessage) + "\n" + exceptionMessage;
                    }
                    break block11;
                }
            }
            errorMessage = Messages.getString("RelationshipHelper.1");
        }
        status = errorMessage == null ? new Status(0, this.getClass().getName(), null) : new Status(4, this.getClass().getName(), errorMessage);
        return status;
    }

    private RAMRelationshipType getRelationshipType(RAMSession session, String type) throws Exception {
        RAMRelationshipType relationshipType = session.getRelationshipType(type);
        if (relationshipType == null) {
            RAMRelationshipType[] allTypes;
            RAMRelationshipType[] rAMRelationshipTypeArray = allTypes = session.getAllRelationshipTypes();
            int n = allTypes.length;
            int n2 = 0;
            while (n2 < n) {
                RAMRelationshipType aType = rAMRelationshipTypeArray[n2];
                if (type.equalsIgnoreCase(aType.getName()) || type.equalsIgnoreCase(aType.getDisplayName())) {
                    relationshipType = aType;
                    break;
                }
                ++n2;
            }
        }
        return relationshipType;
    }
}

