/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.cli.command;

import com.ibm.ram.client.RAMPassword;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.cli.bundles.Messages;
import com.ibm.ram.internal.cli.command.Command;
import com.ibm.ram.internal.cli.commandline.CommandLine;
import com.ibm.ram.internal.cli.commandline.Option;
import com.ibm.ram.internal.cli.commandline.ParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ConfigCommand
extends Command {
    public static final String NAME = "config";
    public static final String OPTION_URL = "-url";
    public static final String OPTION_USER = "-u";
    public static final String OPTION_PASSWORD = "-p";
    public static final String OPTION_COMMUNITY = "-c";
    public static final String EQUAL_SIGN = " = ";
    protected String url;
    protected String user;
    protected String password;
    protected String community;
    private boolean showConfigurationOnly = false;

    public ConfigCommand(String[] cmdArgs) {
        super(cmdArgs);
    }

    @Override
    public IStatus execute() {
        Status status = null;
        if (this.showConfigurationOnly) {
            status = new Status(0, this.getClass().getName(), this.toString());
        } else {
            this.config.setUrl(this.url);
            this.config.setUser(this.user);
            this.config.setPassword(this.password);
            if (this.community != null) {
                this.config.setCommunity(this.community);
            }
            status = this.config.write();
        }
        return status;
    }

    @Override
    public IStatus validate() {
        String message;
        CommandLine commandLine = new CommandLine(this.cmdArgs);
        commandLine.addOption(new Option(OPTION_URL, true));
        commandLine.addOption(new Option(OPTION_USER, true));
        commandLine.addOption(new Option(OPTION_PASSWORD, true));
        commandLine.addOption(new Option(OPTION_COMMUNITY, true));
        commandLine.addOption(new Option("-config", true));
        try {
            commandLine.parse();
        }
        catch (ParseException pe) {
            return new Status(4, this.getClass().getName(), pe.getMessage());
        }
        this.createConfiguration(commandLine.getOption("-config").getValue());
        this.url = commandLine.getOption(OPTION_URL).getValue();
        this.user = commandLine.getOption(OPTION_USER).getValue();
        this.password = commandLine.getOption(OPTION_PASSWORD).getValue();
        if (this.password != null) {
            this.password = RAMPassword.getEncryptedPassword((String)this.password);
        }
        this.community = commandLine.getOption(OPTION_COMMUNITY).getValue();
        if (this.url == null && this.user == null && this.password == null && this.community == null) {
            this.showConfigurationOnly = true;
        }
        this.getPropertyValues();
        ArrayList<Status> entryError = new ArrayList<Status>();
        if (UtilitiesCommon.isEmptyString((String)this.url)) {
            message = MessageFormat.format(Messages.getString("CommandLine.4"), OPTION_URL);
            entryError.add(new Status(4, this.getClass().getName(), message));
        }
        if (UtilitiesCommon.isEmptyString((String)this.user)) {
            message = MessageFormat.format(Messages.getString("CommandLine.4"), OPTION_USER);
            entryError.add(new Status(4, this.getClass().getName(), message));
        }
        if (UtilitiesCommon.isEmptyString((String)this.password)) {
            message = MessageFormat.format(Messages.getString("CommandLine.4"), OPTION_PASSWORD);
            entryError.add(new Status(4, this.getClass().getName(), message));
        }
        if (!entryError.isEmpty()) {
            return new MultiStatus(this.getClass().getName(), 4, entryError.toArray(new IStatus[0]), null, null);
        }
        Status status = this.getRAMSession(this.url, this.user, this.password);
        if (!status.isOK()) {
            return status;
        }
        this.releaseRAMSession();
        return status;
    }

    private void getPropertyValues() {
        if (UtilitiesCommon.isEmptyString((String)this.url)) {
            this.url = this.config.getUrl();
        }
        if (UtilitiesCommon.isEmptyString((String)this.user)) {
            this.user = this.config.getUser();
        }
        if (UtilitiesCommon.isEmptyString((String)this.password)) {
            this.password = this.config.getPassword();
        }
        if (UtilitiesCommon.isEmptyString((String)this.community)) {
            this.community = this.config.getCommunity();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.config != null) {
            sb.append(MessageFormat.format(Messages.getString("ConfigCommand.1"), this.config.getConfigFileName()));
            sb.append("\n");
        }
        if (this.url != null) {
            sb.append("url = " + this.url + "\n");
        }
        if (this.user != null) {
            sb.append("user = " + this.user + "\n");
        }
        if (this.password != null) {
            sb.append("password = ********\n");
        }
        if (this.community != null) {
            sb.append("community = " + this.community + "\n");
        }
        return sb.toString();
    }
}

