/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.Asset;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.URLArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipFile;
import com.ibm.ram.io.zip.ZipOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

@Deprecated
public class LocalArchiveFolderArtifact
extends LocalFolderArtifact {
    private static final Logger logger = Logger.getLogger((String)LocalArchiveFolderArtifact.class.getName());
    private static int MEGA_BYTE = 0x100000;
    private LocalFolderArtifact fUnzippedFolder;
    private File fArchiveFile;
    private Artifact[] fFlatArtifactList;

    public LocalArchiveFolderArtifact(File file) {
        super(file, true);
        this.fArchiveFile = file;
    }

    private void assertValidArchiveFile(File file) {
        if (!(file.exists() && file.canRead() && file.isFile())) {
            throw new RAMRuntimeException("Archive File cannot be read, doesn't exists, or is not a file (it is folder). File=" + file.toString());
        }
    }

    public File getArchiveFile() {
        return this.fArchiveFile;
    }

    @Override
    public File getFolder() {
        return this.getUnzippedFolder().getFolder();
    }

    private synchronized LocalFolderArtifact getUnzippedFolder() throws RAMRuntimeException {
        if (this.fUnzippedFolder == null) {
            try {
                this.assertValidArchiveFile(this.getArchiveFile());
                this.getAsset().getDeltaAssetFileBuilder().addZipFileToDelta(this.getArchiveFile(), null, "");
                this.fUnzippedFolder = this.unzip((IProgressMonitor)new RAMStatusMonitor());
                this.fUnzippedFolder.setAsset(this.getAsset());
                this.fUnzippedFolder.setAsRoot(this.getAsset(), this.getAsset().getManifestBuilder().getSolution(), true);
                Solution solution = this.fUnzippedFolder.getInternalSolution();
                if (solution != null) {
                    int i = 0;
                    while (i < solution.getArtifact().size()) {
                        com.ibm.ram.defaultprofile.Artifact artifact = (com.ibm.ram.defaultprofile.Artifact)solution.getArtifact().get(i);
                        if (this.getName().equals(artifact.getName())) {
                            solution.getArtifact().remove(i);
                            break;
                        }
                        ++i;
                    }
                }
                this.fUnzippedFolder.processSolutionChildren();
                this.fUnzippedFolder.processNativeChildren();
            }
            catch (IOException e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return this.fUnzippedFolder;
    }

    @Override
    public void addArtifact(Artifact artifact) throws RAMRuntimeException {
        this.getUnzippedFolder().addArtifact(artifact);
    }

    @Override
    public void addArtifact(String relativePath, Artifact artifactimpl) {
        this.getUnzippedFolder().addArtifact(relativePath, artifactimpl);
    }

    @Override
    public Artifact[] computeArtifactsAsFlatList(IProgressMonitor monitor) {
        if (this.fUnzippedFolder != null) {
            return this.getUnzippedFolder().computeArtifactsAsFlatList(monitor);
        }
        return this.computeFlatArtifactListFromArchive();
    }

    private Artifact[] computeFlatArtifactListFromArchive() {
        if (this.fFlatArtifactList == null) {
            try {
                ZipFile zFile = new ZipFile(this.getArchiveFile());
                Enumeration myEnum = zFile.entries();
                ArrayList<RAMArtifact> flatList = new ArrayList<RAMArtifact>();
                while (myEnum.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)myEnum.nextElement();
                    com.ibm.ram.defaultprofile.Artifact artifact = this.getAsset().getManifestBuilder().addArtifact(entry);
                    if (artifact == null) continue;
                    RAMArtifact newArtifact = new RAMArtifact(this.getAsset(), artifact.computePathInSolution("/"), artifact);
                    flatList.add(newArtifact);
                }
                this.fFlatArtifactList = flatList.toArray(new Artifact[flatList.size()]);
            }
            catch (Throwable e) {
                logger.error((Object)e.getLocalizedMessage(), e);
            }
        }
        return this.fFlatArtifactList;
    }

    @Override
    public Artifact[] getChildren() {
        return this.getUnzippedFolder().getChildren();
    }

    @Override
    public boolean hasChildren() {
        return this.getUnzippedFolder().hasChildren();
    }

    @Override
    public Artifact getChild(String path) {
        return this.getUnzippedFolder().getChild(path);
    }

    @Override
    public boolean removeArtifact(Artifact artifact) {
        return this.getUnzippedFolder().removeArtifact(artifact);
    }

    @Override
    public boolean removeArtifact(String relativePath) {
        return this.getUnzippedFolder().removeArtifact(relativePath);
    }

    @Override
    public void setChildren(Artifact[] children) {
        this.getUnzippedFolder().setChildren(children);
    }

    static void addFolderArtifact(ZipOutputStream zos, LocalFolderArtifact artifact, RAMStatusMonitor ramStatusMonitor) throws RAMRuntimeException {
        Artifact[] children = artifact.getChildren();
        int i = 0;
        while (i < children.length) {
            try {
                if (children[i] instanceof LocalFolderArtifact) {
                    LocalArchiveFolderArtifact.addFolderArtifact(zos, (LocalFolderArtifact)children[i], ramStatusMonitor);
                } else if (!(children[i] instanceof RAMURLArtifact)) {
                    if (children[i] instanceof LocalFileArtifact) {
                        LocalArchiveFolderArtifact.addArtifact(zos, children[i], ((LocalFileArtifact)children[i]).getContents());
                    } else if (children[i] instanceof RAMArtifact) {
                        LocalArchiveFolderArtifact.addArtifact(zos, children[i], ((RAMArtifact)children[i]).downloadContents());
                    }
                }
            }
            catch (Exception e) {
                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.INVALID_ARTIFACT"), artifact.getAsset());
                ramStatusMonitor.appendStatus(artifact, 2, 1011, message2, e);
                logger.warn((Object)message2);
            }
            ++i;
        }
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String cleanFromUnsuitableFilechars(String s) {
        if (LocalArchiveFolderArtifact.isBlank(s)) {
            return "";
        }
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '-' && !Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    private static String cleanPathForZip(String path) {
        if (path != null && path.startsWith("/")) {
            path = path.substring("/".length());
        }
        if (path != null && !path.equals("") && !path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void addArtifact(ZipOutputStream zos, Artifact artifact, InputStream contents) throws IOException, RAMRuntimeException {
        byte[] bytes = new byte[20480];
        String path = artifact.getPath();
        path = LocalArchiveFolderArtifact.cleanPathForZip(path);
        ZipEntry entry = new ZipEntry(String.valueOf(path) + artifact.getName());
        zos.putNextEntry(entry);
        double bytesProcessed = 0.0;
        try {
            block8: {
                int read;
                block7: {
                    if (!true) break block7;
                    if (contents == null) return;
                    if ((read = contents.read(bytes)) <= 0) break block8;
                }
                do {
                    if (read > 0) {
                        zos.write(bytes, 0, read);
                        bytesProcessed += (double)read;
                    }
                    if (contents == null) return;
                } while ((read = contents.read(bytes)) > 0);
            }
            return;
        }
        finally {
            if (contents != null) {
                contents.close();
            }
            zos.closeEntry();
        }
    }

    private LocalFolderArtifact unzip(IProgressMonitor monitor) throws IOException {
        ZipFile zipFile = null;
        File unzipFolder = null;
        if (!monitor.isCanceled()) {
            monitor.beginTask("Unzip archive", 10);
            unzipFolder = new File(this.getAsset().getSession().getLocalStorageFolder(), LocalArchiveFolderArtifact.cleanFromUnsuitableFilechars(String.valueOf(this.getAsset().getIdentification().getGUID()) + "_" + this.getAsset().getIdentification().getVersion() + "_" + this.getPath() + "_" + this.getName()));
            unzipFolder.mkdir();
            unzipFolder.deleteOnExit();
            try {
                zipFile = new ZipFile(this.getArchiveFile());
                Enumeration zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)zipEntries.nextElement();
                    File tmp = new File(unzipFolder, entry.getName());
                    tmp.getParentFile().mkdirs();
                    if (entry.isDirectory() || "manifest.rmd".equalsIgnoreCase(entry.getName())) continue;
                    InputStream zis = zipFile.getInputStream(entry);
                    FileOutputStream out = null;
                    try {
                        try {
                            out = new FileOutputStream(tmp);
                            byte[] data = new byte[8192];
                            int bytesProcessed = 0;
                            while (zis.available() > 0) {
                                int read = zis.read(data);
                                if (read <= 0) continue;
                                out.write(data, 0, read);
                                bytesProcessed += read;
                            }
                        }
                        catch (IOException iOException) {
                            if (out == null) continue;
                            out.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            out.close();
                        }
                        throw throwable;
                    }
                    if (out == null) continue;
                    out.close();
                }
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        LocalFolderArtifact ret = new LocalFolderArtifact(unzipFolder, this.getPath(), "");
        this.fArchiveFile = null;
        this.fFlatArtifactList = null;
        return ret;
    }

    public LocalArchiveFolderArtifact(RAMAsset targetAsset, Asset sourceAsset, IProgressMonitor monitor) throws RAMRuntimeException, IOException {
        this(File.createTempFile(LocalArchiveFolderArtifact.cleanFromUnsuitableFilechars(targetAsset.getIdentification().getGUID()), ".ras", targetAsset.getSession().getLocalStorageFolder()));
        this.setAsset(targetAsset);
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        File rasFile = null;
        if (!monitor.isCanceled()) {
            RAMStatusMonitor ramStatusMonitor;
            int workDone;
            int TOTAL_WORK;
            block50: {
                TOTAL_WORK = 10;
                workDone = 0;
                monitor.beginTask(ClientMessages.getString("AssetUtil.16"), TOTAL_WORK);
                ramStatusMonitor = null;
                if (!(monitor instanceof RAMStatusMonitor)) {
                    ramStatusMonitor = new RAMStatusMonitor(monitor, TOTAL_WORK);
                    ramStatusMonitor.beginTask(ClientMessages.getString("AssetUtil.16"), TOTAL_WORK);
                } else {
                    ramStatusMonitor = (RAMStatusMonitor)monitor;
                }
                String downloadTaskName = MessageFormat.format(ClientMessages.getString("AssetUtil.DOWNLOAD_ASSET"), sourceAsset);
                monitor.subTask(downloadTaskName);
                try {
                    try {
                        if (monitor.isCanceled()) break block50;
                        RAMStatusMonitor subMonitor = new RAMStatusMonitor((IProgressMonitor)ramStatusMonitor, 10);
                        rasFile = this.getArchiveFile();
                        rasFile.deleteOnExit();
                        fos = new FileOutputStream(rasFile);
                        if (sourceAsset instanceof RAMAsset) {
                            InputStream remoteAssetStream = ((RAMAsset)sourceAsset).getContents();
                            if (remoteAssetStream == null) {
                                throw new RAMRuntimeException(MessageFormat.format(ClientMessages.getString("Ant.Error.DownloadingAsset"), sourceAsset));
                            }
                            try {
                                try {
                                    workDone += 10;
                                    LocalArchiveFolderArtifact.copyStreamsWithProgress(remoteAssetStream, fos, null, true, true, downloadTaskName, (IProgressMonitor)subMonitor);
                                    break block50;
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    throw new RAMRuntimeException(ClientMessages.getString("AssetUtil.23"), e);
                                }
                            }
                            finally {
                                if (remoteAssetStream != null) {
                                    remoteAssetStream.close();
                                }
                                if (fos != null) {
                                    fos.close();
                                }
                                if (subMonitor != null) {
                                    subMonitor.done();
                                }
                            }
                        }
                        if (sourceAsset.getArtifactsRoot() instanceof LocalArchiveFolderArtifact) {
                            FileInputStream localArchiveStream = new FileInputStream(((LocalArchiveFolderArtifact)sourceAsset.getArtifactsRoot()).getFolder());
                            try {
                                try {
                                    workDone += 10;
                                    LocalArchiveFolderArtifact.copyStreamsWithProgress(localArchiveStream, fos, null, true, true, downloadTaskName, (IProgressMonitor)subMonitor);
                                    break block50;
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                    throw new RAMRuntimeException(ClientMessages.getString("AssetUtil.23"), e);
                                }
                            }
                            finally {
                                ((InputStream)localArchiveStream).close();
                                fos.close();
                                subMonitor.done();
                            }
                        }
                        zos = new ZipOutputStream(fos);
                        Artifact[] artifacts = LocalArchiveFolderArtifact.computeArtifactsAsFlatList(sourceAsset);
                        workDone += 3;
                        ramStatusMonitor.worked(3);
                        String message = MessageFormat.format(ClientMessages.getString("AssetUtil.BUILD_MANIEFEST_ASSET"), sourceAsset);
                        ramStatusMonitor.subTask(message);
                        if (monitor.isCanceled()) break block50;
                        try {
                            if (zos != null) {
                                zos.putNextEntry(new ZipEntry("manifest.rmd"));
                                zos.closeEntry();
                            }
                            if (artifacts.length == 0) {
                                workDone += 7;
                                monitor.worked(7);
                                break block50;
                            }
                            subMonitor = new RAMStatusMonitor(monitor, 7);
                            String message1 = MessageFormat.format(ClientMessages.getString("AssetUtil.PACKAGE_ASSET_ADD_ARTIFACTS"), this.getAsset());
                            subMonitor.beginTask(message1, artifacts.length);
                            int i = 0;
                            while (!monitor.isCanceled() && i < artifacts.length) {
                                block52: {
                                    Artifact artifact = artifacts[i];
                                    try {
                                        try {
                                            if (artifact.getName() != null && !"".equals(artifact.getName())) {
                                                if (zos != null && artifact instanceof LocalFolderArtifact) {
                                                    LocalArchiveFolderArtifact.addFolderArtifact(zos, (LocalFolderArtifact)artifact, ramStatusMonitor);
                                                } else if (artifact instanceof URLArtifact) {
                                                    RAMURLArtifact temp = new RAMURLArtifact(((URLArtifact)artifact).getURL());
                                                    temp.setName(artifact.getName());
                                                    temp.setPath(artifact.getPath());
                                                    artifact = temp;
                                                } else if (zos != null && artifact instanceof LocalFileArtifact) {
                                                    LocalArchiveFolderArtifact.addArtifact(zos, artifact, ((LocalFileArtifact)artifact).getContents());
                                                } else if (artifact instanceof FolderArtifact && !(artifact instanceof RAMFolderArtifact)) {
                                                    RAMFolderArtifact ramFolder = new RAMFolderArtifact(this.getAsset(), artifact.getPath(), null);
                                                    ramFolder.setName(artifact.getName());
                                                    artifact = ramFolder;
                                                }
                                                ((RAMFolderArtifact)this.getAsset().getArtifactsRoot()).addArtifact(artifact.getPath(), artifact);
                                            } else {
                                                String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.INVALID_ARTIFACT"), sourceAsset);
                                                ramStatusMonitor.appendStatus(artifact, 2, 1011, message2, null);
                                                logger.warn((Object)message2);
                                            }
                                        }
                                        catch (Exception e) {
                                            String message2 = MessageFormat.format(ClientMessages.getString("AssetUtil.INVALID_ARTIFACT"), sourceAsset);
                                            ramStatusMonitor.appendStatus(artifact, 2, 1011, message2, e);
                                            logger.warn((Object)message2);
                                            subMonitor.worked(1);
                                            break block52;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        subMonitor.worked(1);
                                        throw throwable;
                                    }
                                    subMonitor.worked(1);
                                }
                                ++i;
                            }
                            workDone += 7;
                        }
                        finally {
                            if (zos != null) {
                                zos.finish();
                                zos.close();
                            }
                        }
                    }
                    catch (RAMRuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    if (zos != null) {
                        try {
                            zos.finish();
                            zos.close();
                        }
                        catch (IOException iOException) {}
                        zos = null;
                        fos = null;
                    }
                    ramStatusMonitor.worked(TOTAL_WORK - workDone);
                    ramStatusMonitor.done();
                    throw throwable;
                }
            }
            if (zos != null) {
                try {
                    zos.finish();
                    zos.close();
                }
                catch (IOException iOException) {}
                zos = null;
                fos = null;
            }
            ramStatusMonitor.worked(TOTAL_WORK - workDone);
            ramStatusMonitor.done();
        }
        ((RAMFolderArtifact)targetAsset.getArtifactsRoot()).addArtifact(this);
    }

    private static void copyStreamsWithProgress(InputStream in, OutputStream output, byte[] buffer, boolean closeInput, boolean closeOutput, String subProgressMessage, IProgressMonitor monitor) throws IOException {
        try {
            int read;
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
            format.setMinimumFractionDigits(2);
            double workDone = 0.0;
            monitor.beginTask(ClientMessages.getString("AssetUtil.41"), -1);
            if (buffer == null) {
                buffer = new byte[65536];
            }
            int start = 0;
            while (!monitor.isCanceled() && (read = in.read(buffer, start, buffer.length - start)) > -1) {
                if ((start += read) >= buffer.length) {
                    output.write(buffer);
                    start = 0;
                }
                double megsDone = (workDone += (double)read) / (double)MEGA_BYTE;
                String megsDoneString = format.format(megsDone);
                monitor.subTask(String.valueOf(subProgressMessage) + " (" + megsDoneString + " MB)");
            }
            if (start > 0) {
                output.write(buffer, 0, start);
            }
        }
        catch (Throwable throwable) {
            if (closeInput && in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (closeOutput && output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.done();
            }
            throw throwable;
        }
        if (closeInput && in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (closeOutput && output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    static Artifact[] computeArtifactsAsFlatList(Asset asset) {
        FolderArtifact rootFolder = asset.getArtifactsRoot();
        if (rootFolder == null) {
            return new Artifact[0];
        }
        Artifact[] currentArtifacts = rootFolder.getChildren();
        ArrayList artifacts = new ArrayList();
        LocalArchiveFolderArtifact.processArtifactChildren(currentArtifacts, artifacts);
        return artifacts.toArray(new Artifact[artifacts.size()]);
    }

    private static void processArtifactChildren(Artifact[] currentArtifacts, List artifacts) {
        int i = 0;
        while (i < currentArtifacts.length) {
            FolderArtifact child;
            artifacts.add(currentArtifacts[i]);
            Artifact artifact = currentArtifacts[i];
            if ("folder".equals(artifact.getType()) && (child = (FolderArtifact)artifact).getChildren().length > 0) {
                LocalArchiveFolderArtifact.processArtifactChildren(child.getChildren(), artifacts);
            }
            ++i;
        }
    }

    @Override
    public void setPath(String path) {
        super.setPath(path);
        if (this.fUnzippedFolder != null) {
            this.fUnzippedFolder.setPath(path);
        }
    }
}

