/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMHomepageViewlet;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.common.data.CommunitySO;
import com.ibm.ram.internal.common.util.SerializationHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RAMCommunity
extends CommunityInformation
implements IRAMSessionObject {
    private static String COMMUNITY_HASH_KEY = "COMMUNITY:";
    private static String NEW_COMMUNITY_HASH_KEY = "NEW_COMMUNITY:";
    private CommunityInformation fCommunity;
    private RAMUser[] fAdministrators;
    private RAMSession fSession;
    private RAMAsset homepageAsset;
    private Map viewletMap;
    private File overviewFile;
    private RAMAction fAction;
    private boolean fDirty;
    private boolean fullCommunity;
    private boolean homepageAssetDirty;

    RAMCommunity(RAMSession session, CommunityInformation webServiceGroup) {
        this.fSession = session;
        this.fAction = RAMAction.UPDATE;
        this.fCommunity = webServiceGroup;
    }

    RAMCommunity(RAMSession session, String name) {
        this.fSession = session;
        this.fCommunity = new CommunityInformation();
        this.fCommunity.setId(-1);
        this.fCommunity.setName(name);
        this.fAction = RAMAction.CREATE;
        this.setDirty(true);
    }

    void communityCommited() throws RAMRuntimeException {
        this.fAction = RAMAction.UPDATE;
        this.setDirty(false);
    }

    @Override
    public int getId() throws RAMRuntimeException {
        return this.fCommunity.getId();
    }

    @Override
    public void setId(int id) {
        this.fCommunity.setId(id);
    }

    @Override
    public String getName() throws RAMRuntimeException {
        if (this.fCommunity.getName() == null) {
            this.fetchGroup();
        }
        return this.fCommunity.getName();
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        this.fCommunity.setName(name);
        this.getSession().rehashIfNeeded(this, oldName);
        this.setDirty(true);
    }

    @Override
    public String getDescription() throws RAMRuntimeException {
        if (this.fCommunity.getDescription() == null) {
            this.fetchGroup();
        }
        return this.fCommunity.getDescription();
    }

    public RAMHomepageViewlet getHomepageViewlet(String id) {
        if (this.getViewletMap().containsKey(id)) {
            return (RAMHomepageViewlet)this.getViewletMap().get(id);
        }
        RAMHomepageViewlet viewlet = new RAMHomepageViewlet(this);
        viewlet.setId(id);
        this.getViewletMap().put(id, viewlet);
        return viewlet;
    }

    private Map getViewletMap() {
        if (this.viewletMap == null) {
            this.fetchViewlets();
        }
        return this.viewletMap;
    }

    private Node findViewlet(Document document, String id) {
        if (id == null) {
            return null;
        }
        NodeList viewletNodes = document.getElementsByTagName("widget");
        int i = 0;
        while (i < viewletNodes.getLength()) {
            Node viewletNode = viewletNodes.item(i);
            NamedNodeMap viewletAttrs = viewletNode.getAttributes();
            String viewletId = viewletAttrs.getNamedItem("id").getNodeValue();
            if (id.equals(viewletId)) {
                return viewletNode;
            }
            ++i;
        }
        return null;
    }

    private Node findColumn(Document document, int column) {
        if (column < 1 || column > 3) {
            return null;
        }
        NodeList columns = document.getElementsByTagName("column");
        return columns.item(--column);
    }

    private File getOverviewFile() {
        if (this.overviewFile == null) {
            try {
                RAMArtifact overviewArtifact = null;
                Artifact[] artifacts = ((RAMFolderArtifact)this.getInternalHomepageAsset().getArtifactsRoot()).getChildren();
                if (artifacts != null) {
                    int i = 0;
                    while (i < artifacts.length) {
                        if (artifacts[i].getName().equals("overview.xml") && artifacts[i].getPath().equals("")) {
                            overviewArtifact = (RAMArtifact)artifacts[i];
                            break;
                        }
                        ++i;
                    }
                }
                if (overviewArtifact == null) {
                    throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.6"), true);
                }
                File tmp = File.createTempFile("overview", "xml");
                this.overviewFile = new File(tmp.getParentFile(), "overview.xml");
                FileOutputStream out = new FileOutputStream(this.overviewFile);
                UtilitiesCommon.copyStreams(overviewArtifact.downloadContents(), out, null, true, true);
            }
            catch (IOException e) {
                throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.10"), e);
            }
        }
        return this.overviewFile;
    }

    void commitHomepageAsset(IProgressMonitor monitor) {
        Document document = this.getOverviewDocument();
        Collection viewletValues = this.getViewletMap().values();
        Iterator iter = viewletValues.iterator();
        monitor.beginTask(ClientMessages.getString("RAMCommunity.11"), viewletValues.size() + 2);
        while (iter.hasNext()) {
            RAMHomepageViewlet viewlet = (RAMHomepageViewlet)iter.next();
            if (viewlet.isDirty()) {
                Node node = this.findViewlet(document, viewlet.getId());
                if (node == null) {
                    node = document.createElement("widget");
                    Attr idAttr = document.createAttribute("id");
                    idAttr.setNodeValue(viewlet.getId());
                    node.getAttributes().setNamedItem(idAttr);
                    Attr typeAttr = document.createAttribute("type");
                    typeAttr.setNodeValue("0");
                    node.getAttributes().setNamedItem(typeAttr);
                    this.findColumn(document, viewlet.getColumn()).appendChild(node);
                }
                if (viewlet.getTitle() != null) {
                    Node titleAttr = node.getAttributes().getNamedItem("title");
                    if (titleAttr == null) {
                        titleAttr = document.createAttribute("title");
                        node.getAttributes().setNamedItem(titleAttr);
                    }
                    titleAttr.setNodeValue(viewlet.getTitle());
                }
                if (viewlet.getColspan() != null) {
                    Node colspanAttr = node.getAttributes().getNamedItem("colspan");
                    if (colspanAttr == null) {
                        colspanAttr = document.createAttribute("colspan");
                        node.getAttributes().setNamedItem(colspanAttr);
                    }
                    colspanAttr.setNodeValue(viewlet.getColspan());
                }
                if (node.getFirstChild() != null) {
                    node.getFirstChild().setNodeValue(viewlet.getContent());
                } else {
                    node.appendChild(document.createTextNode(viewlet.getContent()));
                }
            }
            monitor.worked(1);
        }
        Transformer xformer = null;
        Writer writer = null;
        try {
            try {
                xformer = SerializationHelper.getTransformer(null);
                DOMSource domSource = new DOMSource(document);
                File overviewFile = this.getOverviewFile();
                writer = new FileWriter(overviewFile);
                StreamResult result = new StreamResult(writer);
                xformer.transform(domSource, result);
            }
            catch (Throwable t) {
                throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.14"), t);
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            SerializationHelper.returnTransformer(xformer);
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        SerializationHelper.returnTransformer(xformer);
        monitor.worked(1);
        RAMAsset homepageAsset = this.getInternalHomepageAsset();
        LocalFileArtifact artifact = new LocalFileArtifact(this.getOverviewFile());
        ((RAMFolderArtifact)homepageAsset.getArtifactsRoot()).addArtifact(artifact);
        String sd = homepageAsset.getShortDescription();
        if (sd == null || sd.trim().length() == 0) {
            homepageAsset.setShortDescription(this.getName());
        }
        this.getSession().put(homepageAsset, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.getSession().remove(homepageAsset);
        homepageAsset.refresh();
    }

    private void fetchViewlets() {
        this.viewletMap = new HashMap();
        Document document = this.getOverviewDocument();
        NodeList viewletNodes = document.getElementsByTagName("widget");
        int i = 0;
        while (i < viewletNodes.getLength()) {
            Node viewletNode = viewletNodes.item(i);
            Node idAttr = viewletNode.getAttributes().getNamedItem("id");
            if (idAttr != null) {
                this.viewletMap.put(idAttr.getNodeValue(), new RAMHomepageViewlet(viewletNode, this));
            }
            ++i;
        }
    }

    private Document getOverviewDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getOverviewFile());
        }
        catch (SAXException e) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.17"), e);
        }
        catch (IOException e) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.18"), e);
        }
        catch (ParserConfigurationException e) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMCommunity.19"), e);
        }
    }

    @Override
    public void setDescription(String description) {
        this.fCommunity.setDescription(description);
        this.setDirty(true);
    }

    private void clearCommunity() {
        this.fAdministrators = null;
        this.fullCommunity = false;
        this.fAction = RAMAction.UPDATE;
        this.setInternalCommunity(new CommunityInformation());
        this.setDirty(false);
    }

    public RAMUser[] getAdministrators() {
        if (this.fAdministrators == null) {
            this.fAdministrators = new RAMUser[0];
        }
        return this.fAdministrators;
    }

    public void setAdministrators(RAMUser[] administrators) {
        this.fAdministrators = administrators;
    }

    private void setInternalCommunity(CommunityInformation webServiceCommunity) {
        this.fCommunity = webServiceCommunity;
    }

    CommunityInformation getInternalCommunityInformation() throws RAMRuntimeException {
        if (this.fCommunity == null) {
            this.fetchGroup();
        }
        return this.fCommunity;
    }

    CommunitySO getInternalCommunity() throws RAMRuntimeException {
        if (!this.fullCommunity) {
            this.upgradeCommunity();
        }
        return (CommunitySO)this.fCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeCommunity() {
        if (!this.fDirty) {
            this.refresh();
        } else {
            CommunitySO webServiceCommunity = null;
            try {
                webServiceCommunity = this.getSession().fetchCommunityFromServer(this.fCommunity.getId());
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
            webServiceCommunity.setDescription(this.fCommunity.getDescription());
            webServiceCommunity.setName(this.fCommunity.getName());
            webServiceCommunity.setId(this.fCommunity.getId());
            CommunityInformation communityInformation = this.fCommunity;
            synchronized (communityInformation) {
                this.setInternalCommunity(webServiceCommunity);
            }
        }
        this.fullCommunity = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RAMRuntimeException {
        int id = this.getId();
        this.clearCommunity();
        try {
            CommunitySO community = this.getSession().fetchCommunityFromServer(id);
            CommunityInformation communityInformation = this.fCommunity;
            synchronized (communityInformation) {
                this.setInternalCommunity(community);
            }
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    RAMAsset getInternalHomepageAsset() throws RAMRuntimeException {
        if (this.homepageAsset == null) {
            this.homepageAsset = new RAMAsset(this.getSession(), this.getInternalCommunity().getHomepageAsset());
        }
        return this.homepageAsset;
    }

    private void fetchGroup() throws RAMRuntimeException {
        try {
            if (this.fCommunity.getId() == -1) {
                this.fCommunity.setDescription("");
            }
        }
        catch (Throwable e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String toString() {
        if (this.fCommunity != null) {
            return this.fCommunity.getName();
        }
        return super.toString();
    }

    public RAMSession getSession() {
        return this.fSession;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    void setHomepageAssetDirty(boolean dirty) {
        this.homepageAssetDirty = dirty;
        if (dirty) {
            this.setDirty(dirty);
        }
    }

    boolean isHomepageAssetDirty() {
        return this.homepageAssetDirty;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        String ret = this.getId() == -1 ? String.valueOf(COMMUNITY_HASH_KEY) + this.getId() : String.valueOf(NEW_COMMUNITY_HASH_KEY) + this.getName();
        return ret;
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.UPDATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        this.setDirty(true);
    }
}

