/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class CreateLabelCommand
extends OutputCleartoolCommand {
    private File[] files = null;
    private String label = null;
    private boolean isRecursive = false;

    public CreateLabelCommand(File[] files, String label, boolean isRecursive) {
        this.files = files;
        this.label = label;
        this.isRecursive = isRecursive;
    }

    @Override
    protected String[] getArguments() {
        int argCount = 3 + this.files.length;
        if (this.isRecursive) {
            ++argCount;
        }
        String[] args = new String[argCount];
        args[0] = "mklabel";
        args[1] = "-replace";
        int count = 2;
        if (this.isRecursive) {
            args[count++] = "-recurse";
        }
        args[count++] = this.label;
        int fc = 0;
        while (fc < this.files.length) {
            args[count + fc] = this.files[fc].getAbsolutePath();
            ++fc;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, final String error) {
        return new CreateLabelOutput(){

            @Override
            public boolean isCreated() {
                boolean created = true;
                if (error != null && error.indexOf(CleartoolCommandConstants.ERROR) > -1) {
                    created = false;
                }
                return created;
            }
        };
    }

    public static interface CreateLabelOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isCreated();
    }
}

