/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class MakeStreamCommand
extends OutputCleartoolCommand {
    private String project;
    private String streamName;
    private String[] baselines;
    private String baselineSelectorString;

    public MakeStreamCommand(String project, String[] baselines, String streamName) {
        this.project = project;
        this.baselines = baselines;
        this.streamName = streamName;
        this.makeBaselineSelectorString();
    }

    private void makeBaselineSelectorString() {
        StringBuffer buffer = new StringBuffer();
        if (this.baselines != null) {
            int i = 0;
            while (i < this.baselines.length) {
                buffer.append(this.baselines[i]);
                if (i + 1 < this.baselines.length) {
                    buffer.append(',');
                }
                ++i;
            }
        }
        this.baselineSelectorString = buffer.toString();
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean createSuccess = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            createSuccess = lines[0].indexOf(CleartoolCommandConstants.CREATED) > -1;
        }
        final boolean finalSuccess = createSuccess;
        return new MakeStreamCommandOutput(){

            @Override
            public boolean createSuccessful() {
                return finalSuccess;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"mkstream", "-in", this.project, "-baseline", this.baselineSelectorString, this.streamName};
    }

    public static interface MakeStreamCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean createSuccessful();
    }
}

