/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.internal.access.ws.RAM1;
import com.ibm.ram.internal.client.RAMClient;
import com.ibm.ram.internal.jaxb.Repository;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;

public class Connections {
    private Logger logger = Logger.getLogger(Connections.class);
    private RAM1 webService;
    private HttpClient httpClient;
    private Repository repositoryInformation;
    private List<Integer> httpCreateClientHashCodes = new ArrayList<Integer>();
    private List<Integer> webServicesCreateClientHashCodes = new ArrayList<Integer>();
    private boolean isLoggedOut;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public RAM1 getWebService() {
        return this.webService;
    }

    public void setWebService(RAM1 webService) {
        this.webService = webService;
    }

    public void addHttpClientCreate(RAMClient client) {
        if (client != null) {
            int hashCode = ((Object)((Object)client)).hashCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getDisplayString("addHttpClientCreate(): Adding HTTP Create Client " + Integer.toHexString(hashCode) + " to ", this.httpCreateClientHashCodes));
            }
            if (!this.httpCreateClientHashCodes.contains(hashCode)) {
                this.httpCreateClientHashCodes.add(hashCode);
            }
        }
    }

    public void addWebServicesClientCreate(RAMClient client) {
        if (client != null) {
            int hashCode = ((Object)((Object)client)).hashCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getDisplayString("addWebServicesClientCreate(): Adding WebServices Create Client " + Integer.toHexString(hashCode) + " to ", this.webServicesCreateClientHashCodes));
            }
            if (!this.webServicesCreateClientHashCodes.contains(hashCode)) {
                this.webServicesCreateClientHashCodes.add(hashCode);
            }
        }
    }

    public void removeWebServicesClientCreate(RAMClient client) {
        if (client != null) {
            int hashCode = ((Object)((Object)client)).hashCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getDisplayString("removeWebServicesClientCreate(): Removing WebServices Create Client " + Integer.toHexString(hashCode) + " from ", this.webServicesCreateClientHashCodes));
            }
            if (this.webServicesCreateClientHashCodes.contains(hashCode)) {
                this.webServicesCreateClientHashCodes.remove(new Integer(hashCode));
            }
        }
    }

    public void removeHttpClientCreate(RAMClient client) {
        if (client != null) {
            int hashCode = ((Object)((Object)client)).hashCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getDisplayString("removeHttpClientCreate(): Removing HTTP Create Client " + Integer.toHexString(hashCode) + " from ", this.httpCreateClientHashCodes));
            }
            if (this.httpCreateClientHashCodes.contains(hashCode)) {
                this.httpCreateClientHashCodes.remove(new Integer(hashCode));
            }
        }
    }

    public int getHttpClientCreateListSize() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("getHttpClientCreateListSize(): ", this.httpCreateClientHashCodes));
        }
        return this.httpCreateClientHashCodes.size();
    }

    public int getWebServicesClientCreateListSize() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("getWebServicesClientCreateListSize(): ", this.webServicesCreateClientHashCodes));
        }
        return this.webServicesCreateClientHashCodes.size();
    }

    public boolean isClientInHttpClientCreateList(RAMClient client) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("isClientInHttpClientCreateList(): ? Is " + (Object)((Object)client) + " in ", this.httpCreateClientHashCodes));
        }
        if (client != null) {
            return this.httpCreateClientHashCodes.contains(((Object)((Object)client)).hashCode());
        }
        return false;
    }

    public boolean isClientInWebServicesClientCreateList(RAMClient client) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("isClientInWebServicesClientCreateList(): ? Is " + (Object)((Object)client) + " in ", this.webServicesCreateClientHashCodes));
        }
        if (client != null) {
            return this.webServicesCreateClientHashCodes.contains(((Object)((Object)client)).hashCode());
        }
        return false;
    }

    public void clearHttpClientCreates() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("clearHttpClientCreates(): Clearing all http client hashcodes: ", this.httpCreateClientHashCodes));
        }
        this.httpCreateClientHashCodes.clear();
    }

    public void clearWebServiceClientCreates() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getDisplayString("clearWebServiceClientCreates(): Clearing all WS client hashcodes: ", this.webServicesCreateClientHashCodes));
        }
        this.webServicesCreateClientHashCodes.clear();
    }

    private String getDisplayString(String prefix, List<Integer> list) {
        StringBuffer s = new StringBuffer();
        s.append(prefix);
        s.append("(" + list.size() + ") [");
        for (Integer i : list) {
            s.append(String.valueOf(Integer.toHexString(i)) + ", ");
        }
        s.append("] <<" + this.toString() + ">>");
        return s.toString();
    }

    public void setRepositoryInformation(Repository repositoryInformation) {
        this.repositoryInformation = repositoryInformation;
    }

    public Repository getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public void setLoggedOut(boolean isLoggedOut) {
        this.isLoggedOut = isLoggedOut;
    }

    public boolean isLoggedOut() {
        return this.isLoggedOut;
    }
}

