/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.client.RAMClientProperties;
import com.ibm.ram.common.data.exception.RAMException;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.access.ws.Constants;
import com.ibm.ram.internal.access.ws.IRAMService;
import com.ibm.ram.internal.access.ws.RAMv72;
import com.ibm.ram.internal.access.ws.Utilitiesv71;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.ClientCachedRAMUriConverter;
import com.ibm.ram.internal.client.ConnectionInfo;
import com.ibm.ram.internal.client.Connections;
import com.ibm.ram.internal.client.FilePartWithProgress;
import com.ibm.ram.internal.client.RAMClientUtilities;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.RESTClient;
import com.ibm.ram.internal.client.util.Messages;
import com.ibm.ram.internal.client.util.StringUtils;
import com.ibm.ram.internal.common.util.Utilities;
import com.ibm.ram.internal.common.util.WriteServerDataCallback;
import com.ibm.ram.internal.jaxb.Repository;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import com.ibm.ram.repository.web.ws.core.v72.RAM1;
import com.ibm.ram.repository.web.ws.core.v72.RAM1ServiceLocator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class RAMClient
extends AbstractRAMClient {
    private static AtomicReference<Map<ConnectionInfo, Connections>> connections = new AtomicReference();
    private static Logger logger = Logger.getLogger((String)RAMClient.class.getName());
    public static Level ERROR_LOG_LEVEL_DEFAULT = Level.WARN;
    public Level ERROR_LOG_LEVEL = ERROR_LOG_LEVEL_DEFAULT;
    public static int HTTPCLIENT_MAX_CONNECTIONS = 100;
    private Connections connectionHolder = null;
    private boolean initialized = false;
    private URL ramLocation = null;
    protected String userName = null;
    protected String password = null;
    private String onBehalfOfUserID = null;
    private int webServicesTimeout = 60000;
    private int uploadDownloadTimeout = -1;
    public static final String RAMSECURE_PATH = "/RAMSecure";
    private static final String REST_REPOSITORY = "/internal/repository";
    private static String RAM_WS_SERVLET = "/services/RAM1";
    private static final Map<String, String> RELEASE_HEADER = Collections.singletonMap("clientLogout", "true");
    static HttpMethodRetryHandler DEFAULT_RETRY_HANDLER = new DefaultHttpMethodRetryHandler(3, true);

    protected RAMClient(URL ramLocation) {
        this(ramLocation, null, null, null);
        this.isAnonymous = true;
    }

    public RAMClient(URL ramLocation, String userName, String password, String onBehalfOfUserID) {
        this.ramLocation = ramLocation = this.removeTrailingSlash(ramLocation);
        this.onBehalfOfUserID = onBehalfOfUserID;
        this.userName = StringUtils.isBlank((String)userName) ? "" : userName;
        this.password = StringUtils.isBlank((String)password) ? "" : password;
        this.isAnonymous = StringUtils.isBlank((String)userName) && StringUtils.isBlank((String)password);
    }

    private static Repository getRepositoryInformation(HttpClient usingClient, String serverLocation, String loginId, String password, boolean anonymous) throws RAMServiceException {
        Repository repository;
        block13: {
            repository = null;
            GetMethod urlGet = RAMClient.createGet(String.valueOf(serverLocation) + REST_REPOSITORY);
            urlGet.setFollowRedirects(true);
            if (!anonymous) {
                urlGet.setDoAuthentication(true);
                usingClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(loginId, password));
                usingClient.getParams().setAuthenticationPreemptive(true);
            }
            try {
                try {
                    int responseCode = usingClient.executeMethod((HttpMethod)urlGet);
                    if (responseCode != 200) {
                        throw new RAMServiceException(responseCode, RAMClient.getResponseText(urlGet.getResponseBodyAsStream(), urlGet.getStatusCode()));
                    }
                    String response = StringUtils.getStreamAsString((InputStream)urlGet.getResponseBodyAsStream());
                    Unmarshaller m = JAXButil.getXMLunMarshaller();
                    JAXBElement f = (JAXBElement)m.unmarshal((Reader)new StringReader(response));
                    Object value = f.getValue();
                    if (value instanceof Repository) {
                        repository = (Repository)value;
                        break block13;
                    }
                    throw new RAMServiceException(10006, "Unable to identify server due to incorrect response");
                }
                catch (HttpException e) {
                    throw new RAMServiceException(10002, e.getMessage(), (Throwable)e);
                }
                catch (ConnectException e) {
                    throw new RAMServiceException(10001, e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = "Error in transport medium trying to communicate with server";
                    }
                    if (message.equals("The repository connection is currently logged out")) {
                        throw new RAMServiceException(10008, message);
                    }
                    throw new RAMServiceException(10002, e.getMessage(), (Throwable)e);
                }
                catch (JAXBException e) {
                    throw new RAMServiceException(10006, "Unable to understand server response", (Throwable)e);
                }
            }
            finally {
                urlGet.releaseConnection();
            }
        }
        return repository;
    }

    private static void validateURL(HttpClient usingClient, String url, String loginId, String password, boolean anonymous) throws RAMServiceException {
        GetMethod urlGet = RAMClient.createGet(url);
        urlGet.setFollowRedirects(true);
        if (!anonymous) {
            urlGet.setDoAuthentication(true);
            usingClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(loginId, password));
            usingClient.getParams().setAuthenticationPreemptive(true);
        }
        try {
            try {
                int responseCode = usingClient.executeMethod((HttpMethod)urlGet);
                if (responseCode != 200) {
                    throw new RAMServiceException(responseCode, RAMClient.getResponseText(urlGet.getResponseBodyAsStream(), urlGet.getStatusCode()));
                }
            }
            catch (HttpException e) {
                throw new RAMServiceException(10002, e.getMessage(), (Throwable)e);
            }
            catch (ConnectException e) {
                throw new RAMServiceException(10001, e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "Error in transport medium trying to communicate with server";
                }
                if (message.equals("The repository connection is currently logged out")) {
                    throw new RAMServiceException(10008, message);
                }
                throw new RAMServiceException(10002, e.getMessage(), (Throwable)e);
            }
        }
        finally {
            urlGet.releaseConnection();
        }
    }

    public static String getAuthenticatedURL(String url, String[] serverPaths) {
        if (url != null && serverPaths != null) {
            String[] stringArray = serverPaths;
            int n = serverPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String serverPath = stringArray[n2];
                if (serverPath != null) {
                    int index;
                    serverPath = StringUtils.stripSlashSuffix((String)serverPath);
                    if (url.startsWith(serverPath = String.valueOf(serverPath) + "/") && (index = serverPath.length()) < url.length()) {
                        url = String.valueOf(url.substring(0, serverPath.length() - 1)) + RAMSECURE_PATH + url.substring(serverPath.length() - 1);
                        return url;
                    }
                }
                ++n2;
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void initialize() throws RAMServiceException {
        if (this.initialized) {
            return;
        }
        var2_2 = connmap = RAMClient.getConnections();
        synchronized (var2_2) {
            httpClientInitialized = false;
            wsClientInitialized = false;
            connectionInfo = new ConnectionInfo(this.ramLocation, this.userName, this.password, this.onBehalfOfUserID);
            connectionHolder = connmap.get(connectionInfo);
            needsCompatibilityCheck = false;
            if (connectionHolder == null) {
                needsCompatibilityCheck = true;
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): No connection defined - created <<" + this.toString() + ">>"));
                }
                connectionHolder = new Connections();
                connmap.put(connectionInfo, connectionHolder);
            }
            if (connectionHolder.getHttpClient() == null) {
                RAMClientUtilities.updateHTTPClientSSLProperties();
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): No HTTP-client defined - creating... <<" + this.toString() + ">>"));
                }
                newHttpClient = this.createHTTPClient();
                connectionHolder.setHttpClient(newHttpClient);
            }
            if (connectionHolder.getWebService() == null) {
                RAMClientUtilities.updateWebServicesSSLProperties();
            }
            tmpCreatedWS = null;
            if (connectionHolder.getRepositoryInformation() != null) ** GOTO lbl115
            needsCompatibilityCheck = true;
            httpClient = connectionHolder.getHttpClient();
            if (RAMClient.logger.isDebugEnabled()) {
                RAMClient.logger.debug((Object)("initialize(): First HTTP-client being created.. going to prime their sessions <<" + this.toString() + ">>"));
            }
            webRI = null;
            try {
                webRI = RAMClient.getRepositoryInformation(httpClient, this.ramLocation.toString(), this.userName, this.password, this.isAnonymous);
            }
            catch (RAMServiceException e) {
                if (401 == e.getStatusCode() && this.isAnonymous) {
                    if (RAMClient.logger.isDebugEnabled()) {
                        RAMClient.logger.debug((Object)("initialize(): Hit a 401 asking for /internal/repository... finding webPath <<" + this.toString() + ">>"));
                    }
                    serverPath = null;
                    try {
                        tmpCreatedWS = connectionHolder.getWebService();
                        if (tmpCreatedWS == null) {
                            tmpCreatedWS = this.createRAMv72Client(this.ramLocation.toString(), false);
                        }
                        serverPath = tmpCreatedWS.getServerPath();
                        serverPath = StringUtils.stripSlashSuffix((String)serverPath);
                        if (RAMClient.logger.isDebugEnabled()) {
                            RAMClient.logger.debug((Object)("initialize(): Found webPath to be: " + serverPath + " <<" + this.toString() + ">>"));
                        }
                    }
                    catch (MalformedURLException e1) {
                        RAMClient.logger.warn((Object)"Unable to create WebService client", (Throwable)e1);
                    }
                    catch (ServiceException e1) {
                        RAMClient.logger.warn((Object)"Unable to create WebService client", (Throwable)e1);
                    }
                    catch (RemoteException e1) {
                        RAMClient.logger.warn((Object)"Unable to determine Web WAR path", (Throwable)e1);
                    }
                    catch (RAMException e1) {
                        RAMClient.logger.warn((Object)"Unable to determine Web WAR path", (Throwable)e1);
                    }
                    if (serverPath != null) {
                        webRI = RAMClient.getRepositoryInformation(httpClient, serverPath, this.userName, this.password, this.isAnonymous);
                    }
                    throw new RAMServiceException(10005, Messages.getString((String)"ERROR_RAMRepositoryClient_Invalid_URL"));
                }
                throw e;
            }
            if (RAMClient.logger.isDebugEnabled()) {
                RAMClient.logger.debug((Object)("initialize(): Primed session at: " + this.ramLocation + " <<" + this.toString() + ">>"));
            }
            if (webRI != null) {
                userInputServerPath = StringUtils.stripSlashSuffix((String)this.ramLocation.toString());
                webWARPath = StringUtils.stripSlashSuffix((String)webRI.getWebServerPath());
                webWSWARPath = StringUtils.stripSlashSuffix((String)webRI.getWebServicesPath());
                if (!StringUtils.equals((String)userInputServerPath, (String)webWARPath) && !StringUtils.equals((String)userInputServerPath, (String)webWSWARPath)) {
                    if ("true".equalsIgnoreCase(RAMClientProperties.getProperty((String)RAMClientProperties.REQUEST_BASE_PATH_KEY_API))) {
                        userBaseUrl = userInputServerPath.substring(0, userInputServerPath.lastIndexOf(this.ramLocation.getPath()));
                        webWARPath = String.valueOf(userBaseUrl) + webWARPath.substring(webWARPath.lastIndexOf("/"));
                        webWSWARPath = String.valueOf(userBaseUrl) + webWSWARPath.substring(webWSWARPath.lastIndexOf("/"));
                        if (RAMClient.logger.isDebugEnabled()) {
                            RAMClient.logger.debug((Object)"Client base request url debugging is ON in API, base url for RAM war & webservice will be replaced by the base url passed in by user");
                            RAMClient.logger.debug((Object)("War URL changed FROM: " + webRI.getWebServerPath() + "TO: " + webWARPath));
                            RAMClient.logger.debug((Object)("Webservices URL changed FROM: " + webRI.getWebServicesPath() + "TO: " + webWSWARPath));
                        }
                        webRI.setWebServerPath(webWARPath);
                        webRI.setWebServicesPath(webWSWARPath);
                    } else {
                        throw new RAMServiceException(10009, String.valueOf(webWARPath) + "\r\n" + webWSWARPath + "\r\n" + Messages.getString((String)"ERROR_RAMClient_Use_Server_Configuration_URLs"));
                    }
                }
                RAMClient.validateURL(httpClient, String.valueOf(StringUtils.stripSlashSuffix((String)webRI.getWebServerPath())) + "/", this.userName, this.password, this.isAnonymous);
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): 1-Primed web-war session at: " + webRI.getWebServerPath() + " <<" + this.toString() + ">>"));
                }
                RAMClient.validateURL(httpClient, String.valueOf(StringUtils.stripSlashSuffix((String)webRI.getWebServerPath())) + "/", this.userName, this.password, this.isAnonymous);
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): 2-Primed web-war session at: " + webRI.getWebServerPath() + " <<" + this.toString() + ">>"));
                }
                RAMClient.validateURL(httpClient, String.valueOf(StringUtils.stripSlashSuffix((String)webRI.getWebServicesPath())) + "/", this.userName, this.password, this.isAnonymous);
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): 3-Primed ws-war session at: " + webRI.getWebServicesPath() + " <<" + this.toString() + ">>"));
                }
                RAMClient.validateURL(httpClient, String.valueOf(StringUtils.stripSlashSuffix((String)webRI.getWebServicesPath())) + "/", this.userName, this.password, this.isAnonymous);
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): 4-Primed ws-war session at: " + webRI.getWebServicesPath() + " <<" + this.toString() + ">>"));
                }
                connectionHolder.setRepositoryInformation(webRI);
                brotherURL = null;
                try {
                    if (webWSWARPath != null && this.ramLocation.toString().equals(webWARPath)) {
                        brotherURL = new URL(webWSWARPath);
                    } else if (webWARPath != null && this.ramLocation.toString().equals(webWSWARPath)) {
                        brotherURL = new URL(webWARPath);
                    }
                }
                catch (Exception v0) {}
                if (brotherURL != null && (aCconnectionHolder = connmap.get(brotherConnectionInfo = new ConnectionInfo(brotherURL, this.userName, this.password, this.onBehalfOfUserID))) == null) {
                    connmap.put(brotherConnectionInfo, connectionHolder);
                }
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): Finished creating a new HTTP-client <<" + this.toString() + ">>"));
                }
            } else {
                throw new RAMServiceException(10005, "Unable to identify server due to invalid response");
lbl115:
                // 1 sources

                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): Reusing existing HTTP-client <<" + this.toString() + ">>"));
                }
            }
            httpClientInitialized = true;
            if (!connectionHolder.isClientInHttpClientCreateList(this)) {
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)"initialize(): A HTTP client being provided, but is not in the list. Adding this client to create list.");
                }
                connectionHolder.addHttpClientCreate(this);
            }
            newWSClient = false;
            webService = connectionHolder.getWebService();
            if (webService == null) {
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): No WS-instance defined - creating one... <<" + this.toString() + ">>"));
                }
                try {
                    webService = tmpCreatedWS != null ? tmpCreatedWS : this.createRAMv72Client(connectionHolder);
                    if (RAMClient.logger.isDebugEnabled()) {
                        RAMClient.logger.debug((Object)("initialize(): No WS-instance defined - created <<" + this.toString() + ">>"));
                    }
                    newWSClient = true;
                    connectionHolder.setWebService(webService);
                }
                catch (MalformedURLException e) {
                    throw new RAMServiceException(10005, Messages.getString((String)"ERROR_RAMRepositoryClient_Invalid_URL"), (Throwable)e);
                }
                catch (ServiceException e) {
                    throw new RAMServiceException(10002, Messages.getString((String)"ERROR_RAMRepositoryClient_Invalid_URL"), (Throwable)e);
                }
            }
            if (newWSClient || connectionHolder.getRepositoryInformation() != null && (connectionHolder.getRepositoryInformation().getServicesVersion() == null || connectionHolder.getRepositoryInformation().getIdentifier() == null)) {
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)("initialize(): Priming the WS-instance sessions... <<" + this.toString() + ">>"));
                }
                try {
                    servicesVersion = webService.getVersion();
                    identifier = webService.getUniqueID();
                    if (connectionHolder.getRepositoryInformation().getServicesVersion() == null) {
                        connectionHolder.getRepositoryInformation().setServicesVersion(servicesVersion);
                    }
                    if (connectionHolder.getRepositoryInformation().getIdentifier() != null) ** GOTO lbl161
                    connectionHolder.getRepositoryInformation().setIdentifier(identifier);
                }
                catch (NumberFormatException ieee) {
                    RAMClient.logger.log((Priority)this.ERROR_LOG_LEVEL, (Object)"Not able to parse server version", (Throwable)ieee);
                    throw new RAMServiceException(10004, Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_UnableToDetermine"), (Throwable)ieee);
                }
                catch (RAMException e) {
                    if (e.isLicenseAvailable()) {
                        throw new RAMServiceException(10003, e.getMessage(), (Throwable)e);
                    }
                    throw new RAMServiceException(10004, Messages.getString((String)"RAM1AccessHTTPClient_Validate_NoLicense"), (Throwable)e);
                }
                catch (RemoteException ieee) {
                    RAMClient.logger.log((Priority)this.ERROR_LOG_LEVEL, (Object)"Not able to create connection to Asset Management Server", (Throwable)ieee);
                    throw new RAMServiceException(10002, MessageFormat.format(Messages.getString((String)"RAM1AccessHTTPClient_Error_NoServices"), new Object[]{ieee.getMessage()}), (Throwable)ieee);
                }
            } else if (RAMClient.logger.isDebugEnabled()) {
                RAMClient.logger.debug((Object)("initialize(): Reusing existing WS-instance <<" + this.toString() + ">>"));
            }
lbl161:
            // 5 sources

            wsClientInitialized = true;
            if (!connectionHolder.isClientInWebServicesClientCreateList(this)) {
                if (RAMClient.logger.isDebugEnabled()) {
                    RAMClient.logger.debug((Object)"initialize(): A WS-Client client being provided, but is not in the list. Adding this client to create list.");
                }
                connectionHolder.addWebServicesClientCreate(this);
            }
            if (needsCompatibilityCheck) {
                this.assertCompatibility(connectionHolder.getRepositoryInformation().getServicesVersion());
            }
            this.connectionHolder = connectionHolder;
            this.initialized = httpClientInitialized != false && wsClientInitialized != false;
        }
    }

    private void assertCompatibility(String serverVersionString) throws RAMServiceException {
        if (serverVersionString != null) {
            String client72Compatible;
            String client75Compatible;
            String client751Compatible;
            String client752Compatible;
            String client7521Compatible;
            String client7524Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_7524, serverVersionString);
            if (client7524Compatible != null && (client7521Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_7521, serverVersionString)) != null && (client752Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_752, serverVersionString)) != null && (client751Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_7511, serverVersionString)) != null && (client75Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_7502, serverVersionString)) != null && (client72Compatible = RAMClient.isClientCompatible(RICH_CLIENT_VERSION_7202, serverVersionString)) != null) {
                String serverString = RAMClient.getServerDisplayVersion(serverVersionString);
                String clientString = RAMClient.getServerDisplayVersion(RICH_CLIENT_VERSION_CURRENT);
                logger.log((Priority)Level.WARN, (Object)MessageFormat.format(Messages.getString((String)"VERSION_ERROR_MESSAGE"), serverString, clientString));
                throw new RAMServiceException(10000, client72Compatible);
            }
        } else {
            throw new RAMServiceException(10000, "Unable to determine server compatibility as it provides no version");
        }
    }

    private URL removeTrailingSlash(URL ramLocation) {
        try {
            if (ramLocation != null && ramLocation.getPath() != null && ramLocation.getPath().endsWith("/")) {
                String newURL = ramLocation.toString();
                newURL = newURL.substring(0, newURL.length() - 1);
                ramLocation = new URL(newURL);
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)"Unable to remove trainling slash", (Throwable)e);
        }
        return ramLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect(boolean force, Runnable disconnectCallback) {
        Map<ConnectionInfo, Connections> connmap;
        Map<ConnectionInfo, Connections> map = connmap = RAMClient.getConnections();
        synchronized (map) {
            if (this.connectionHolder == null) {
                ConnectionInfo connectionInfo = new ConnectionInfo(this.ramLocation, this.userName, this.password, this.onBehalfOfUserID);
                this.connectionHolder = connmap.get(connectionInfo);
            }
            if (this.connectionHolder != null) {
                boolean disconnectedHTTP = this.disconnectHTTP(this.connectionHolder, force);
                boolean disconnectedWS = this.disconnectWebServices(this.connectionHolder, force);
                try {
                    if (disconnectCallback != null && disconnectedHTTP && disconnectedWS) {
                        disconnectCallback.run();
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)"Problem in disconnect callback", e);
                }
                return disconnectedHTTP && disconnectedWS;
            }
            return true;
        }
    }

    public boolean disconnect(Runnable disconnectCallback) {
        return this.disconnect(false, disconnectCallback);
    }

    public boolean disconnect() {
        return this.disconnect(false, null);
    }

    private static String getResponseText(InputStream serverResponse, int responseCode) {
        String response;
        block3: {
            response = null;
            if (serverResponse != null) {
                try {
                    response = StringUtils.getStreamAsString((InputStream)serverResponse);
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        response = StringUtils.isBlank(response) ? HttpStatus.getStatusText((int)responseCode) : Utilities.stripHTML((String)response);
        return response;
    }

    protected boolean disconnectHTTP(Connections serverConnections, boolean force) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("disconnectHTTP(" + force + "):" + (serverConnections == null ? "NO connection" : "Attemping to remove this from connections") + " <<" + ((Object)((Object)this)).toString() + ">>"));
        }
        if (serverConnections != null) {
            if (force || serverConnections.isClientInHttpClientCreateList(this)) {
                if (force || serverConnections.getHttpClientCreateListSize() == 1) {
                    String webServerPath;
                    Repository ri;
                    URL webSvcsReleaseLicensesURL;
                    try {
                        webSvcsReleaseLicensesURL = this.getReleaseLicensesURL(serverConnections);
                    }
                    catch (MalformedURLException e1) {
                        logger.debug((Object)"Unable to release WebServices WAR HTTP licenses", (Throwable)e1);
                        webSvcsReleaseLicensesURL = null;
                    }
                    if (webSvcsReleaseLicensesURL != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("disconnectHTTP(" + force + "): Attempting to disconnect HTTP client:" + webSvcsReleaseLicensesURL + " <<" + ((Object)((Object)this)).toString() + ">>"));
                        }
                        try {
                            AbstractRAMClient.Response response = this.getURL(webSvcsReleaseLicensesURL, false, 120000, RELEASE_HEADER);
                            if (response.code != 302 && response.code != 200) {
                                logger.warn((Object)("Unable to release WebServices WAR HTTP licenses: " + RAMClient.getResponseText(response.is, response.code)));
                            } else if (logger.isDebugEnabled()) {
                                logger.debug((Object)("disconnectHTTP(" + force + "): Disconnected WS-WAR: [[" + webSvcsReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"));
                            }
                            response.is.close();
                        }
                        catch (RAMServiceException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("disconnectHTTP(" + force + "): Unable to disconnect WS-WAR: [[" + webSvcsReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"), (Throwable)e);
                            }
                            logger.warn((Object)("disconnectHTTP(" + force + "): Unable to disconnect WS-WAR: [[" + webSvcsReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>:" + e.getMessage()));
                        }
                        catch (IOException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("disconnectHTTP(" + force + "): Unable to disconnect WS-WAR: [[" + webSvcsReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"), (Throwable)e);
                            }
                            logger.warn((Object)("disconnectHTTP(" + force + "): Unable to disconnect WS-WAR: [[" + webSvcsReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>:" + e.getMessage()));
                        }
                    }
                    if ((ri = serverConnections.getRepositoryInformation()) != null && (webServerPath = ri.getWebServerPath()) != null) {
                        URL webReleaseLicensesURL;
                        String webReleaseURL = String.valueOf(webServerPath) + (webServerPath.endsWith("/") ? "logout.jsp?clientLogout=true" : "/logout.jsp?clientLogout=true");
                        try {
                            webReleaseLicensesURL = new URL(webReleaseURL);
                        }
                        catch (MalformedURLException e1) {
                            logger.debug((Object)"Unable to release Web WAR HTTP licenses", (Throwable)e1);
                            webReleaseLicensesURL = null;
                        }
                        if (webReleaseLicensesURL != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("disconnectHTTP(" + force + "): Attempting to disconnect HTTP client:" + webReleaseLicensesURL + " <<" + ((Object)((Object)this)).toString() + ">>"));
                            }
                            try {
                                AbstractRAMClient.Response response = this.getURL(webReleaseLicensesURL, false, 120000);
                                if (response.code != 302 && response.code != 200) {
                                    logger.warn((Object)("Unable to release Web WAR HTTP licenses: " + RAMClient.getResponseText(response.is, response.code)));
                                } else if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("disconnectHTTP(" + force + "): Disconnected Web-WAR: [[" + webReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"));
                                }
                                response.is.close();
                            }
                            catch (RAMServiceException e) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("disconnectHTTP(" + force + "): Unable to disconnect Web-WAR: [[" + webReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"), (Throwable)e);
                                }
                                logger.warn((Object)("disconnectHTTP(" + force + "): Unable to disconnect Web-WAR: [[" + webReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>: " + e.getMessage()));
                            }
                            catch (IOException e) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("disconnectHTTP(" + force + "): Unable to disconnect Web-WAR: [[" + webReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>"), (Throwable)e);
                                }
                                logger.warn((Object)("disconnectHTTP(" + force + "): Unable to disconnect Web-WAR: [[" + webReleaseLicensesURL + "] <<" + ((Object)((Object)this)).toString() + ">>: " + e.getMessage()));
                            }
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("disconnectHTTP(" + force + "): Ignoring disconnect as the create-count is not back to 1" + " <<" + ((Object)((Object)this)).toString() + ">>"));
                }
                serverConnections.removeHttpClientCreate(this);
                if (force) {
                    serverConnections.clearHttpClientCreates();
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("disconnectHTTP(" + force + "): There is no HTTP client in list " + " <<" + ((Object)((Object)this)).toString() + ">>"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("disconnectHTTP(" + force + "): There are no client instances created " + " <<" + ((Object)((Object)this)).toString() + ">>"));
        }
        return serverConnections == null ? true : serverConnections.getHttpClientCreateListSize() < 1;
    }

    protected boolean disconnectWebServices(Connections serverConnections, boolean force) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("disconnectWebServices(" + force + "):" + (serverConnections == null ? "NO connection" : "Attemping to remove this from connections") + " <<" + ((Object)((Object)this)).toString() + ">>"));
        }
        if (serverConnections != null && (serverConnections.isClientInWebServicesClientCreateList(this) || force)) {
            if (force || serverConnections.getWebServicesClientCreateListSize() == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("disconnectWebServices(" + force + "): Attempting to disconnect WS client..." + " <<" + ((Object)((Object)this)).toString() + ">>"));
                }
                try {
                    com.ibm.ram.internal.access.ws.RAM1 ram1Webservice = this.getRAM1Webservice(serverConnections);
                    if (ram1Webservice != null) {
                        ram1Webservice.releaseLicenses();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("disconnectWebServices(" + force + "): Disconnected Webservices" + " <<" + ((Object)((Object)this)).toString() + ">>"));
                    }
                }
                catch (RemoteException e) {
                    logger.debug((Object)"Unable to release WebServices licenses", (Throwable)e);
                }
                catch (RAMServiceException e) {
                    logger.debug((Object)"Unable to release WebServices licenses", (Throwable)e);
                }
                catch (RAMException e) {
                    logger.debug((Object)"Unable to release WebServices licenses", (Throwable)e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("disconnectWebServices(" + force + "): Ignoring disconnect as the create-count is not back to 1" + " <<" + ((Object)((Object)this)).toString() + ">>"));
            }
            serverConnections.removeWebServicesClientCreate(this);
            if (force) {
                serverConnections.clearWebServiceClientCreates();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("disconnectWebServices(" + force + "): No WS disconnect as either WS-create-count is less than 1 or there is no WS client" + " <<" + ((Object)((Object)this)).toString() + ">>"));
        }
        return serverConnections == null ? true : serverConnections.getWebServicesClientCreateListSize() < 1;
    }

    public String getWebServicesPath() {
        if (this.connectionHolder == null) {
            try {
                this.initialize();
            }
            catch (RAMServiceException e) {
                logger.log((Priority)Level.WARN, (Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.connectionHolder != null) {
            return this.connectionHolder.getRepositoryInformation().getWebServicesPath();
        }
        return null;
    }

    public String getRepositoryID() {
        if (this.connectionHolder == null) {
            try {
                this.initialize();
            }
            catch (RAMServiceException e) {
                logger.log((Priority)Level.WARN, (Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.connectionHolder != null) {
            return this.connectionHolder.getRepositoryInformation().getIdentifier();
        }
        return null;
    }

    public String getUserName() {
        return this.userName;
    }

    public Constants getWebServiceConstants() throws RAMException, RemoteException, MalformedURLException, RAMServiceException {
        if (webServiceConstants == null) {
            webServiceConstants = this.getRAM1Webservice().getConstants();
        }
        return webServiceConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.ibm.ram.internal.access.ws.RAM1 getRAM1Webservice() throws RAMServiceException {
        Map<ConnectionInfo, Connections> connmap;
        Map<ConnectionInfo, Connections> map = connmap = RAMClient.getConnections();
        synchronized (map) {
            if (this.connectionHolder == null) {
                this.initialize();
            }
            if (this.connectionHolder != null) {
                return this.getRAM1Webservice(this.connectionHolder);
            }
            return null;
        }
    }

    private com.ibm.ram.internal.access.ws.RAM1 getRAM1Webservice(Connections connection) throws RAMServiceException {
        return connection.getWebService();
    }

    public static Map<ConnectionInfo, Connections> getConnections() {
        if (connections.get() == null) {
            HashMap conmap = new HashMap();
            connections.compareAndSet(null, conmap);
        }
        return connections.get();
    }

    public AbstractRAMClient.ServerVersion getServerVersion() throws RAMServiceException {
        String serverVersionString = this.getServerVersionString();
        if (serverVersionString != null) {
            return (AbstractRAMClient.ServerVersion)serviceToServerReleaseVersion.get(serverVersionString);
        }
        return null;
    }

    public static String getServerDisplayVersion(String servicesVersion) {
        String display = null;
        if (servicesVersion != null) {
            display = serviceToProductVersionMap.containsKey(servicesVersion) ? (String)serviceToProductVersionMap.get(servicesVersion) : "[" + servicesVersion + "]";
        }
        return display;
    }

    public String getServerVersionString() throws RAMServiceException {
        this.initialize();
        if (this.connectionHolder != null) {
            return this.connectionHolder.getRepositoryInformation().getServicesVersion();
        }
        return null;
    }

    private com.ibm.ram.internal.access.ws.RAM1 createRAMv72Client(Connections connectionHolder) throws MalformedURLException, ServiceException {
        return this.createRAMv72Client(connectionHolder.getRepositoryInformation().getWebServicesPath(), connectionHolder.isLoggedOut());
    }

    private com.ibm.ram.internal.access.ws.RAM1 createRAMv72Client(String wsPath, boolean loggedOut) throws MalformedURLException, ServiceException {
        RAM1ServiceLocator locator = new RAM1ServiceLocator();
        URL wsURL = !this.isAnonymous ? new URL(String.valueOf(wsPath) + RAMSECURE_PATH + RAM_WS_SERVLET) : new URL(String.valueOf(wsPath) + RAM_WS_SERVLET);
        RAM1 ramv72 = locator.getRAM1(wsURL);
        if (ramv72 instanceof javax.xml.rpc.Stub) {
            this.updateWebServiceProperties((javax.xml.rpc.Stub)((Object)ramv72), this.userName, this.password, this.getWebServicesTimeout());
        }
        if (ramv72 instanceof Stub) {
            Stub stub = (Stub)((Object)ramv72);
            stub._setProperty("com.ibm.ram.rich.client.isLoggedOut", loggedOut);
            if (!StringUtils.isBlank((String)this.getOnBehalfOfUserID())) {
                stub._setProperty("com.ibm.ram.asuser", this.getOnBehalfOfUserID());
            }
        }
        return new RAMv72(ramv72);
    }

    public AbstractRAMClient.Response getURL(URL url, boolean followRedirects, int timeout) throws IOException, RAMServiceException {
        return this.getURL(url, followRedirects, timeout, null);
    }

    public AbstractRAMClient.Response getURL(URL url, boolean followRedirects, int timeout, Map<String, String> headers) throws IOException, RAMServiceException {
        HttpClient client = this.getHTTPClient();
        AbstractRAMClient.Response r = null;
        final GetMethod getAssetMethod = RAMClient.createGet(url.toExternalForm());
        try {
            if (this.isAuthenticationRequired()) {
                getAssetMethod.setDoAuthentication(true);
                client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                client.getParams().setAuthenticationPreemptive(true);
            }
            getAssetMethod.getParams().setSoTimeout(timeout);
            int urlDownloadTimeout = RAMClientUtilities.getURLDownloadTimeout(url.toString());
            if (urlDownloadTimeout > -1) {
                getAssetMethod.getParams().setSoTimeout(urlDownloadTimeout);
            }
            getAssetMethod.setFollowRedirects(followRedirects);
            if (headers != null && !headers.isEmpty()) {
                Set<String> keys = headers.keySet();
                for (String key : keys) {
                    getAssetMethod.addRequestHeader(key, headers.get(key));
                }
            }
            r = new AbstractRAMClient.Response();
            r.code = client.executeMethod((HttpMethod)getAssetMethod);
            InputStream internalStream = getAssetMethod.getResponseBodyAsStream();
            FilterInputStream releaseInputStream = internalStream == null ? null : new FilterInputStream(internalStream){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        getAssetMethod.releaseConnection();
                    }
                }
            };
            r.is = releaseInputStream;
            r.headers = RAMClient.getHeaders((HttpMethod)getAssetMethod);
            r.cookies = RAMClient.getCookies((HttpMethod)getAssetMethod);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            if (message.equals("The repository connection is currently logged out")) {
                throw new RAMServiceException(10008, message, (Throwable)e);
            }
            throw e;
        }
        return r;
    }

    private static void populateSplitCookies(String cookie, List<String> list) {
        String[] split;
        if (cookie != null && (split = cookie.split(";")) != null) {
            int sc = 0;
            while (sc < split.length) {
                if (!list.contains(split[sc])) {
                    list.add(split[sc]);
                }
                ++sc;
            }
        }
    }

    private static List<String> getCookies(HttpMethod method) {
        ArrayList<String> cookies = new ArrayList<String>();
        if (method != null) {
            int hc;
            Header[] headers = method.getRequestHeaders();
            if (headers != null) {
                hc = 0;
                while (hc < headers.length) {
                    if ("set-cookie".equalsIgnoreCase(headers[hc].getName())) {
                        RAMClient.populateSplitCookies(headers[hc].getValue(), cookies);
                    } else if ("cookie".equalsIgnoreCase(headers[hc].getName())) {
                        RAMClient.populateSplitCookies(headers[hc].getValue(), cookies);
                    }
                    ++hc;
                }
            }
            if ((headers = method.getResponseHeaders()) != null) {
                hc = 0;
                while (hc < headers.length) {
                    if ("set-cookie".equalsIgnoreCase(headers[hc].getName())) {
                        RAMClient.populateSplitCookies(headers[hc].getValue(), cookies);
                    } else if ("cookie".equalsIgnoreCase(headers[hc].getName())) {
                        RAMClient.populateSplitCookies(headers[hc].getValue(), cookies);
                    }
                    ++hc;
                }
            }
        }
        return cookies.isEmpty() ? null : cookies;
    }

    private static HashMap<String, String> getHeaders(HttpMethod getAssetMethod) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Header[] responseHeaders = getAssetMethod.getResponseHeaders();
        if (responseHeaders != null) {
            int hc = 0;
            while (hc < responseHeaders.length) {
                headers.put(responseHeaders[hc].getName(), responseHeaders[hc].getValue());
                ++hc;
            }
        }
        return headers;
    }

    public InputStream getInputStream(URL url) throws IOException, RAMServiceException {
        InputStream is = null;
        AbstractRAMClient.Response response = this.getURL(url, true, 0);
        if (200 == response.code) {
            is = response.is;
        } else {
            if (response.is != null) {
                response.is.close();
            }
            is = null;
        }
        return is;
    }

    public AbstractRAMClient.DownloadRequest download(String uri) throws RAMServiceException {
        String message;
        HttpClient client = this.getHTTPClient();
        long size = -1L;
        InputStream is = null;
        RAMServiceException rame = null;
        final GetMethod getAssetMethod = RAMClient.createGet(uri);
        try {
            if (this.isAuthenticationRequired()) {
                getAssetMethod.setDoAuthentication(true);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                client.getParams().setAuthenticationPreemptive(true);
            }
            int statusCode = client.executeMethod((HttpMethod)getAssetMethod);
            Header responseHeader = getAssetMethod.getResponseHeader("Content-Length");
            if (responseHeader != null) {
                try {
                    size = Long.parseLong(responseHeader.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    size = -1L;
                }
            }
            if (200 == statusCode) {
                is = getAssetMethod.getResponseBodyAsStream();
            } else {
                is = null;
                rame = new RAMServiceException(statusCode, String.valueOf(HttpStatus.getStatusText((int)statusCode)) + "\r\n" + getAssetMethod.getResponseBodyAsString());
            }
        }
        catch (HttpException e) {
            message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            rame = new RAMServiceException(10002, message, (Throwable)e);
        }
        catch (IOException e) {
            message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            rame = message.equals("The repository connection is currently logged out") ? new RAMServiceException(10008, message, (Throwable)e) : new RAMServiceException(10002, message, (Throwable)e);
        }
        final RAMServiceException exception = rame;
        final long fileSize = size;
        final InputStream fis = is;
        return new AbstractRAMClient.DownloadRequest(){

            public long getContentLength() {
                return fileSize;
            }

            public InputStream getInputStream() throws IOException {
                return fis;
            }

            public void releaseConnection() {
                getAssetMethod.releaseConnection();
            }

            public RAMServiceException getException() {
                return exception;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHTTPClient() throws RAMServiceException {
        Map<ConnectionInfo, Connections> connmap;
        Map<ConnectionInfo, Connections> map = connmap = RAMClient.getConnections();
        synchronized (map) {
            if (this.connectionHolder == null) {
                this.initialize();
            }
            if (this.connectionHolder != null) {
                return this.connectionHolder.getHttpClient();
            }
            return null;
        }
    }

    public RESTClient getRestClient() throws RAMServiceException {
        this.initialize();
        RESTClient client = new RESTClient(this);
        return client;
    }

    public int getWebServicesTimeout() {
        return this.webServicesTimeout;
    }

    public void setWebServicesTimeout(int webServicesTimeout) {
        IRAMService ramSvc;
        com.ibm.ram.internal.access.ws.RAM1 webService;
        this.webServicesTimeout = webServicesTimeout;
        if (this.connectionHolder != null && (webService = this.connectionHolder.getWebService()) instanceof IRAMService && (ramSvc = (IRAMService)webService).getStub() instanceof Stub) {
            Stub stub = (Stub)ramSvc.getStub();
            stub.setTimeout(this.getWebServicesTimeout());
        }
    }

    private void updateWebServiceProperties(javax.xml.rpc.Stub ramWebService, String userName, String password, int timeout) {
        if (ramWebService != null) {
            javax.xml.rpc.Stub testStub = ramWebService;
            if (userName != null && userName.length() > 0) {
                testStub._setProperty("javax.xml.rpc.security.auth.username", userName);
                testStub._setProperty("javax.xml.rpc.security.auth.password", password);
            }
            if (testStub instanceof Stub) {
                Stub axisStub = (Stub)testStub;
                axisStub.setTimeout(timeout);
                axisStub.setMaintainSession(true);
            }
            testStub._setProperty("com.ibm.wsspi.webservices.Constants.HTTP_REDIRECT_ENABLED", Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCachedConnection(URL ramLocation, String userName, String password, String onBehalfOfUserID) {
        Map<ConnectionInfo, Connections> conmap;
        if (connections.get() == null) {
            return;
        }
        if (ramLocation == null) {
            return;
        }
        if (userName == null) {
            return;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(ramLocation, userName, password, onBehalfOfUserID);
        Map<ConnectionInfo, Connections> map = conmap = RAMClient.getConnections();
        synchronized (map) {
            conmap.remove(connectionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionLoggedOut() {
        if (this.connectionHolder != null) {
            return this.connectionHolder.isLoggedOut();
        }
        Map<ConnectionInfo, Connections> connmap = connections.get();
        if (connmap != null) {
            Map<ConnectionInfo, Connections> map = connmap;
            synchronized (map) {
                ConnectionInfo connectionInfo = new ConnectionInfo(this.ramLocation, this.userName, this.password, this.onBehalfOfUserID);
                Connections connectionHolder = connmap.get(connectionInfo);
                if (connectionHolder != null) {
                    return connectionHolder.isLoggedOut();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionLogoutStatus(URL ramLocation, String userName, String password, boolean isLoggedOut) {
        Map<ConnectionInfo, Connections> connmap;
        ConnectionInfo connectionInfo = new ConnectionInfo(ramLocation, userName, password, null);
        Map<ConnectionInfo, Connections> map = connmap = RAMClient.getConnections();
        synchronized (map) {
            IRAMService ramSvc;
            Connections connectionHolder = connmap.get(connectionInfo);
            if (connectionHolder == null) {
                connectionHolder = new Connections();
                connectionHolder.setLoggedOut(isLoggedOut);
                connmap.put(connectionInfo, connectionHolder);
            } else {
                connectionHolder.setLoggedOut(isLoggedOut);
            }
            com.ibm.ram.internal.access.ws.RAM1 webService = connectionHolder.getWebService();
            if (webService != null && webService instanceof IRAMService && (ramSvc = (IRAMService)webService).getStub() instanceof Stub) {
                Stub stub = (Stub)ramSvc.getStub();
                stub._setProperty("com.ibm.ram.rich.client.isLoggedOut", isLoggedOut);
            }
        }
    }

    private static String isClientCompatible(String clientVersion, String serverVersion) {
        boolean isCompatible = false;
        String message = null;
        if (clientVersion != null && serverVersion != null) {
            String[] serverVersionNumbers = serverVersion.split("\\.");
            String[] clientVersionNumbers = clientVersion.split("\\.");
            if (serverVersionNumbers != null && serverVersionNumbers.length == 4 && clientVersionNumbers != null && clientVersionNumbers.length == 4) {
                try {
                    int serverMajor = Integer.parseInt(serverVersionNumbers[0]);
                    int serverMinor = Integer.parseInt(serverVersionNumbers[1]);
                    int serverService = Integer.parseInt(serverVersionNumbers[2]);
                    int clientMajor = Integer.parseInt(clientVersionNumbers[0]);
                    int clientMinor = Integer.parseInt(clientVersionNumbers[1]);
                    int clientService = Integer.parseInt(clientVersionNumbers[2]);
                    if (serverMajor == clientMajor && serverMinor == clientMinor && clientService >= serverService) {
                        isCompatible = true;
                        message = null;
                    } else {
                        isCompatible = false;
                        boolean isClientDownLevel = false;
                        isClientDownLevel = clientMajor < serverMajor ? true : (clientMajor > serverMajor ? false : (clientMinor < serverMinor ? true : (clientMinor > serverMinor ? false : false)));
                        message = isClientDownLevel ? Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_Client_Downlevel") : Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_Client_Uplevel");
                    }
                }
                catch (NumberFormatException e) {
                    logger.log((Priority)Level.WARN, (Object)Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_UnableToDetermine"), (Throwable)e);
                    isCompatible = false;
                    message = Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_UnableToDetermine");
                }
            }
        }
        if (!isCompatible && message == null) {
            message = Messages.getString((String)"RAM1AccessHTTPClient_Compatibility_UnableToDetermine");
        }
        if (isCompatible) {
            message = null;
        }
        return message;
    }

    protected boolean isAuthenticationRequired() {
        return !this.isAnonymous;
    }

    public URL getAssetDownloadURL(String guid, String version, boolean pendingAsset) throws MalformedURLException, RAMServiceException {
        this.initialize();
        String downloadPath = this.connectionHolder.getRepositoryInformation().getWebServicesPath();
        if (this.isAuthenticationRequired()) {
            downloadPath = String.valueOf(downloadPath) + RAMSECURE_PATH;
        }
        String assetIdEnc = RAMURLEncoder.encode((String)guid);
        String assetVersionEnc = RAMURLEncoder.encode((String)version);
        String args = "assetid=" + assetIdEnc + "&version=" + assetVersionEnc + "&pending=" + pendingAsset;
        URL downloadURL = new URL(String.valueOf(downloadPath) + "/RAMAssetAccess.jsp?" + args);
        return downloadURL;
    }

    private URL getReleaseLicensesURL(Connections connection) throws MalformedURLException {
        Repository ri = connection.getRepositoryInformation();
        if (ri == null) {
            return null;
        }
        String releaseLicenses = ri.getWebServicesPath();
        if (this.isAuthenticationRequired()) {
            releaseLicenses = String.valueOf(releaseLicenses) + RAMSECURE_PATH;
        }
        URL releaseLicensesURL = new URL(String.valueOf(releaseLicenses) + "/RAMAssetAccess.jsp?releaseLicenses");
        return releaseLicensesURL;
    }

    public URL getArtifactDownloadURL(String artifactPath, String assetId, String assetVersion, boolean pendingAsset) throws MalformedURLException, RAMServiceException {
        this.initialize();
        String downloadPath = this.connectionHolder.getRepositoryInformation().getWebServicesPath();
        if (this.isAuthenticationRequired()) {
            downloadPath = String.valueOf(downloadPath) + RAMSECURE_PATH;
        }
        String assetIdEnc = RAMURLEncoder.encode((String)assetId);
        String assetVersionEnc = RAMURLEncoder.encode((String)assetVersion);
        String artifactPathEnc = JAXButil.urlEncodePathSegments((String)artifactPath);
        URL downloadURL = new URL(String.valueOf(downloadPath) + "/" + "artifact" + (pendingAsset ? "/submission/" : "/") + assetIdEnc + "/" + assetVersionEnc + "/" + artifactPathEnc);
        return downloadURL;
    }

    public AbstractRAMClient.DownloadRequest downloadAsset(URL downloadURL, boolean requireZipContent) throws RAMServiceException {
        HttpClient client = this.getHTTPClient();
        final GetMethod getAssetMethod = RAMClient.createGet(downloadURL.toExternalForm());
        if (this.isAuthenticationRequired()) {
            getAssetMethod.setDoAuthentication(true);
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
            client.getParams().setAuthenticationPreemptive(true);
        }
        if (this.getUploadDownloadTimeout() > 0) {
            client.getParams().setSoTimeout(this.getUploadDownloadTimeout());
        }
        try {
            int statusCode = client.executeMethod((HttpMethod)getAssetMethod);
            if (200 == statusCode) {
                if (requireZipContent && !this.isZipContentType(getAssetMethod)) {
                    String message = MessageFormat.format(Messages.getString((String)"RAM1AccessHTTPClient_Downloading_Error"), StringUtils.getStreamAsString((InputStream)getAssetMethod.getResponseBodyAsStream()));
                    throw new RAMServiceException(statusCode, message);
                }
                return new AbstractRAMClient.DownloadRequest(){

                    public InputStream getInputStream() throws IOException {
                        return getAssetMethod.getResponseBodyAsStream();
                    }

                    public void releaseConnection() {
                        getAssetMethod.releaseConnection();
                    }

                    public long getContentLength() {
                        return getAssetMethod.getResponseContentLength();
                    }

                    public RAMServiceException getException() {
                        return null;
                    }
                };
            }
            String message = MessageFormat.format(Messages.getString((String)"RAM1AccessHTTPClient_Downloading_Error_Reason"), HttpStatus.getStatusText((int)statusCode), Utilities.stripHTML((String)StringUtils.getStreamAsString((InputStream)getAssetMethod.getResponseBodyAsStream())));
            logger.warn((Object)("HTTP Error trying to download: " + message));
            throw new RAMServiceException(statusCode, message);
        }
        catch (HttpException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            throw new RAMServiceException(10002, message, (Throwable)e);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            if (message.equals("The repository connection is currently logged out")) {
                throw new RAMServiceException(10008, message, (Throwable)e);
            }
            throw new RAMServiceException(10002, message, (Throwable)e);
        }
    }

    private HttpClient createHTTPClient() {
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(HTTPCLIENT_MAX_CONNECTIONS);
        params.setMaxTotalConnections(HTTPCLIENT_MAX_CONNECTIONS);
        HttpClient client = new HttpClient((HttpConnectionManager)httpConnectionManager){

            public int executeMethod(HttpMethod method) throws IOException, HttpException {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("#####HTTPClient: " + method.getName() + ">>>>" + method.getURI()));
                }
                if (RAMClient.this.isConnectionLoggedOut()) {
                    throw new IOException("The repository connection is currently logged out");
                }
                if (!StringUtils.isBlank((String)RAMClient.this.getOnBehalfOfUserID())) {
                    method.addRequestHeader("com.ibm.ram.asuser", RAMClient.this.getOnBehalfOfUserID());
                }
                return super.executeMethod(method);
            }
        };
        return client;
    }

    private boolean isZipContentType(GetMethod getAssetMethod) {
        Header contentTypeHeader = getAssetMethod.getResponseHeader("content-type");
        if (contentTypeHeader != null) {
            String contentType = contentTypeHeader.getValue().trim();
            int semicolonIndex = contentType.indexOf(59);
            if (semicolonIndex > -1 && semicolonIndex < contentType.length()) {
                contentType = contentType.substring(0, semicolonIndex);
            }
            if (contentType.equalsIgnoreCase("application/zip")) {
                return true;
            }
        }
        return false;
    }

    private URL getAssetUploadURL() throws MalformedURLException {
        String uploadPath = this.connectionHolder.getRepositoryInformation().getWebServicesPath();
        if (this.isAuthenticationRequired()) {
            uploadPath = String.valueOf(uploadPath) + RAMSECURE_PATH;
        }
        URL uploadURL = new URL(String.valueOf(uploadPath) + "/RAMAssetAccess.jsp");
        return uploadURL;
    }

    public AbstractRAMClient.UploadResponse uploadAsset(String serializedAsset, File artifacts, int assetGroupID, String stateOption, String userAssetTags, boolean isDelta, boolean isUpdate, String updateComment, String updateOriginalGUID, String updateOriginalVersion, boolean keepOlderAssetVersion, boolean updatePendingAsset, boolean overrideValidation, String[] newOwnerIDs, int managementStyle, boolean isTagOnly, final AbstractRAMClient.IUploadProgress uploadProgressMonitor) throws RAMServiceException, FileNotFoundException {
        try {
            int filePostStatus;
            long lastModified = -1L;
            AbstractRAMClient.ServerVersion version = this.getServerVersion();
            if (AbstractRAMClient.ServerVersion.VERSION_71.equals((Object)version)) {
                serializedAsset = Utilitiesv71.getFixedDefaultProfileNamespace(serializedAsset);
            }
            URL uploadURL = this.getAssetUploadURL();
            ArrayList<Object> partsList = new ArrayList<Object>();
            String utfEncoding = "UTF-8";
            StringPart serializedManifestPart = new StringPart("serializedAsset", serializedAsset, utfEncoding);
            partsList.add(serializedManifestPart);
            StringPart groupIDPart = new StringPart("assetGroup", Integer.toString(assetGroupID), utfEncoding);
            partsList.add(groupIDPart);
            if (!isTagOnly) {
                if (newOwnerIDs != null && newOwnerIDs.length > 0) {
                    StringBuffer newOwnerIDsBuffer = new StringBuffer();
                    int oidc = 0;
                    while (oidc < newOwnerIDs.length) {
                        newOwnerIDsBuffer.append(newOwnerIDs[oidc].trim());
                        if (oidc < newOwnerIDs.length - 1) {
                            newOwnerIDsBuffer.append(",");
                        }
                        ++oidc;
                    }
                    StringPart newOwnerIDPart = new StringPart("assetOwnerIDs", newOwnerIDsBuffer.toString(), utfEncoding);
                    partsList.add(newOwnerIDPart);
                }
                if (artifacts != null) {
                    FilePartWithProgress assetFilePart = new FilePartWithProgress("assetFile", artifacts, uploadProgressMonitor);
                    partsList.add((Object)assetFilePart);
                }
                if (stateOption != null) {
                    StringPart stateOptionPart = new StringPart("stateOption", stateOption, utfEncoding);
                    partsList.add(stateOptionPart);
                }
                if (isDelta) {
                    StringPart isDeltaPart = new StringPart("isDelta", "on", utfEncoding);
                    partsList.add(isDeltaPart);
                }
            } else {
                StringPart tagOnlyPart = new StringPart("isTagOnly", "on", utfEncoding);
                partsList.add(tagOnlyPart);
            }
            if (isUpdate) {
                StringPart isUpdatePart = new StringPart("isUpdate", "on", utfEncoding);
                partsList.add(isUpdatePart);
                if (updateComment != null && updateComment.length() > 0) {
                    StringPart updateCommentPart = new StringPart("updateComment", updateComment, utfEncoding);
                    partsList.add(updateCommentPart);
                }
                StringPart updateOriginalGUIDPart = new StringPart("updateOriginalGUID", updateOriginalGUID, utfEncoding);
                partsList.add(updateOriginalGUIDPart);
                StringPart updateOriginalVersionPart = new StringPart("updateOriginalVersion", updateOriginalVersion, utfEncoding);
                partsList.add(updateOriginalVersionPart);
                String keepOlderAssetVersionValue = keepOlderAssetVersion ? "on" : "off";
                StringPart keepOlderAssetVersionPart = new StringPart("isKeepOldAssetVersion", keepOlderAssetVersionValue, utfEncoding);
                partsList.add(keepOlderAssetVersionPart);
                String updatePendingAssetValue = updatePendingAsset ? "on" : "off";
                StringPart updatePendingAssetPart = new StringPart("updateOriginalSubmission", updatePendingAssetValue, utfEncoding);
                partsList.add(updatePendingAssetPart);
                if (overrideValidation) {
                    StringPart isOverrideValidationPart = new StringPart("isOverrideValidation", "on", utfEncoding);
                    partsList.add(isOverrideValidationPart);
                }
            }
            StringPart userAssetTagsPart = new StringPart("userAssetTags", userAssetTags, utfEncoding);
            partsList.add(userAssetTagsPart);
            Part[] parts = partsList.toArray(new Part[partsList.size()]);
            final PostMethod filePost = new PostMethod(uploadURL.toExternalForm());
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            filePost.setContentChunked(true);
            HttpClient client = this.getHTTPClient();
            if (this.isAuthenticationRequired()) {
                client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                filePost.setDoAuthentication(true);
                client.getParams().setAuthenticationPreemptive(true);
            }
            if (this.getUploadDownloadTimeout() > 0) {
                client.getParams().setSoTimeout(this.getUploadDownloadTimeout());
            }
            final boolean[] uploadFinished = new boolean[1];
            Thread monitorCancelCheckThread = new Thread("RAM asset upload user cancel checking thread"){

                @Override
                public void run() {
                    while (!uploadFinished[0]) {
                        if (uploadProgressMonitor.isCanceled()) {
                            if (filePost.isAborted()) continue;
                            filePost.abort();
                            continue;
                        }
                        try {
                            5.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            logger.debug((Object)"Interrupted checking for user cancelling upload", (Throwable)e);
                        }
                    }
                }
            };
            monitorCancelCheckThread.start();
            try {
                filePostStatus = client.executeMethod((HttpMethod)filePost);
            }
            finally {
                uploadFinished[0] = true;
            }
            String responseBodyAsString = StringUtils.getStreamAsString((InputStream)filePost.getResponseBodyAsStream());
            if (200 != filePostStatus) {
                String statusText;
                logger.warn((Object)("HTTP Error trying to upload. (" + filePostStatus + ": " + HttpStatus.getStatusText((int)filePostStatus) + "), STATUSTEXT:" + filePost.getStatusText() + ", RESPONSE:" + Utilities.stripHTML((String)responseBodyAsString)));
                Header responseErrorHeader = filePost.getResponseHeader("com.ibm.ram.error");
                if (responseErrorHeader == null) {
                    statusText = filePost.getStatusText().trim();
                    if (HttpStatus.getStatusText((int)filePostStatus).trim().equalsIgnoreCase(statusText)) {
                        String messageResponse = responseBodyAsString;
                        String errorCodeString = String.valueOf(Integer.toString(filePostStatus)) + ":";
                        int indexOfErrorCode = messageResponse.indexOf(errorCodeString);
                        if (indexOfErrorCode > -1) {
                            messageResponse = messageResponse.substring(indexOfErrorCode + errorCodeString.length()).trim();
                        }
                        StringTokenizer tokenizer = new StringTokenizer(messageResponse, "\n\r");
                        statusText = String.valueOf(tokenizer.nextToken()) + "\n" + statusText;
                    }
                } else {
                    String message = responseErrorHeader.getValue();
                    int firstSemicolonInex = message.indexOf(58);
                    if (firstSemicolonInex > 0) {
                        try {
                            if (message.length() - 1 > firstSemicolonInex) {
                                message = message.substring(firstSemicolonInex + 1);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    statusText = message;
                }
                throw new RAMServiceException(filePostStatus, statusText);
            }
            Header[] lastModifiedHeaders = filePost.getResponseHeaders("Last-Modified");
            if (lastModifiedHeaders != null) {
                int hc = 0;
                while (hc < lastModifiedHeaders.length) {
                    try {
                        Date date = DateUtil.parseDate((String)lastModifiedHeaders[hc].getValue());
                        if (date != null) {
                            lastModified = date.getTime();
                        }
                    }
                    catch (DateParseException e) {
                        logger.log((Priority)Level.WARN, (Object)"Unable to determine last modified time", (Throwable)e);
                    }
                    ++hc;
                }
            }
            String serverResponse = responseBodyAsString;
            Header revisionHeader = filePost.getResponseHeader("com.ibm.ram.asset.revision");
            if (revisionHeader != null) {
                serverResponse = revisionHeader.getValue();
            }
            boolean pendingAsset = false;
            Header pendingAssetHeader = filePost.getResponseHeader("com.ibm.ram.asset.pending");
            if (pendingAssetHeader != null) {
                pendingAsset = Boolean.valueOf(pendingAssetHeader.getValue());
            }
            AbstractRAMClient.UploadResponse response = new AbstractRAMClient.UploadResponse();
            response.newRevisionCount = RAMClient.getServerRevisonCountFromSuccess(serverResponse);
            response.pendingAsset = pendingAsset;
            response.lastModified = lastModified;
            return response;
        }
        catch (HttpException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            throw new RAMServiceException(10002, message, (Throwable)e);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Error in transport medium trying to communicate with server";
            }
            throw new RAMServiceException(10002, message, (Throwable)e);
        }
    }

    private static int getServerRevisonCountFromSuccess(String serverResponse) {
        int revision = -1;
        String message = serverResponse;
        if (message != null && message.length() > 0) {
            try {
                int latestServerRevision = Integer.parseInt(message.trim());
                if (latestServerRevision > -1) {
                    revision = latestServerRevision;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return revision;
    }

    public InputStream getInputStream(URL url, final WriteServerDataCallback callback) throws IOException, RAMServiceException {
        InputStream is = null;
        HttpClient client = this.getHTTPClient();
        PostMethod postMethod = new PostMethod(url.toExternalForm());
        try {
            if (this.isAuthenticationRequired()) {
                postMethod.setDoAuthentication(true);
                client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                client.getParams().setAuthenticationPreemptive(true);
            }
            postMethod.setRequestEntity(new RequestEntity(){

                public long getContentLength() {
                    return callback.getContentLength();
                }

                public String getContentType() {
                    return callback.getContentMimeType();
                }

                public boolean isRepeatable() {
                    return true;
                }

                public void writeRequest(OutputStream out) throws IOException {
                    callback.writeDataToServer(out);
                    out.flush();
                }
            });
            int statusCode = client.executeMethod((HttpMethod)postMethod);
            is = 200 == statusCode ? postMethod.getResponseBodyAsStream() : null;
        }
        catch (IOException e) {
            if ("The repository connection is currently logged out".equals(e.getMessage())) {
                throw new RAMServiceException(10008, e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        return is;
    }

    public int getUploadDownloadTimeout() {
        return this.uploadDownloadTimeout;
    }

    public void setUploadDownloadTimeout(int uploadDownloadTimeout) {
        this.uploadDownloadTimeout = uploadDownloadTimeout;
    }

    String getPassword() {
        return this.password;
    }

    public String getOnBehalfOfUserID() {
        return this.onBehalfOfUserID;
    }

    private static void mergeCookies(List<String> allCookies, List<String> newCookies) {
        if (allCookies != null && newCookies != null) {
            for (String newCookie : newCookies) {
                if (allCookies.contains(newCookie)) continue;
                allCookies.add(newCookie);
            }
        }
    }

    static GetMethod createGet(String url) {
        GetMethod method = new GetMethod(url);
        method.getParams().setParameter("http.method.retry-handler", (Object)DEFAULT_RETRY_HANDLER);
        return method;
    }

    static HeadMethod createHead(String url) {
        HeadMethod method = new HeadMethod(url);
        method.getParams().setParameter("http.method.retry-handler", (Object)DEFAULT_RETRY_HANDLER);
        return method;
    }

    static PutMethod createPut(String url) {
        PutMethod method = new PutMethod(url);
        method.getParams().setParameter("http.method.retry-handler", (Object)DEFAULT_RETRY_HANDLER);
        return method;
    }

    public static AbstractRAMClient.Response doFormAuthentication(String restrictedResourcePath, String loginID, String password, HttpClient httpclient) {
        AbstractRAMClient.Response done;
        block12: {
            ArrayList<String> allCookiesList = new ArrayList<String>();
            done = null;
            GetMethod initialURLGet = RAMClient.createGet(restrictedResourcePath);
            initialURLGet.setFollowRedirects(false);
            try {
                httpclient.getParams().setCookiePolicy("compatibility");
                httpclient.getParams().setAuthenticationPreemptive(true);
                initialURLGet.setDoAuthentication(true);
                initialURLGet.setFollowRedirects(true);
                httpclient.executeMethod((HttpMethod)initialURLGet);
                RAMClient.mergeCookies(allCookiesList, RAMClient.getCookies((HttpMethod)initialURLGet));
                int initialResponse = initialURLGet.getStatusCode();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Initial response code from URI: " + initialURLGet.getURI() + " is: " + initialResponse));
                }
                if (initialResponse == 301) {
                    throw new IOException("Invalid location: " + restrictedResourcePath);
                }
                if (initialResponse != 200) break block12;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Received OK");
                }
                String response = initialURLGet.getResponseBodyAsString();
                initialURLGet.releaseConnection();
                logger.debug((Object)("Login screen visible for: " + restrictedResourcePath));
                String loginPath = restrictedResourcePath.lastIndexOf(47) > -1 ? restrictedResourcePath.substring(0, restrictedResourcePath.lastIndexOf(47)) : restrictedResourcePath;
                loginPath = String.valueOf(loginPath) + "/j_security_check";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Post to the login form: " + loginPath));
                }
                PostMethod formAuthPost = new PostMethod(loginPath);
                formAuthPost.addRequestHeader("Referer", restrictedResourcePath);
                NameValuePair[] postData = new NameValuePair[]{new NameValuePair("j_username", loginID), new NameValuePair("j_password", password)};
                formAuthPost.setRequestBody(postData);
                int postResponse = httpclient.executeMethod((HttpMethod)formAuthPost);
                RAMClient.mergeCookies(allCookiesList, RAMClient.getCookies((HttpMethod)formAuthPost));
                if (postResponse == 200) {
                    done = new AbstractRAMClient.Response();
                    done.code = postResponse;
                    done.headers = RAMClient.getHeaders((HttpMethod)formAuthPost);
                    done.is = new ByteArrayInputStream(formAuthPost.getResponseBody());
                    done.cookies = allCookiesList;
                    break block12;
                }
                if (postResponse == 302) {
                    if (formAuthPost.getResponseHeader("Location") == null) {
                        formAuthPost.releaseConnection();
                        throw new IOException("Temporary redirect (302) without 'Location' response header.");
                    }
                    String forwardURI = formAuthPost.getResponseHeader("Location").getValue();
                    formAuthPost.releaseConnection();
                    logger.debug((Object)("Get the redirected page: " + forwardURI));
                    GetMethod artifactGet = RAMClient.createGet(forwardURI);
                    int agetReturnCode = httpclient.executeMethod((HttpMethod)artifactGet);
                    response = artifactGet.getResponseBodyAsString();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Login screen present at forwarded page? " + (response.indexOf("j_security_check") > -1)));
                    }
                    artifactGet.releaseConnection();
                    done = new AbstractRAMClient.Response();
                    done.code = agetReturnCode;
                    done.headers = RAMClient.getHeaders((HttpMethod)artifactGet);
                    done.is = new ByteArrayInputStream(response.getBytes());
                    RAMClient.mergeCookies(allCookiesList, RAMClient.getCookies((HttpMethod)artifactGet));
                    done.cookies = allCookiesList;
                    break block12;
                }
                if (postResponse == 404) {
                    done = new AbstractRAMClient.Response();
                    done.code = postResponse;
                    done.headers = RAMClient.getHeaders((HttpMethod)formAuthPost);
                    done.is = new ByteArrayInputStream(formAuthPost.getResponseBody());
                    done.cookies = allCookiesList;
                    break block12;
                }
                throw new IllegalStateException("Unexpected response to FORM authentication: " + postResponse);
            }
            catch (HttpException e) {
                logger.warn((Object)"Unable to perform FORM login", (Throwable)e);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to perform FORM login", (Throwable)e);
            }
        }
        return done;
    }

    public String getWebServerPath() {
        if (this.connectionHolder == null) {
            try {
                this.initialize();
            }
            catch (RAMServiceException e) {
                logger.log((Priority)Level.WARN, (Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.connectionHolder != null) {
            return this.connectionHolder.getRepositoryInformation().getWebServerPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areClientsDisconnected() {
        boolean disconnected;
        Map<ConnectionInfo, Connections> connmap;
        int httpCount = -1;
        int wsCount = -1;
        Map<ConnectionInfo, Connections> map = connmap = RAMClient.getConnections();
        synchronized (map) {
            if (this.connectionHolder != null) {
                httpCount = this.connectionHolder.getHttpClientCreateListSize();
                wsCount = this.connectionHolder.getWebServicesClientCreateListSize();
            }
            disconnected = httpCount < 1 && wsCount < 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("areClientsDisconnected():" + disconnected + "[HTTP:" + httpCount + ", WS:" + wsCount + "] <<" + ((Object)((Object)this)).toString() + ">>"));
        }
        return disconnected;
    }

    public String[] copySchemasToLocalOS(String[] schemauris, File localStorageFolder) throws IOException, RAMRuntimeException {
        File schemasFolder = new File(localStorageFolder, "schemas");
        if (!schemasFolder.exists()) {
            schemasFolder.mkdir();
        }
        String serverPath = this.getWebServerPath();
        String repoName = StringUtils.cleanFromUnsuitableFilechars((String)serverPath);
        return RAMClientUtilities.saveServerCategorySchemaFiles(repoName, schemauris, this, schemasFolder, (IProgressMonitor)new NullProgressMonitor());
    }

    public ResourceSet createCachedResourceSet(Map serverToLocalEMFURIResourceMap, File localStroageFolder) {
        try {
            String serverPath = this.getWebServerPath();
            String[] schemauris = this.getRAM1Webservice().getAllClassificationSchemaURI();
            String[] localURIs = this.copySchemasToLocalOS(schemauris, localStroageFolder);
            int i = 0;
            while (i < schemauris.length) {
                serverToLocalEMFURIResourceMap.put(URI.createURI((String)schemauris[i]), URI.createFileURI((String)localURIs[i]));
                ++i;
            }
            ResourceSet set = RAMClientUtilities.createResourceSet(serverPath, this, serverToLocalEMFURIResourceMap, true);
            return set;
        }
        catch (RemoteException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RAMServiceException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RAMException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RAMRuntimeException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public AbstractRAMClient.Response downloadArtifact(String path, String assetID, String assetVersion, boolean pending) throws IOException, RAMServiceException {
        URL artifactURL = this.getArtifactDownloadURL(path, assetID, assetVersion, pending);
        return this.getURL(artifactURL, true, 0);
    }

    public InputStream getInputStream(String fOriginalGUID, String fOriginalVersion, boolean pendingAsset) throws IOException, RAMServiceException {
        URL assetURL = this.getAssetDownloadURL(fOriginalGUID, fOriginalVersion, false);
        return this.getInputStream(assetURL);
    }

    public String getStatusText(int code) {
        return HttpStatus.getStatusText((int)code);
    }

    public void cleanResourceSet(ResourceSet rs) {
        if (rs != null && rs.getURIConverter() != null && rs.getURIConverter() instanceof ClientCachedRAMUriConverter) {
            ClientCachedRAMUriConverter ccuc = (ClientCachedRAMUriConverter)rs.getURIConverter();
            ccuc.clearUrlErrorMap();
        }
    }
}

