/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.FolderFileAccess;
import com.ibm.ram.fix.PatchControl;
import com.ibm.ram.fix.TouchFiles;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.log4j.Logger;

public abstract class FixVerify<M>
implements Closeable {
    private final FileAccess fa;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType;

    private Logger getLog() {
        return Logger.getLogger(FixVerify.class);
    }

    public FixVerify(FileAccess fa) {
        this.fa = fa;
    }

    @Override
    public void close() throws IOException {
        Apply.close(this.fa);
    }

    public Collection<M> getInstalledFixErrors() {
        boolean verifyNeeded = true;
        try {
            verifyNeeded = this.isVerifyNeeded(this.fa);
        }
        catch (Fixes.FileIsDirectory fileIsDirectory) {
            return Collections.singletonList(this.createMessage("WebsphereAccessInstance.notDirectory", this.fa.getFullname("fix.verified")));
        }
        Collection<M> errors = null;
        if (verifyNeeded) {
            Fixes fixes = new Fixes(this.fa){

                @Override
                public void info(String msg) {
                    FixVerify.this.getLog().info((Object)msg);
                }

                @Override
                public void warn(String msg, Throwable exception) {
                    if (exception == null) {
                        FixVerify.this.getLog().warn((Object)msg);
                    } else {
                        FixVerify.this.getLog().warn((Object)msg, exception);
                    }
                }
            };
            Collection<PatchControl> testFixes = fixes.getInstalledFixes();
            if (!testFixes.isEmpty()) {
                HashMap<String, String> includedTestFixes = new HashMap<String, String>();
                for (PatchControl pc : testFixes) {
                    errors = this.verifyFix(pc, errors, includedTestFixes);
                }
            }
            if (errors == null) {
                block13: {
                    OutputStreamWriter wrtr = null;
                    OutputStream os = null;
                    try {
                        try {
                            os = this.fa.getOS("fix.verified");
                            wrtr = new OutputStreamWriter(os, Charset.forName("UTF-8"));
                            wrtr.write(Boolean.toString(true));
                        }
                        catch (IOException e) {
                            this.getLog().error((Object)"Couldn't create verified file.", (Throwable)e);
                            Apply.close(wrtr);
                            Apply.close(os);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        Apply.close(wrtr);
                        Apply.close(os);
                        throw throwable;
                    }
                    Apply.close(wrtr);
                    Apply.close(os);
                }
                if (this.fa instanceof FolderFileAccess) {
                    FolderFileAccess ffa = (FolderFileAccess)this.fa;
                    for (PatchControl pc : testFixes) {
                        if (pc.getTouches().isEmpty()) continue;
                        new TouchFiles(ffa.getBase(), pc.getTouches(), null).touch();
                    }
                }
            }
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    private boolean isVerifyNeeded(FileAccess vfa) throws Fixes.FileIsDirectory {
        boolean verifyNeeded;
        block10: {
            verifyNeeded = true;
            InputStream verifiedIS = null;
            try {
                verifiedIS = vfa.getIS("fix.verified");
                BufferedReader rdr = null;
                try {
                    rdr = new BufferedReader(new InputStreamReader(verifiedIS, Charset.forName("UTF-8")));
                    if (Boolean.valueOf(rdr.readLine()).booleanValue()) {
                        verifyNeeded = false;
                    }
                }
                catch (Throwable throwable) {
                    Apply.close(rdr);
                    throw throwable;
                }
                Apply.close(rdr);
            }
            catch (Fixes.FileIsDirectory e) {
                throw e;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Apply.close(verifiedIS);
                break block10;
            }
            catch (IOException e) {
                try {
                    this.getLog().warn((Object)"Error reading verified file.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Apply.close(verifiedIS);
                    throw throwable;
                }
                Apply.close(verifiedIS);
                break block10;
            }
            Apply.close(verifiedIS);
        }
        return verifyNeeded;
    }

    private boolean isEmptyString(String teststring) {
        return teststring == null || teststring.length() == 0;
    }

    private boolean objectsEqual(Object before, Object after) {
        if (before != null) {
            return before.equals(after);
        }
        return after == null;
    }

    private void computeChecksum(Adler32 checksum, InputStream in) throws IOException {
        try {
            int read;
            byte[] buffer = new byte[100000];
            int start = 0;
            long copied = 0L;
            while ((read = in.read(buffer, start, buffer.length - start)) > -1) {
                if ((start += read) < buffer.length) continue;
                checksum.update(buffer, 0, buffer.length);
                start = 0;
                copied += (long)buffer.length;
            }
            if (start > 0) {
                checksum.update(buffer, 0, start);
                copied += (long)start;
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Exception decompiling
     */
    private Collection<M> verifyFix(PatchControl pc, Collection<M> errors, Map<String, String> includedTestFixes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract M createMessage(String var1, Object ... var2);

    private Collection<M> add(M error, Collection<M> errors) {
        if (errors == null) {
            errors = new ArrayList<M>();
        }
        errors.add(error);
        return errors;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType() {
        if ($SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType != null) {
            return $SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType;
        }
        int[] nArray = new int[FileAccess.FileType.values().length];
        try {
            nArray[FileAccess.FileType.directory.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileAccess.FileType.file.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileAccess.FileType.notExist.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType = nArray;
        return nArray;
    }
}

