/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class MakeElementCommand
extends OutputCleartoolCommand {
    public static final int MODE_CREATE = 2;
    public static final int MODE_EXISTING_RESOURCE = 4;
    private int mode = -1;
    private File[] viewFiles = null;
    private String comment = null;
    private boolean isFolder = false;

    public MakeElementCommand(int mode, File[] viewFiles, boolean isFolder, String comment) {
        this.mode = mode;
        this.viewFiles = viewFiles;
        this.comment = comment;
        this.isFolder = isFolder;
    }

    @Override
    protected String[] getArguments() {
        String[] prefix = null;
        if (this.mode == 2) {
            prefix = this.isFolder ? new String[]{"mkelem", "-eltype", "directory", "-nco", "-c", this.comment} : new String[]{"mkelem", "-nco", "-c", this.comment};
        } else if (this.mode == 4) {
            prefix = new String[]{"mkelem", "-mkpath", "-ci", "-c", this.comment};
        }
        String[] args = new String[prefix.length + this.viewFiles.length];
        System.arraycopy(prefix, 0, args, 0, prefix.length);
        int fc = 0;
        while (fc < this.viewFiles.length) {
            args[fc + prefix.length] = this.viewFiles[fc].getAbsolutePath();
            ++fc;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, final String error) {
        return new MakeElementCommandOutput(){

            @Override
            public boolean areElementsMade() {
                return error == null || error.length() <= 0;
            }
        };
    }

    public static interface MakeElementCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean areElementsMade();
    }
}

