/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.BaseLine;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class ListBaseLinesCommand
extends OutputCleartoolCommand {
    public static final int STREAM = 0;
    public static final int COMPONENT = 1;
    public static final int BASELINESELECTOR = 2;
    public static final int UUID = 3;
    private static String KEY_OWNER = CleartoolCommandConstants.LSBL_OWNER;
    private static String KEY_GROUP = CleartoolCommandConstants.LSBL_GROUP;
    private static String KEY_COMPONENT = CleartoolCommandConstants.LSBL_COMPONENT;
    private static String KEY_STREAM = CleartoolCommandConstants.LSBL_STREAM;
    private static String KEY_LABEL_STATUS = CleartoolCommandConstants.LSBL_LABEL_STATUS;
    private static String KEY_CHANGE_SETS = CleartoolCommandConstants.LSBL_CHANGE_SETS;
    private static String KEY_PROMOTION_LEVEL = CleartoolCommandConstants.LSBL_PROMOTION_LEVEL;
    private static String KEY_DEPENDS_ON = CleartoolCommandConstants.LSBL_DEPENDS_ON;
    private static final String stream = "-stream";
    private static final String component = "-component";
    private String commandType = null;
    private int type = -1;
    private String typeArg = null;

    public ListBaseLinesCommand(String typeArg, int type) {
        if (type == 0) {
            this.commandType = stream;
        } else if (type == 1) {
            this.commandType = component;
        }
        this.type = type;
        this.typeArg = typeArg;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        final ArrayList<BaseLine> baselines = new ArrayList<BaseLine>();
        if (output != null && output.length() > 0) {
            String[] baselineStrings = output.split("\r\n");
            int pc = 0;
            while (pc < baselineStrings.length) {
                if (baselineStrings[pc].trim().length() > 0 && baselineStrings[pc].startsWith(CleartoolCommandConstants.BASELINE)) {
                    String firstLine = baselineStrings[pc].substring(CleartoolCommandConstants.BASELINE.length()).trim();
                    String baselineName = firstLine = this.stripQuotes(firstLine);
                    String baselineDescription = null;
                    String baselineComponent = null;
                    String baselineStream = null;
                    String owner = null;
                    String group = null;
                    String labelStatus = null;
                    String[] changeSets = null;
                    String promotionLevel = null;
                    String[] dependsOn = null;
                    long creationTime = -1L;
                    boolean isComposite = false;
                    String line = null;
                    ++pc;
                    while (pc < baselineStrings.length && !baselineStrings[pc].startsWith(CleartoolCommandConstants.BASELINE)) {
                        line = baselineStrings[pc].trim();
                        if (line.startsWith("\"")) {
                            baselineDescription = this.stripQuotes(line);
                        } else if (baselineName != null && owner == null && !line.startsWith("\"") && creationTime == -1L) {
                            String trimmedLine = line.trim();
                            StringTokenizer tokenizer = new StringTokenizer(trimmedLine);
                            String timestamp = tokenizer.nextToken();
                            if (timestamp.equals("created")) {
                                timestamp = tokenizer.nextToken();
                            }
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            try {
                                Date parsedDate = dateFormat.parse(timestamp);
                                creationTime = parsedDate.getTime();
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        } else if (line.startsWith(KEY_OWNER)) {
                            owner = line.substring(KEY_OWNER.length()).trim();
                        } else if (line.startsWith(KEY_GROUP)) {
                            group = line.substring(KEY_GROUP.length()).trim();
                        } else if (line.startsWith(KEY_STREAM)) {
                            baselineStream = line.substring(KEY_STREAM.length()).trim();
                        } else if (line.startsWith(KEY_COMPONENT)) {
                            baselineComponent = line.substring(KEY_COMPONENT.length()).trim();
                        } else if (line.startsWith(KEY_LABEL_STATUS)) {
                            labelStatus = line.substring(KEY_LABEL_STATUS.length()).trim();
                        } else if (line.startsWith(KEY_CHANGE_SETS)) {
                            changeSets = this.processValues(++pc, KEY_PROMOTION_LEVEL, baselineStrings);
                        } else if (line.startsWith(KEY_PROMOTION_LEVEL)) {
                            promotionLevel = line.substring(KEY_PROMOTION_LEVEL.length()).trim();
                        } else if (line.startsWith(KEY_DEPENDS_ON) && (dependsOn = this.processValues(++pc, KEY_PROMOTION_LEVEL, baselineStrings)) != null && dependsOn.length > 0) {
                            isComposite = true;
                        }
                        ++pc;
                    }
                    --pc;
                    BaseLine baseline = new BaseLine();
                    baseline.setBaselineName(baselineName);
                    baseline.setBaselineDescription(baselineDescription);
                    baseline.setOwner(owner);
                    baseline.setGroup(group);
                    baseline.setComponent(baselineComponent);
                    baseline.setStream(baselineStream);
                    baseline.setLabelStatus(labelStatus);
                    baseline.setChangeSets(changeSets);
                    baseline.setPromotionLevel(promotionLevel);
                    baseline.setDependsOn(dependsOn);
                    baseline.setCreationTime(creationTime);
                    baseline.setComposite(isComposite);
                    baselines.add(baseline);
                }
                ++pc;
            }
        }
        return new ListBaseLineOutput(){

            @Override
            public BaseLine[] getBaseLines() {
                return baselines.toArray(new BaseLine[baselines.size()]);
            }
        };
    }

    private String stripQuotes(String str) {
        String stripped = str.replace('\"', ' ');
        return stripped.trim();
    }

    @Override
    protected String[] getArguments() {
        if (this.type == 0 || this.type == 1) {
            return new String[]{"lsbl", "-long", this.commandType, this.typeArg};
        }
        if (this.type == 2) {
            return new String[]{"lsbl", "-long", this.typeArg};
        }
        if (this.type == 3) {
            return new String[]{"describe", this.typeArg};
        }
        return null;
    }

    private String[] processValues(int startIndex, String tokenToLookFor, String[] strings) {
        ArrayList<String> list = new ArrayList<String>();
        int i = startIndex;
        while (i < strings.length) {
            String line = strings[i].trim();
            if (line.startsWith(tokenToLookFor)) break;
            list.add(line);
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static interface ListBaseLineOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public BaseLine[] getBaseLines();
    }
}

