/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.io.zip;

import com.ibm.ram.io.zip.ZipConstants;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipInflater;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed = false;
    private boolean entryEOF = false;
    private byte[] b = new byte[256];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipInputStream(InputStream in) {
        super(new PushbackInputStream(in, 512), new ZipInflater(true), 512);
        if (in == null) {
            throw new NullPointerException("in is null");
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.inf.reset();
        this.entry = this.readLOC();
        if (this.entry == null) {
            return null;
        }
        if (this.entry.getMethod() == 0) {
            this.remaining = this.entry.getSize();
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.getMethod()) {
            case 8: {
                len = super.read(b, off, len);
                if (len == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(b, off, len);
                }
                return len;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)len > this.remaining) {
                    len = (int)this.remaining;
                }
                if ((len = this.in.read(b, off, len)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(b, off, len);
                this.remaining -= (long)len;
                return len;
            }
        }
        throw new InternalError("invalid compression method");
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        int total = 0;
        while (total < max) {
            int len = max - total;
            if (len > this.tmpbuf.length) {
                len = this.tmpbuf.length;
            }
            if ((len = this.read(this.tmpbuf, 0, len)) == -1) {
                this.entryEOF = true;
                break;
            }
            total += len;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.inf.end();
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        int len;
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            try {
                ((PushbackInputStream)this.in).unread(this.tmpbuf, 0, 30);
                this.readFully(this.tmpbuf, 0, 8);
                this.readFully(this.tmpbuf, 0, 30);
            }
            catch (EOFException eOFException) {
                return null;
            }
            if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
                return null;
            }
        }
        if ((len = ZipInputStream.get16(this.tmpbuf, 26)) == 0) {
            throw new ZipException("missing entry name");
        }
        int blen = this.b.length;
        if (len > blen) {
            while (len > (blen *= 2)) {
            }
            this.b = new byte[blen];
        }
        this.readFully(this.b, 0, len);
        ZipEntry e = this.createZipEntry(ZipInputStream.getUTF8String(this.b, 0, len));
        int versionMadeBy = ZipInputStream.get16(this.tmpbuf, 4);
        e.setPlatform((short)(versionMadeBy >> 8));
        e.setGeneral(ZipInputStream.get16(this.tmpbuf, 6));
        if ((e.getGeneral() & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        e.setMethod(ZipInputStream.get16(this.tmpbuf, 8));
        e.setDosTime(ZipInputStream.get32(this.tmpbuf, 10));
        if ((e.getGeneral() & 8) == 8) {
            if (e.getMethod() != 8) {
                throw new ZipException("only DEFLATED entries can have EXT descriptor");
            }
        } else {
            e.setCrc(ZipInputStream.get32(this.tmpbuf, 14));
            e.setCompressedSize(ZipInputStream.get32(this.tmpbuf, 18));
            e.setSize(ZipInputStream.get32(this.tmpbuf, 22));
        }
        if ((len = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] bb = new byte[len];
            this.readFully(bb, 0, len);
            e.setExtra(bb);
        }
        return e;
    }

    private static String getUTF8String(byte[] b, int off, int len) {
        int count = 0;
        int max = off + len;
        int i = off;
        while (i < max) {
            int c = b[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    break;
                }
                case 12: 
                case 13: {
                    if ((b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    break;
                }
                case 14: {
                    if ((b[i++] & 0xC0) != 128 || (b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (i != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i = 0;
        while (off < max) {
            int c = b[off++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    cs[i++] = (char)((c & 0x1F) << 6 | b[off++] & 0x3F);
                    break;
                }
                case 14: {
                    int t = (b[off++] & 0x3F) << 6;
                    cs[i++] = (char)((c & 0xF) << 12 | t | b[off++] & 0x3F);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return new String(cs, 0, count);
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    private void readEnd(ZipEntry e) throws IOException {
        int n = this.inf.getRemaining();
        if (n > 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
        }
        if ((e.getGeneral() & 8) == 8) {
            this.readFully(this.tmpbuf, 0, 16);
            long sig = ZipInputStream.get32(this.tmpbuf, 0);
            if (sig != 134695760L) {
                ((PushbackInputStream)this.in).unread(this.tmpbuf, 11, 4);
            }
        }
        e.setCrc(this.crc.getValue());
        e.setCompressedSize(((ZipInflater)this.inf).getTotalIn64());
        e.setSize(((ZipInflater)this.inf).getTotalOut64());
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.in.read(b, off, len);
            if (n == -1) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    private static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) {
        return (long)ZipInputStream.get16(b, off) | (long)ZipInputStream.get16(b, off + 2) << 16;
    }
}

