/******************************************************************************* 
* Licensed Materials - Property of IBM and/or HCL 
* (c) Copyright IBM Corporation 2000, 2013. All Rights Reserved. 
* (c) Copyright HCL Technologies Ltd. 2017. All Rights Reserved. 
* 
* Note to U.S. Government Users Restricted Rights: 
* Use, duplication or disclosure restricted by GSA ADP Schedule 
* Contract with IBM Corp. 
*******************************************************************************/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.util.regex.Matcher
import java.util.regex.Pattern

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(args[0], args[1])
final def props = apTool.getStepProperties()

def rftProjectDir = props['projectDir'];
println "RFT"+"ProjectDir : " + rftProjectDir;
def rftScriptName = props['scriptName'];
println "RFT"+"ScriptName : " + rftScriptName;
def logFormat = props['logFormat'];
println "logFormat : " + logFormat;
def iterationCount = props['iterationCount'];
println "iterationCount : " + iterationCount;
def userArgs = props['userArgs'];
println "userArgs : " + userArgs;

def RFT_ECLIPSE_DIR = System.getenv("IBM_RATIONAL_RFT_ECLIPSE_DIR");

def rftEclipseDir = new File(RFT_ECLIPSE_DIR);
if (!rftEclipseDir.exists()) {
	throw new RuntimeException("Cannot get IBM_RATIONAL_RFT_ECLIPSE_DIR");
}

def RFT_INSTALL_DIR = System.getenv("IBM_RATIONAL_RFT_INSTALL_DIR");

def rftInstallDir = new File(RFT_INSTALL_DIR);
if (!rftInstallDir.exists()) {
	throw new RuntimeException("Cannot get IBM_RATIONAL_RFT_INSTALL_DIR");
}

def execFileName = apTool.isWindows ? "java.exe" : "java"
def relativeJavaPath = RFT_ECLIPSE_DIR + File.separator + "jdk" + 
										File.separator + "jre" +
										File.separator + "bin" +
										File.separator + execFileName;

def javaExecutable = new File(relativeJavaPath);
if (!javaExecutable.exists()) {
	throw new RuntimeException("Cannot get java executable!");
}

def rationalFtExecutable = new File(RFT_INSTALL_DIR, File.separator + "rational_ft.jar");
if (!rationalFtExecutable.exists()) {
	throw new RuntimeException("Cannot get rational_ft.jar!");
}

def ch = new CommandHelper(new File('.'))

try {
	// Execute
	ch.println("Java exec at " + javaExecutable);
	ch.println("RFT exec at " + rationalFtExecutable);
	ch.println("RFT project dir at " + rftProjectDir);
	ch.println("RFT script at " + rftScriptName);

	// Build args
	def args = [];
	args = [javaExecutable.toString(), '-jar', rationalFtExecutable.toString(), 
		'-datastore', rftProjectDir, '-rt.log_format', logFormat, "-rt.bring_up_logviewer", 
		"false"];

	if(iterationCount != null && !iterationCount.toString().isEmpty()) 
	{
		arg = '-iterationCount';
		args << arg;
		args << iterationCount;
	}
	
	arg = '-playback';
	args << arg;
	args << rftScriptName;
	
	
	if(userArgs != null && !userArgs.toString().isEmpty())
	{
		arg = '-args';
		args << arg;
		def userArgString = userArgs;
		args << userArgString;
	}
		
	ch.runCommand("Running test..", args);

	def outputProps = new Properties();
	
	def playbackLogDir = rftProjectDir + "_logs";
	println "Playback log dir is "  + playbackLogDir;
	outputProps.setProperty("PlaybackLogDir", playbackLogDir);
	
	println "Test result information file path is " + getResultFilePath();
	
	//Retrieving test result information from the CommandLineLog.txt
	def fResultFile = new File(getResultFilePath());
	def status = null;
	def publishedResult = null;
	if(fResultFile.exists())
	{
		def verdictPattern = Pattern.compile("--VERDICT=(.*)");
		def publishedResultPattern = Pattern.compile("--REMOTE_RESULT_UI=(.*)");
		def verdictMatcher = null;
		def publishedResultMatcher = null;
		def isVerdictSet = false;
		def isPublishedResultSet = false;
		def exportlogreader = new BufferedReader(new FileReader(fResultFile));
		try
		{
			def sb = new StringBuilder();
			def line;
	
			while((!isVerdictSet || !isPublishedResultSet) && (line=exportlogreader.readLine())!=null)
			{
				verdictMatcher = verdictPattern.matcher(line);
				publishedResultMatcher = publishedResultPattern.matcher(line);
				if(verdictMatcher.find()) {
					def testResult = verdictMatcher.group(1);
					println("Test Result = " + testResult);
					outputProps.setProperty("TestResult", testResult);
					if(testResult.equals("FAIL") || testResult.equals("ERROR")) {
						outputProps.setProperty("Status", "Failure");
					}
					else {
						outputProps.setProperty("Status","Success");
					}
					isVerdictSet = true;
				}
				else if(publishedResultMatcher.find()) {
					publishedResult = publishedResultMatcher.group(1);
					println("Published Result : " + publishedResult);
					isPublishedResultSet = true;
				}
			}
			if(!isVerdictSet) {
				status = "Fail"
				println("Test Result is "+status);
				outputProps.setProperty("TestResult", status);
				outputProps.setProperty("Status", "Failure");
			}
		}
		finally 
		{
			exportlogreader.close();
		}
	}
	else
	{
		println("Result file does not exist");
		status = "Fail";
		outputProps.setProperty("TestResult", status);
		outputProps.setProperty("Status", "Failure");
	}
	
	def outputPropsFile = new File(this.args[1]);
	def outputPropsStream = null;
	try {
		outputPropsStream = new FileOutputStream(outputPropsFile);
		outputProps.store(outputPropsStream, null);
	}
	finally {
		outputPropsStream?.close();
	}
}
catch (Exception e) {
    System.out.println("Error running test!");
    e.printStackTrace();
    System.exit(1);
}

def getResultFilePath() {
	def tempfileloc = System.getProperty("java.io.tmpdir");
	if (!tempfileloc.endsWith(File.separator))
		tempfileloc += File.separator;
	tempfileloc += "CommandLineLog.txt";
	return tempfileloc;
}