/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentUnLocker;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UnLockEnvironment
extends Task {
    private boolean haltOnFailure = false;
    private String failureProperty = null;
    private String serverURL;
    private String domain;
    private String environment;
    private String username;

    public void execute() throws BuildException {
        this.validateInputs();
        int exitCode = this.unlockEnvironment();
        if (this.haltOnFailure && exitCode != 0) {
            throw new BuildException("UnlockEnvironment exited with code " + exitCode);
        }
        if (this.failureProperty != null && exitCode != 0) {
            this.getProject().setNewProperty(this.failureProperty, "true");
        }
        this.log("UnlockEnvironment exited with code " + exitCode, 2);
    }

    private void validateInputs() throws BuildException {
        if (this.domain == null) {
            throw new BuildException("Domain must be specified");
        }
        if (this.environment == null) {
            throw new BuildException("Environment must be specified");
        }
        if (this.serverURL == null) {
            throw new BuildException("Server URL must be specified");
        }
        if (this.username == null) {
            throw new BuildException("Username must be specified");
        }
    }

    private int unlockEnvironment() throws BuildException {
        try {
            EnvironmentUnLocker locker = new EnvironmentUnLocker(this.serverURL, this.domain, this.environment, this.username);
            return locker.unlock().code;
        }
        catch (Exception e) {
            throw new BuildException("An error occurred while running UnlockEnvironment", (Throwable)e);
        }
    }

    public void setHaltOnFailure(boolean haltOnError) {
        this.haltOnFailure = haltOnError;
    }

    public void setFailureProperty(String value) {
        this.failureProperty = value;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

