/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.lang;

public final class ReferenceCountedResource<T> {
    private T resource;
    private final ResourceManager<T> handler;
    private int refCount = 0;
    private boolean closed = false;

    private ReferenceCountedResource(ResourceManager<T> handler) {
        this.handler = handler;
    }

    public static <T> ReferenceCountedResource<T> createFor(ResourceManager<T> handler) {
        return new ReferenceCountedResource<T>(handler);
    }

    public final synchronized T open() {
        if (this.closed) {
            throw new IllegalStateException("Refrence counted resource has been closed.");
        }
        if (this.refCount++ == 0) {
            this.resource = this.handler.create();
        }
        return this.resource;
    }

    public final synchronized void close() {
        if (this.refCount == 0) {
            throw new IllegalStateException("Reference count is already at zero.");
        }
        if (--this.refCount == 0) {
            this.closed = true;
            this.handler.destroy(this.resource);
        }
    }

    public static interface ResourceManager<T> {
        public T create();

        public void destroy(T var1);
    }
}

