/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie;

import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtils {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static String toXML(Document doc) throws TransformerException {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        trans.transform(source, result);
        String xmlString = sw.toString();
        return xmlString;
    }

    public static String toXML(Element element) throws TransformerException, ParserConfigurationException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        doc.appendChild(element);
        return DomUtils.toXML(doc);
    }

    public static class ElementIterable
    implements Iterable<Element> {
        private final NodeList nodeList;

        public ElementIterable(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        public ElementIterable(Node parent) {
            this.nodeList = parent.getChildNodes();
        }

        @Override
        public Iterator<Element> iterator() {
            return new ElementIterator(this.nodeList);
        }
    }

    private static class ElementIterator
    implements Iterator<Element> {
        private final NodeList nodeList;
        private int index = -1;
        private Element next;

        public ElementIterator(NodeList nodeList) {
            this.nodeList = nodeList;
            this.preLoadNext();
        }

        private void preLoadNext() {
            this.next = null;
            while (this.index < this.nodeList.getLength() - 1 && this.next == null) {
                ++this.index;
                Node node = this.nodeList.item(this.index);
                if (!(node instanceof Element)) continue;
                this.next = (Element)node;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element result = this.next;
            this.preLoadNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

