/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.HKey;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.RefString;
import com.urbancode.winapi.RegValue;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;
import com.urbancode.winapi.WindowsRuntimeException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegUtil {
    public static byte[] encodeREG_SZ(String value) {
        byte[] result = null;
        if (value != null) {
            int length = 2 * (value.length() + 1);
            ByteBuffer buffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
            CharBuffer charBuffer = buffer.asCharBuffer();
            charBuffer.put(value).put('\u0000');
            result = buffer.array();
        }
        return result;
    }

    public static byte[] encodeREG_MULTI_SZ(String ... value) {
        byte[] result = null;
        if (value != null) {
            int length = 1;
            for (String s : value) {
                length += s.length() + 1;
            }
            if (value.length == 0) {
                ++length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(length *= 2).order(ByteOrder.LITTLE_ENDIAN);
            CharBuffer charBuffer = buffer.asCharBuffer();
            for (String s : value) {
                charBuffer.put(s).put('\u0000');
            }
            if (value.length == 0) {
                charBuffer.put('\u0000');
            }
            charBuffer.put('\u0000');
            result = buffer.array();
        }
        return result;
    }

    public static byte[] encodeREG_DWORD(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(value).array();
    }

    public static byte[] encodeREG_QWORD(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
    }

    public static String decodeREG_SZ(byte[] data) {
        return RegUtil.decodeREG_SZ(data, 0, data.length);
    }

    public static String decodeREG_SZ(byte[] data, int offset, int length) {
        int end;
        RegUtil.checkArray(data, offset, length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        CharBuffer charBuffer = ByteBuffer.wrap(data, offset, length).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
        for (end = 0; end < charBuffer.length() && charBuffer.charAt(end) != '\u0000'; ++end) {
        }
        return ((Object)charBuffer.subSequence(0, end)).toString();
    }

    public static String[] decodeREG_MULTI_SZ(byte[] data) {
        return RegUtil.decodeREG_MULTI_SZ(data, 0, data.length);
    }

    public static String[] decodeREG_MULTI_SZ(byte[] data, int offset, int length) {
        int end;
        RegUtil.checkArray(data, offset, length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> result = new ArrayList<String>();
        CharBuffer charBuffer = ByteBuffer.wrap(data, offset, length).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
        int start = 0;
        while ((end = RegUtil.findEndOfString(charBuffer, start)) - start != 0) {
            result.add(((Object)charBuffer.subSequence(start, end)).toString());
            start = end + 1;
            if (end < charBuffer.length()) continue;
        }
        return result.toArray(new String[result.size()]);
    }

    public static int decodeREG_DWORD(byte[] data) {
        return RegUtil.decodeREG_DWORD(data, 0, data.length);
    }

    public static int decodeREG_DWORD(byte[] data, int offset, int length) {
        RegUtil.checkArray(data, offset, length);
        if (length != 4) {
            throw new IllegalArgumentException();
        }
        return ByteBuffer.wrap(data, offset, length).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long decodeREG_QWORD(byte[] data) {
        return RegUtil.decodeREG_QWORD(data, 0, data.length);
    }

    public static long decodeREG_QWORD(byte[] data, int offset, int length) {
        RegUtil.checkArray(data, offset, length);
        if (length != 8) {
            throw new IllegalArgumentException();
        }
        return ByteBuffer.wrap(data, offset, length).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static Iterable<RegValue> values(final HKey key) throws WindowsException {
        final RegValue initialValue = RegUtil.value(key, 0);
        return new Iterable<RegValue>(){

            @Override
            public Iterator<RegValue> iterator() {
                return new Iterator<RegValue>(){
                    private int index;
                    private RegValue value;
                    {
                        this.value = initialValue;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public RegValue next() {
                        if (this.value == null) {
                            throw new NoSuchElementException();
                        }
                        RegValue result = this.value;
                        ++this.index;
                        this.value = this.current();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private RegValue current() {
                        try {
                            return RegUtil.value(key, this.index);
                        }
                        catch (WindowsException e) {
                            throw new WindowsRuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    public static Iterable<String> keys(final HKey key) throws WindowsException {
        final String initialValue = RegUtil.key(key, 0);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int index;
                    private String value;
                    {
                        this.value = initialValue;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.value != null;
                    }

                    @Override
                    public String next() {
                        if (this.value == null) {
                            throw new NoSuchElementException();
                        }
                        String result = this.value;
                        ++this.index;
                        this.value = this.current();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private String current() {
                        try {
                            return RegUtil.key(key, this.index);
                        }
                        catch (WindowsException e) {
                            throw new WindowsRuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    private static RegValue value(HKey key, int index) throws WindowsException {
        RefString name = new RefString();
        RefInt type = new RefInt();
        byte[] data = WinApi.RegEnumValue(key, index, name, type);
        if (data != null) {
            return new RegValue(name.value, type.value, data);
        }
        return null;
    }

    private static String key(HKey key, int index) throws WindowsException {
        return WinApi.RegEnumKeyEx(key, index, null);
    }

    private static void checkArray(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length > data.length - offset) {
            throw new IllegalArgumentException();
        }
    }

    private static int findEndOfString(CharBuffer buffer, int offset) {
        int end;
        for (end = offset; end < buffer.length() && buffer.charAt(end) != '\u0000'; ++end) {
        }
        return end;
    }

    private RegUtil() {
    }
}

