/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.HttpClient;
import com.ghc.ghTester.ant.vie.VieHttpClient;
import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentDefinitionFactory;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLockDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentLockDefinitionFactory;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentReferenceDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentReferenceFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class EnvironmentService {
    private static final Logger log = Logger.getLogger(EnvironmentService.class.getName());
    private final HttpClient client;
    private final URI baseURI;
    private final String domain;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public EnvironmentService(String serverUrl, String domain) throws URISyntaxException {
        this(EnvironmentService.calculateBaseUri(serverUrl), domain);
    }

    private static URI calculateBaseUri(String serverUrl) throws URISyntaxException {
        String url = serverUrl;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        URI root = new URI(url);
        return root.resolve("rest/environments/");
    }

    EnvironmentService(URI baseUri, String domain) {
        this.baseURI = baseUri;
        this.domain = domain;
        this.client = new VieHttpClient();
    }

    public EnvironmentDefinition createEnvironment(EnvironmentDefinition environmentDefinition) throws ParserConfigurationException, TransformerException, IOException, VieHttpException, SAXException {
        String description;
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element env = doc.createElement("environment");
        String baseEnvironmentName = environmentDefinition.getBaseEnvironmentName();
        if (baseEnvironmentName != null) {
            Element baseEnvElement = doc.createElement("base-environment");
            baseEnvElement.setAttribute("name", baseEnvironmentName);
            env.appendChild(baseEnvElement);
        }
        if ((description = environmentDefinition.getDescription()) != null) {
            env.setAttribute("description", description);
        }
        doc.appendChild(env);
        String xml = DomUtils.toXML(doc);
        String url = this.baseURI.toString();
        if (url.charAt(url.length() - 1) != '/') {
            url = String.valueOf(url) + '/';
        }
        url = String.valueOf(url) + URIUtil.encodeWithinPath((String)this.domain, (String)"UTF-8") + '/';
        String responseXml = this.client.post(url, xml, null);
        return EnvironmentDefinitionFactory.INSTANCE.createFromXml(this.baseURI, null, responseXml);
    }

    public EnvironmentReferenceDefinition locateEnvironmentReference(String environmentName) throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        String queryOptions = this.createQueryString(environmentName);
        String queryURL = this.baseURI.resolve(queryOptions).toString();
        String xml = this.client.get(queryURL);
        List<EnvironmentReferenceDefinition> list = EnvironmentReferenceFactory.INSTANCE.createListFromXml(this.baseURI.toString(), xml);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public EnvironmentDefinition locateEnvironment(String environmentName) throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        EnvironmentReferenceDefinition ref = this.locateEnvironmentReference(environmentName);
        if (ref != null) {
            String envXml = this.client.get(ref.getHref());
            EnvironmentDefinition definition = EnvironmentDefinitionFactory.INSTANCE.createFromXml(ref.getHref(), ref.getHref(), envXml);
            return definition;
        }
        return null;
    }

    public EnvironmentDefinition updateEnvironment(EnvironmentDefinition environment, String username) throws TransformerException, IOException, VieHttpException, ParserConfigurationException, SAXException {
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element env = doc.createElement("environment");
        env.setAttribute("name", environment.getName());
        String description = environment.getDescription();
        if (description != null) {
            env.setAttribute("description", description);
        }
        String baseEnvironmentName = environment.getBaseEnvironmentName();
        String baseEnvHref = environment.getBaseEnvironmentReferenceHref();
        if (baseEnvironmentName != null || baseEnvHref != null) {
            Element baseEnvElement = doc.createElement("base-environment");
            if (baseEnvironmentName != null) {
                baseEnvElement.setAttribute("name", baseEnvironmentName);
            }
            if (baseEnvHref != null) {
                baseEnvElement.setAttribute("href", baseEnvHref);
            }
            env.appendChild(baseEnvElement);
        }
        if (environment.getTags() != null && environment.getTags().size() > 0) {
            Element tagsElement = doc.createElement("tags");
            for (Map.Entry<String, String> tag : environment.getTags().entrySet()) {
                Element tagElement = doc.createElement("tag");
                tagElement.setAttribute("name", tag.getKey());
                tagElement.setAttribute("value", tag.getValue());
                tagsElement.appendChild(tagElement);
            }
            env.appendChild(tagsElement);
        }
        Element lock = doc.createElement("lock");
        lock.setAttribute("locked", Boolean.toString(environment.isLocked()));
        lock.setAttribute("href", environment.getLockReferenceHref());
        doc.appendChild(env);
        String xml = DomUtils.toXML(doc);
        this.client.setCredentials(username);
        String url = environment.getHref();
        String responseXml = this.client.put(url, xml, null);
        return EnvironmentDefinitionFactory.INSTANCE.createFromXml(this.baseURI, url, responseXml);
    }

    public void deleteEnvironment(EnvironmentReferenceDefinition environment, String username) throws IOException, VieHttpException {
        this.client.setCredentials(username);
        this.client.delete(environment.getHref(), null);
    }

    public EnvironmentLockDefinition getLockDetails(EnvironmentDefinition environmentDef) throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        String queryURL = environmentDef.getLockReferenceHref();
        String xml = this.client.get(queryURL);
        EnvironmentLockDefinition lock = EnvironmentLockDefinitionFactory.INSTANCE.createFromXml(this.baseURI.toString(), xml, queryURL);
        return lock;
    }

    public void createLock(EnvironmentLockDefinition lockDefinition) throws ParserConfigurationException, IOException, VieHttpException, TransformerException {
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element lock = doc.createElement("lock");
        if (lockDefinition.getDuration() != null) {
            Element time = doc.createElement("time");
            time.setAttribute("expected-duration", lockDefinition.getDuration());
            lock.appendChild(time);
        }
        Element reason = doc.createElement("reason");
        Text reasonNode = doc.createTextNode(lockDefinition.getReason());
        reason.appendChild(reasonNode);
        lock.appendChild(reason);
        doc.appendChild(lock);
        this.client.setCredentials(lockDefinition.getUser());
        String xml = DomUtils.toXML(doc);
        this.client.post(lockDefinition.getHRef(), xml, null);
    }

    public void removeLock(EnvironmentLockDefinition lockDefinition) throws IOException, VieHttpException {
        this.client.setCredentials(lockDefinition.getUser());
        this.client.delete(lockDefinition.getHRef(), null);
    }

    private String createQueryString(String environment) {
        StringBuilder builder = new StringBuilder();
        builder.append("?domain=");
        builder.append(EnvironmentService.processQueryStringValue(this.domain));
        builder.append("&env=");
        builder.append(EnvironmentService.processQueryStringValue(environment));
        return builder.toString();
    }

    private static String processQueryStringValue(String value) {
        try {
            return URIUtil.encodeWithinQuery((String)value, (String)"UTF-8");
        }
        catch (URIException e) {
            log.log(Level.SEVERE, "Could not encode query string value", e);
            return value;
        }
    }
}

