/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def cmdHelper = new CommandHelper(new File('.'));

final def packageNames = props['packageNames']?.split('\n');
final def uninstallOptions = (props['removeOptions']!=null && props['removeOptions'].trim() != "")?props['removeOptions'].split('\n'):null;

println "Using values : "
println "Package : " + packageNames

def cmdArgs = ['rpm', '-e'];

uninstallOptions.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}

packageNames.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}
cmdHelper.runCommand("Uninstalling Package", cmdArgs);
