/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def cmdHelper = new CommandHelper(new File('.'));

final def packageFile = props['packageFile'];
final def installOptions = (props['installOptions']!=null && props['installOptions'].trim() != "")?props['installOptions'].split('\n'):null;
def packageFiles = packageFile.split('\n');

println "Using values : "
println "Package : " + packageFile

def cmdArgs = ['rpm', '-i'];

installOptions.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}

packageFiles.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}

cmdHelper.runCommand("Installing Package", cmdArgs);
