/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final AirPluginTool airPluginTool = new AirPluginTool(this.args[0], this.args[1])
final Properties props = airPluginTool.getStepProperties()

final def cmdHelper = new CommandHelper(new File('.'));

final def packageFile = props['packageFile'];
final def installOptions = (props['installOptions']!=null && props['installOptions'].trim() != "")?props['installOptions'].split('\n'):null;
def packageFiles = packageFile.split('\n');

println "Using values : "
println "Package : " + packageFile

def cmdArgs = ['rpm', '-i'];

installOptions.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}

packageFiles.each {
    if (it != null && it.trim() != "") {
        cmdArgs << it;
    }
}

cmdHelper.runCommand("Installing Package", cmdArgs);
