/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.scenarios;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.HttpClient;
import com.ghc.ghTester.ant.vie.VieHttpClient;
import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetails;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioDetailsFactory;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioReference;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioReferenceFactory;
import com.ghc.ghTester.ant.vie.scenarios.ScenarioService;
import com.ghc.ghTester.ant.vie.scenarios.StopStubsOption;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RtcpScenarioService
implements ScenarioService {
    private static final Logger log = Logger.getLogger(RtcpScenarioService.class.getName());
    private final HttpClient client;
    private final URI baseURI;
    private final String domain;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public RtcpScenarioService(String serverUrl, String domain) throws URISyntaxException {
        this(RtcpScenarioService.createRootUri(serverUrl), domain);
    }

    public RtcpScenarioService(URI serverUrl, String domain) {
        this.client = new VieHttpClient();
        this.baseURI = serverUrl.resolve("rest/scenarios/");
        this.domain = domain;
    }

    public static URI createRootUri(String serverUrl) throws URISyntaxException {
        String url = serverUrl;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        URI root = new URI(url);
        return root;
    }

    public static URI createRootUri(URI rootUri) {
        try {
            return RtcpScenarioService.createRootUri(rootUri.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return rootUri;
        }
    }

    @Override
    public List<ScenarioReference> locateScenarios(String scenarioName, String scenarioId, String owner, String environment) throws IOException, VieHttpException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        String queryOptions = this.createQueryString(scenarioName, scenarioId, owner, environment);
        String queryURL = this.baseURI.resolve(queryOptions).toString();
        String xml = this.client.get(queryURL);
        List<ScenarioReference> list = ScenarioReferenceFactory.INSTANCE.createListFromXml(this.baseURI.toString(), xml);
        return list;
    }

    @Override
    public void startScenario(ScenarioReference scenarioReference, StopStubsOption stopStubsOption, String username) throws URISyntaxException, IOException, VieHttpException, TransformerException, ParserConfigurationException, SAXException {
        DocumentBuilder docBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element startScenario = doc.createElement("start-scenario");
        doc.appendChild(startScenario);
        if (stopStubsOption != null && stopStubsOption != StopStubsOption.NONE) {
            Element settings = doc.createElement("settings");
            startScenario.appendChild(settings);
            Element before = doc.createElement("before");
            settings.appendChild(before);
            Element stopStubs = doc.createElement("stop-stubs");
            stopStubs.setAttribute("option", stopStubsOption.name());
            before.appendChild(stopStubs);
        }
        this.client.setCredentials(username);
        String postURL = scenarioReference.href;
        this.client.post(postURL, DomUtils.toXML(doc), null);
    }

    @Override
    public ScenarioDetails getScenarioDetails(ScenarioReference scenarioReference) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException, VieHttpException {
        String queryURL = scenarioReference.href;
        String xml = this.client.get(queryURL);
        ScenarioDetails details = ScenarioDetailsFactory.INSTANCE.createFromXml(queryURL, xml);
        return details;
    }

    @Override
    public void stopScenario(ScenarioReference scenarioReference, String username) throws IOException, VieHttpException {
        block2: {
            String url = scenarioReference.href;
            try {
                this.client.setCredentials(username);
                this.client.delete(url, null);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 404) break block2;
                throw e;
            }
        }
    }

    private String createQueryString(String scenarioName, String scenarioId, String owner, String environment) {
        StringBuilder builder = new StringBuilder();
        builder.append("?domain=");
        builder.append(RtcpScenarioService.processQueryStringValue(this.domain));
        if (environment != null) {
            builder.append("&env=");
            builder.append(RtcpScenarioService.processQueryStringValue(environment));
        }
        if (scenarioName != null) {
            builder.append("&scenarioName=");
            builder.append(RtcpScenarioService.processQueryStringValue(scenarioName));
        }
        if (scenarioId != null) {
            builder.append("&scenarioId=");
            builder.append(RtcpScenarioService.processQueryStringValue(scenarioId));
        }
        if (owner != null) {
            builder.append("&owner=");
            builder.append(RtcpScenarioService.processQueryStringValue(owner));
        }
        return builder.toString();
    }

    private static String processQueryStringValue(String value) {
        try {
            return URIUtil.encodeWithinQuery((String)value, (String)"UTF-8");
        }
        catch (URIException e) {
            log.log(Level.SEVERE, "Could not encode query string value", e);
            return value;
        }
    }
}

