/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.lang;

import com.ghc.lang.Function;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Functions {
    private static final Function IDENTITY = new Function(){

        @Override
        public Object apply(Object from) {
            return from;
        }
    };
    public static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object from) {
            return from.toString();
        }
    };
    public static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        @Override
        public String apply(String from) {
            return from.toLowerCase();
        }
    };

    public static <A, B, C> Function<A, C> compose(final Function<? super A, B> f1, final Function<? super B, C> f2) {
        return new Function<A, C>(){

            @Override
            public C apply(A from) {
                return f2.apply(f1.apply(from));
            }
        };
    }

    public static <A, B> Collection<B> transform(final Collection<A> objects, final Function<? super A, B> f1) {
        return new AbstractCollection<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(objects){
                    private final Iterator<A> i;
                    {
                        this.i = collection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public B next() {
                        return f1.apply(this.i.next());
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return objects.size();
            }
        };
    }

    public static <T, F> Collection<Collection<T>> transformNested(Collection<? extends Collection<F>> collection, final Function<F, T> function) {
        return Functions.transform(collection, new Function<Collection<F>, Collection<T>>(){

            @Override
            public Collection<T> apply(Collection<F> from) {
                return Functions.transform(from, function);
            }
        });
    }

    public static <A, B> Collection<B> transform(A[] objects, Function<? super A, B> f1) {
        if (objects == null) {
            return Collections.emptySet();
        }
        return Functions.transform(Arrays.asList(objects), f1);
    }

    public static <A, V> Function<A, V> constant(final V value) {
        return new Function<A, V>(){

            @Override
            public V apply(A from) {
                return value;
            }
        };
    }

    public static <A, V> Function<A, V> cached(final Function<A, V> provider) {
        return new Function<A, V>(){
            boolean called = false;
            V value = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V apply(A from) {
                8 var2_2 = this;
                synchronized (var2_2) {
                    if (!this.called) {
                        this.called = true;
                        this.value = provider.apply(from);
                    }
                    return this.value;
                }
            }
        };
    }

    public static <A> Function<A, A> identity() {
        return IDENTITY;
    }

    public static <A, B, C> Map<A, C> transform(Map<A, ? extends B> map, Function<? super B, ? extends C> transform) {
        LinkedHashMap<A, C> out = new LinkedHashMap<A, C>(map.size());
        for (Map.Entry<A, B> entry : map.entrySet()) {
            C c = transform.apply(entry.getValue());
            if (c == null) continue;
            out.put(entry.getKey(), c);
        }
        return Collections.unmodifiableMap(out);
    }

    public static <A, B> Map<B, A> mapFor(Iterable<A> values, Function<? super A, ? extends B> key) {
        return Functions.mapFor(values, key, Functions.<A>identity());
    }

    public static <X, K, V> Map<K, V> mapFor(Iterable<X> values, Function<? super X, ? extends K> key, Function<? super X, ? extends V> value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (X x : values) {
            map.put(key.apply(x), value.apply(x));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> asMap(final Collection<V> values, final Function<V, K> keyGenerator) {
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(values){
                            Iterator<V> i;
                            {
                                this.i = collection.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.i.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                Object v = this.i.next();
                                return new AbstractMap.SimpleImmutableEntry(keyGenerator.apply(v), v);
                            }

                            @Override
                            public void remove() {
                                this.i.remove();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return values.size();
                    }
                };
            }
        };
    }

    public static <A, B> Function<List<B>, Function<A, B>> createNamedIndex(final List<A> names, final B otherwise) {
        final HashMap<A, Integer> indices = new HashMap<A, Integer>();
        int i = 0;
        while (i < names.size()) {
            indices.put(names.get(i), i);
            ++i;
        }
        return new Function<List<B>, Function<A, B>>(){

            @Override
            public Function<A, B> apply(final List<B> values) {
                if (names.size() != values.size()) {
                    throw new IllegalArgumentException("Names and Values must be the same size: " + names + " not same size as " + values);
                }
                return new Function<A, B>(){

                    @Override
                    public B apply(A from) {
                        Integer i = (Integer)indices.get(from);
                        if (i == null) {
                            return otherwise;
                        }
                        return values.get(i);
                    }
                };
            }
        };
    }

    public static <A, B> B findNonNull(Collection<A> data, Function<A, B> function) {
        for (A a : data) {
            B b;
            if (a == null || (b = function.apply(a)) == null) continue;
            return b;
        }
        return null;
    }

    public static <A, B> Function<Object, B> checked(final Class<A> a, final Class<B> b, final Function<? super A, ? super B> function) {
        return new Function<Object, B>(){

            @Override
            public B apply(Object from) {
                return b.cast(function.apply(a.cast(from)));
            }
        };
    }

    public static <K, V> Function<K, V> fromMap(final Map<K, V> properties) {
        return new Function<K, V>(){

            @Override
            public V apply(K from) throws RuntimeException {
                return properties.get(from);
            }
        };
    }
}

