/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie;

import com.ghc.ghTester.ant.vie.HttpClient;
import com.ghc.ghTester.ant.vie.VieHttpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class VieHttpClient
implements HttpClient {
    private static final Logger logger;
    private static final Set<String> UNWANTED_PROVIDERS;
    private static final String REDIRECTION_HEADER = "Location";
    private static final String USER_HEADER_NAME = "X-User";
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private final org.apache.commons.httpclient.HttpClient client;
    private final HttpMethodRetryHandler handler;
    private final HostConfiguration hostConfig = new HostConfiguration();
    private String username;

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sslCtx);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslCtx.getSocketFactory());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        logger = Logger.getLogger(VieHttpClient.class.getName());
        UNWANTED_PROVIDERS = new HashSet<String>();
    }

    public VieHttpClient() {
        this.client = new org.apache.commons.httpclient.HttpClient();
        this.client.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.client.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)true);
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        this.client.getParams().setConnectionManagerTimeout(30000L);
        this.client.getHttpConnectionManager().getParams().setDefaultMaxConnectionsPerHost(4);
        this.handler = new DefaultHttpMethodRetryHandler(0, false);
    }

    @Override
    public void setCredentials(String username) {
        this.username = username;
    }

    @Override
    public String get(String uri) throws IOException, VieHttpException {
        Map<Provider, Integer> unwantedProviders = VieHttpClient.removeUnwantedProviders();
        GetMethod method = null;
        try {
            String result;
            method = new GetMethod(uri);
            this.setHeaders((HttpMethod)method, null);
            HttpMethodParams params = method.getParams();
            params.setParameter("http.method.retry-handler", (Object)this.handler);
            this.executeMethod((HttpMethodBase)method);
            String string = result = VieHttpClient.readStringFromStream(method.getResponseBodyAsStream());
            return string;
        }
        finally {
            VieHttpClient.reAddUnwantedProviders(unwantedProviders);
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String delete(String uri, Map<String, String> customHeaderValues) throws IOException, VieHttpException {
        Map<Provider, Integer> unwantedProviders = VieHttpClient.removeUnwantedProviders();
        DeleteMethod method = null;
        try {
            String result;
            method = new DeleteMethod(uri);
            this.setHeaders((HttpMethod)method, customHeaderValues);
            HttpMethodParams params = method.getParams();
            params.setParameter("http.method.retry-handler", (Object)this.handler);
            this.executeMethod((HttpMethodBase)method);
            String string = result = VieHttpClient.readStringFromStream(method.getResponseBodyAsStream());
            return string;
        }
        finally {
            VieHttpClient.reAddUnwantedProviders(unwantedProviders);
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String post(String uri, String data, Map<String, String> customHeaderValues) throws IOException, VieHttpException {
        Map<Provider, Integer> unwantedProviders = VieHttpClient.removeUnwantedProviders();
        PostMethod method = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(data.getBytes());
        }
        catch (IOException ex) {
            throw new VieHttpException("Failed to serialize xml", ex, -1);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        try {
            String result;
            method = new PostMethod(uri);
            this.setHeaders((HttpMethod)method, customHeaderValues);
            method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)in, "application/xml"));
            this.executeMethod((HttpMethodBase)method);
            String string = result = VieHttpClient.readStringFromStream(method.getResponseBodyAsStream());
            return string;
        }
        finally {
            VieHttpClient.reAddUnwantedProviders(unwantedProviders);
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public String put(String uri, String xml, Map<String, String> customHeaderValues) throws IOException, VieHttpException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(xml.getBytes());
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        Map<Provider, Integer> unwantedProviders = VieHttpClient.removeUnwantedProviders();
        PutMethod method = null;
        try {
            String result;
            method = new PutMethod(uri);
            this.setHeaders((HttpMethod)method, customHeaderValues);
            method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)in, "application/xml"));
            this.executeMethod((HttpMethodBase)method);
            String string = result = VieHttpClient.readStringFromStream(method.getResponseBodyAsStream());
            return string;
        }
        finally {
            VieHttpClient.reAddUnwantedProviders(unwantedProviders);
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void setHeaders(HttpMethod method, Map<String, String> customHeaderValues) {
        if (this.username != null) {
            try {
                String encodedUsername = URLEncoder.encode(this.username, "utf-8");
                method.setRequestHeader(USER_HEADER_NAME, encodedUsername);
            }
            catch (UnsupportedEncodingException e) {
                String message = "Cannot encode username \"" + this.username + "\"";
                logger.log(Level.SEVERE, message, e);
                System.err.println(String.valueOf(message) + ": " + e.getMessage());
            }
        }
        method.setRequestHeader(USER_AGENT_HEADER_NAME, "com.ghc.ghTester.ant (uses-deprecated-stop-scenario; constructs-env-list-url)");
        if (customHeaderValues != null) {
            for (String key : customHeaderValues.keySet()) {
                method.setRequestHeader(key, customHeaderValues.get(key));
            }
        }
    }

    public static void setHTTPDebugEnabled(boolean enable) {
        if (enable) {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
            System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
            System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
            System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
        } else {
            System.getProperties().remove("org.apache.commons.logging.Log");
            System.getProperties().remove("org.apache.commons.logging.simplelog.showdatetime");
            System.getProperties().remove("org.apache.commons.logging.simplelog.log.httpclient.wire");
            System.getProperties().remove("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient");
        }
    }

    public static String readStringFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        byte[] line = new byte[8192];
        StringBuilder result = new StringBuilder();
        int count = stream.read(line);
        while (count > 0) {
            result.append(new String(line, 0, count, "UTF-8"));
            count = stream.read(line);
        }
        return result.toString();
    }

    private void executeMethod(HttpMethodBase method) throws IOException, HttpException, URIException, VieHttpException {
        method.setDoAuthentication(true);
        block6: while (true) {
            int status = this.client.executeMethod(this.hostConfig, (HttpMethod)method);
            switch (status) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break block6;
                }
                case 302: 
                case 303: 
                case 307: {
                    Header[] headers = method.getResponseHeaders(REDIRECTION_HEADER);
                    method.setURI(new URI(method.getURI(), headers[0].getValue(), false));
                    continue block6;
                }
                default: {
                    String message = "HTTP comms failed with status: " + status;
                    try {
                        String responseBody;
                        Header contentType = method.getResponseHeader("Content-type");
                        if (contentType != null && contentType.getValue() != null && contentType.getValue().startsWith("text/plain") && (responseBody = VieHttpClient.readStringFromStream(method.getResponseBodyAsStream())) != null && !"".equals(responseBody.trim())) {
                            message = responseBody;
                        }
                    }
                    catch (IOException iOException) {}
                    throw new VieHttpException(message, status);
                }
            }
            break;
        }
    }

    public static Map<Provider, Integer> removeUnwantedProviders() {
        if (Boolean.valueOf(System.getProperty("gh.ssl.ignore.entrust", Boolean.toString(true))).booleanValue()) {
            LinkedHashMap<Provider, Integer> ret = new LinkedHashMap<Provider, Integer>();
            Provider[] providers = Security.getProviders();
            int i = 0;
            while (i < providers.length) {
                Provider p = providers[i];
                if (UNWANTED_PROVIDERS.contains(p.getName())) {
                    ret.put(p, i);
                }
                ++i;
            }
            for (Provider p : ret.keySet()) {
                Security.removeProvider(p.getName());
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    public static void reAddUnwantedProviders(Map<Provider, Integer> unwantedProviders) {
        if (unwantedProviders != null) {
            for (Map.Entry<Provider, Integer> entry : unwantedProviders.entrySet()) {
                Security.insertProviderAt(entry.getKey(), entry.getValue() + 1);
            }
        }
    }
}

