/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant;

import com.ghc.ghTester.ant.AppProperties;
import com.ghc.ghTester.ant.CommandLineBuilder;
import com.ghc.ghTester.ant.Tests;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.condition.Os;

public class GHTester
extends Task {
    private static final String APPLICATION_NAME = "RunTests";
    private String m_projectPath;
    private String m_environment;
    private String m_licence;
    private String m_resultsServerLogging = null;
    private boolean m_haltOnFailure = false;
    private String m_failureProperty = null;
    private String m_projectUser;
    private String m_projectPass;
    private String m_junitDir;
    private String m_input;
    private String m_output;
    private boolean m_loginAsAdmin;
    private Tests m_tests;
    private AppProperties m_appProperties;

    public void execute() throws BuildException {
        this.X_validateInputs();
        int exitCode = this.X_runCommandLineApplication();
        if (this.m_haltOnFailure && exitCode != 0) {
            throw new BuildException("Tester exited with code " + exitCode);
        }
        if (this.m_failureProperty != null) {
            this.getProject().setNewProperty(this.m_failureProperty, exitCode != 0 ? "true" : "false");
        }
        this.log("Tester exited with code " + exitCode, 2);
    }

    private void X_validateInputs() throws BuildException {
        if (this.m_projectPath == null) {
            throw new BuildException("No Project path set.");
        }
        if (this.m_tests == null) {
            throw new BuildException("No <tests/> element detected.");
        }
        if (this.m_tests.getRelativeTestPaths().size() == 0) {
            throw new BuildException("No Resources to run.");
        }
    }

    private int X_runCommandLineApplication() throws BuildException {
        String command = this.X_getCommand();
        String application = this.X_getApplication();
        File parameterFile = this.X_createParameterFile();
        File installationDirectory = this.X_getInstallationDirectory();
        CommandLineBuilder cmdlineBuilder = new CommandLineBuilder(command, new File(installationDirectory, application)).withPriorArg(this.X_getPriorArg()).withLicence(this.m_licence).withResultsServerLogging(this.m_resultsServerLogging).withParameterFile(parameterFile).withInput(this.m_input).withOutput(this.m_output);
        if (this.m_appProperties != null) {
            cmdlineBuilder.withVmArgs(this.m_appProperties.jvmFormattedProperties(), new File(installationDirectory, "RunTests.ini"));
        }
        Execute execute = new Execute();
        execute.setCommandline(cmdlineBuilder.build());
        execute.setWorkingDirectory(installationDirectory);
        try {
            return execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("An error occurred while running Tester", (Throwable)e);
        }
    }

    private String X_getCommand() {
        return Os.isFamily((String)"mac") ? "open" : null;
    }

    private String X_getPriorArg() {
        return Os.isFamily((String)"mac") ? "--args" : null;
    }

    private String X_getApplication() throws BuildException {
        String ret = null;
        if (Os.isFamily((String)"windows")) {
            ret = "RunTests.exe";
        } else if (Os.isFamily((String)"mac")) {
            ret = "RunTests.app";
        } else if (Os.isFamily((String)"unix")) {
            ret = APPLICATION_NAME;
        } else {
            throw new BuildException("Operating System not supported.");
        }
        return ret;
    }

    private File X_createParameterFile() throws BuildException {
        File ret = null;
        BufferedReader inputStream = null;
        PrintWriter outputStream = null;
        try {
            try {
                String l;
                File tmpFile = File.createTempFile("ant_param", "");
                tmpFile.deleteOnExit();
                inputStream = new BufferedReader(new StringReader(this.X_getParameterFileContents()));
                outputStream = new PrintWriter(new BufferedWriter(new FileWriter(tmpFile)));
                while ((l = inputStream.readLine()) != null) {
                    outputStream.println(l);
                }
                ret = tmpFile;
            }
            catch (IOException e) {
                throw new BuildException("Could not create parameter file in default temporary-file directory", (Throwable)e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new BuildException("An error occurred while trying to write to the temporary parameter file", (Throwable)e);
                }
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return ret;
    }

    private String X_getParameterFileContents() {
        StringBuilder b = new StringBuilder();
        b.append("-project \"" + this.m_projectPath + '\"');
        b.append(" ");
        if (this.m_environment != null) {
            b.append("-environment \"" + this.m_environment + '\"');
            b.append(" ");
        }
        b.append("-run ");
        Iterator<String> it = this.m_tests.getRelativeTestPaths().iterator();
        while (it.hasNext()) {
            b.append(String.valueOf('\"') + it.next() + '\"');
            if (!it.hasNext()) continue;
            b.append(";");
        }
        if (this.m_projectUser != null) {
            b.append(" -projectUser \"").append(this.m_projectUser).append('\"');
        }
        if (this.m_projectPass != null) {
            b.append(" -projectPass \"").append(this.m_projectPass).append('\"');
        }
        if (this.m_junitDir != null) {
            b.append(" -junitDir \"").append(this.m_junitDir).append('\"');
        }
        if (this.m_loginAsAdmin) {
            b.append(" -loginAsAdmin");
        }
        return b.toString();
    }

    private File X_getInstallationDirectory() throws BuildException {
        File install;
        File ret = null;
        String installationDirectory = this.getProject().getProperty("install.dir");
        if (installationDirectory != null) {
            install = new File(installationDirectory);
            if (!install.exists()) {
                throw new BuildException("The installation directory '" + installationDirectory + "' does not exit.");
            }
        } else {
            throw new BuildException("The installation directory '" + installationDirectory + "' does not exit.");
        }
        ret = install;
        return ret;
    }

    public void setProject(String projectPath) {
        this.m_projectPath = projectPath;
    }

    public void setEnvironment(String environment) {
        this.m_environment = environment;
    }

    public void setLicence(String licence) {
        this.m_licence = licence;
    }

    public void setHaltOnFailure(boolean haltOnError) {
        this.m_haltOnFailure = haltOnError;
    }

    public void setFailureProperty(String value) {
        this.m_failureProperty = value;
    }

    public void setResultsServerLogging(String resultsServerLogging) {
        this.m_resultsServerLogging = resultsServerLogging;
    }

    public void setProjectUser(String projectUser) {
        this.m_projectUser = projectUser;
    }

    public void setProjectPass(String projectPass) {
        this.m_projectPass = projectPass;
    }

    public void setJunitDir(String junitDir) {
        this.m_junitDir = junitDir;
    }

    public void setInput(String input) {
        this.m_input = input;
    }

    public void setOutput(String output) {
        this.m_output = output;
    }

    public void setLoginAsAdmin(boolean loginAsAdmin) {
        this.m_loginAsAdmin = loginAsAdmin;
    }

    public void addTests(Tests tests) throws BuildException {
        this.X_verifyNullTests();
        this.m_tests = tests;
    }

    public void addAppProperties(AppProperties appProperties) {
        this.m_appProperties = appProperties;
    }

    private void X_verifyNullTests() throws BuildException {
        if (this.m_tests != null) {
            throw new BuildException("Cannot have more then one Tests child.");
        }
    }
}

