/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.StubDefinition;
import com.ghc.ghTester.ant.vie.stubs.StubInstance;
import com.ghc.ghTester.ant.vie.stubs.StubsService;
import com.ghc.ghTester.ant.vie.stubs.StubsServiceImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class StubStopper {
    private static final Logger log = Logger.getLogger(StubStopper.class.getName());
    private static final PrintStream OUT = System.out;
    private final StubsService controller;
    private final boolean async;
    private final String username;
    private boolean terminated = false;

    public StubStopper(StubsService stubService, boolean async, String username) throws URISyntaxException {
        this.username = username;
        this.async = async;
        this.controller = stubService;
    }

    public StubStopper(String url, String domain, String environment, String component, String operation, String stub, String version, boolean async, String username) throws URISyntaxException {
        this.username = username;
        this.controller = new StubsServiceImpl(url, domain, environment, component, operation, null, null, stub, version);
        this.async = async;
    }

    public StubStopper(String ghServerURL, String domain, String environmentName, String stubId, String stubVersion, boolean async, String username) throws URISyntaxException {
        this(ghServerURL, domain, environmentName, null, null, stubId, null, stubVersion, async, username);
    }

    private StubStopper(String url, String domain, String environment, String component, String operation, String stubId, String stub, String version, boolean async, String username) throws URISyntaxException {
        this.username = username;
        this.controller = new StubsServiceImpl(url, domain, environment, component, operation, null, stubId, stub, version);
        this.async = async;
    }

    public ExitCode stopStub() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            List<StubInstance> stubInstances;
            List<StubDefinition> stubDefs;
            if (this.username != null) {
                OUT.println("Using username: " + this.username);
            }
            try {
                stubDefs = this.controller.locateStubs();
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 404) {
                    OUT.println("Unable to obtain a list of stubs from the server, check the server version and URL is correct");
                    return ExitCode.SERVER_CONNECTION_ERROR;
                }
                if (e.getStatus() == 412) {
                    OUT.println("Incorrect domain or environment supplied");
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (stubDefs.isEmpty()) {
                OUT.println("No stubs found matching supplied parameters");
                return ExitCode.TARGET_NOT_FOUND;
            }
            HashSet<String> stubHrefs = new HashSet<String>();
            for (StubDefinition stubDefinition : stubDefs) {
                stubHrefs.add(stubDefinition.getHref());
                if (stubHrefs.size() <= 1) continue;
                OUT.println("Multiple stubs found and only 1 can be stopped at a time, use a more specific set of parameters");
                return ExitCode.MULTIPLE_TARGETS_FOUND;
            }
            StubDefinition stubDef = stubDefs.get(0);
            log.finest("Stopping stub: " + stubDef);
            try {
                stubInstances = this.controller.getInstances(stubDef);
            }
            catch (VieHttpException e) {
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            log.finest("Found " + stubInstances.size() + " instances to try and stop");
            try {
                for (StubInstance instance : stubInstances) {
                    this.controller.stopInstance(instance, this.username);
                }
            }
            catch (VieHttpException e) {
                OUT.println(e.getMessage());
                if (e.getStatus() == 423) {
                    if (this.username == null) {
                        OUT.println("Specify the \"username\" option to stop a stub in a locked environment.");
                    }
                    return ExitCode.ENVIRONMENT_LOCKED;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (!this.async) {
                OUT.println("Waiting for stub instance(s) to stop...");
                this.terminated = false;
                while (!this.terminated) {
                    List<StubInstance> instances;
                    try {
                        instances = this.controller.getInstances(stubDef);
                    }
                    catch (VieHttpException e) {
                        OUT.println(e.getMessage());
                        return ExitCode.UNRECOGNISED_SERVER_ERROR;
                    }
                    OUT.println(String.valueOf(instances.size()) + " instance(s) still running.");
                    if (instances.size() == 0) {
                        return ExitCode.SUCCESS;
                    }
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                OUT.println("Stub instance(s) will be stopped in the background.");
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

