/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs;

import com.ghc.ghTester.ant.vie.DomUtils;
import com.ghc.ghTester.ant.vie.stubs.StubInstance;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StubInstanceFactory {
    private static final Logger log = Logger.getLogger(StubInstanceFactory.class.getName());
    public static final StubInstanceFactory INSTANCE = new StubInstanceFactory();
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public StubInstance fromXML(String relativeURL, String xml) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        if (element != null) {
            StubInstance instance = this.buildStubInstance(relativeURL, element);
            return instance;
        }
        return null;
    }

    private StubInstance buildStubInstance(String relativeURL, Element element) throws URISyntaxException, TransformerException, ParserConfigurationException {
        String href = element.getAttribute("href");
        String status = element.getAttribute("status");
        if (href != null && status != null) {
            URI uri = new URI(relativeURL);
            href = uri.resolve(href).toString();
            StubInstance instance = new StubInstance(href, status);
            return instance;
        }
        log.severe("Unable to build StubInstance from XML, href could not be found: " + DomUtils.toXML(element));
        return null;
    }

    public List<StubInstance> listFromXML(String relativeURL, String xml) throws URISyntaxException, IOException, TransformerException, ParserConfigurationException, SAXException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xml)));
        LinkedList<StubInstance> result = new LinkedList<StubInstance>();
        Element element = document.getDocumentElement();
        NodeList nodes = element.getChildNodes();
        if (nodes != null) {
            int k = 0;
            while (k < nodes.getLength()) {
                StubInstance instance;
                Element el;
                Node n = nodes.item(k);
                if (n instanceof Element && (el = (Element)n) != null && (instance = this.buildStubInstance(relativeURL, el)) != null) {
                    result.add(instance);
                }
                ++k;
            }
        }
        return result;
    }
}

