/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.lang;

import com.ghc.lang.Provider;
import com.ghc.lang.RefCounted;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RefCountedProvider<A, B> {
    private final Map<A, Counted<B>> cache = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCounted<B> acquire(final A key, Provider<B> provider) {
        Map<A, Counted<B>> map = this.cache;
        synchronized (map) {
            Counted value = this.cache.get(key);
            if (value == null) {
                value = new Counted<B>(provider.get()){

                    @Override
                    protected void purge() {
                        RefCountedProvider.this.cache.remove(key);
                    }
                };
                this.cache.put(key, value);
            }
            return value.acquire();
        }
    }

    static abstract class Counted<T> {
        public final T value;
        private final AtomicInteger count = new AtomicInteger(0);

        public Counted(T value) {
            this.value = value;
        }

        protected abstract void purge();

        public RefCounted<T> acquire() {
            return new RefCounted<T>(){
                private volatile boolean acquired = true;
                {
                    Counted.this.count.incrementAndGet();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T release() {
                    if (this.acquired) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.acquired) {
                                this.acquired = false;
                                if (Counted.this.count.decrementAndGet() == 0) {
                                    Counted.this.purge();
                                }
                            }
                        }
                    }
                    return Counted.this.value;
                }
            };
        }
    }
}

