/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.ghTester.ant.vie.stubs.environment;

import com.ghc.ghTester.ant.vie.VieHttpException;
import com.ghc.ghTester.ant.vie.stubs.ExitCode;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentReferenceDefinition;
import com.ghc.ghTester.ant.vie.stubs.environment.EnvironmentService;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class EnvironmentDeleter {
    private static final PrintStream OUT = System.out;
    private final String environmentName;
    private final String username;
    private final EnvironmentService service;

    public EnvironmentDeleter(String serverURL, String domain, String environment, String username) throws URISyntaxException {
        this.environmentName = environment;
        this.username = username;
        this.service = new EnvironmentService(serverURL, domain);
    }

    public ExitCode delete() throws URISyntaxException, ParserConfigurationException, SAXException, TransformerException {
        try {
            EnvironmentReferenceDefinition environment;
            if (this.username != null) {
                OUT.println("Using username: " + this.username);
            }
            try {
                environment = this.service.locateEnvironmentReference(this.environmentName);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 412) {
                    OUT.println("Unable to find the domain on Rational Test Control Panel, check supplied parameters.");
                    OUT.println(e.getMessage());
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            if (environment == null) {
                OUT.println("Unable to find the environment on Rational Test Control Panel, check supplied parameters.");
                return ExitCode.TARGET_NOT_FOUND;
            }
            try {
                this.service.deleteEnvironment(environment, this.username);
            }
            catch (VieHttpException e) {
                if (e.getStatus() == 404) {
                    OUT.println("Unable to find the environment on Rational Test Control Panel, check supplied parameters.");
                    OUT.println(e.getMessage());
                    return ExitCode.TARGET_NOT_FOUND;
                }
                if (e.getStatus() == 412) {
                    OUT.println("Unable to find the domain on Rational Test Control Panel, check supplied parameters.");
                    OUT.println(e.getMessage());
                    return ExitCode.DOMAIN_OR_ENV_NOT_FOUND;
                }
                if (e.getStatus() == 423) {
                    OUT.println("Environment is locked on Rational Test Control Panel. Specify correct username or unlock environment.");
                    OUT.println(e.getMessage());
                    return ExitCode.ENVIRONMENT_LOCKED;
                }
                if (e.getStatus() == 405) {
                    OUT.println("This environment cannot be deleted.");
                    OUT.println(e.getMessage());
                    return ExitCode.ACTION_FAILED;
                }
                if (e.getStatus() == 420) {
                    OUT.println("This environment cannot be deleted at this time. Is it in use?");
                    OUT.println(e.getMessage());
                    return ExitCode.ACTION_FAILED;
                }
                OUT.println(e.getMessage());
                return ExitCode.UNRECOGNISED_SERVER_ERROR;
            }
            return ExitCode.SUCCESS;
        }
        catch (IOException e) {
            OUT.println("Could not connect to Rational Test Control Panel.");
            OUT.println(e.getMessage());
            return ExitCode.SERVER_CONNECTION_ERROR;
        }
    }
}

