/*
 * Decompiled with CFR 0.152.
 */
package com.ghc.lang;

import com.ghc.lang.Provider;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(final T value) {
        return new Provider<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static <T> Provider<T> once(final Provider<T> expensive) {
        return new Provider<T>(){
            T t = null;

            @Override
            public T get() {
                if (this.t == null) {
                    this.t = expensive.get();
                }
                return this.t;
            }
        };
    }

    public static <T> Provider<T> cacheUsingWeakRef(T initial, final Provider<T> otherwise) {
        return new Provider<T>(initial){
            Reference<T> ref;
            {
                this.ref = new WeakReference<Object>(object);
            }

            @Override
            public T get() {
                Object t = this.ref.get();
                if (t == null) {
                    t = otherwise.get();
                    this.ref = new WeakReference(t);
                }
                return t;
            }
        };
    }

    public static <T> Provider<T> before(final Provider<T> t, final Runnable before) {
        return new Provider<T>(){

            @Override
            public T get() {
                before.run();
                return t.get();
            }
        };
    }

    public static <T> Provider<T> onceBefore(T value, Runnable runnable) {
        return Providers.once(Providers.before(Providers.of(value), runnable));
    }
}

