/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.FileTime;
import com.urbancode.winapi.HKey;
import com.urbancode.winapi.Handle;
import com.urbancode.winapi.NoFinalizerHandle;
import com.urbancode.winapi.Overlapped;
import com.urbancode.winapi.PredefinedHKey;
import com.urbancode.winapi.ProcessInformation;
import com.urbancode.winapi.PseudoHandle;
import com.urbancode.winapi.RefFileTime;
import com.urbancode.winapi.RefInt;
import com.urbancode.winapi.RefLong;
import com.urbancode.winapi.RefString;
import com.urbancode.winapi.SecurityAttributes;
import com.urbancode.winapi.StartupInfo;
import com.urbancode.winapi.WinApiPermission;
import com.urbancode.winapi.WindowsException;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public final class WinApi {
    private static final Logger log;
    public static final String DLL_PATH_PROPERTY = "com.urbancode.winapi.WinAPI.dllPath";

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreatePipe(Handle readPipe, Handle writePipe, SecurityAttributes securityAttributes, int size) throws WindowsException {
        if (readPipe == null) {
            throw new NullPointerException("readPipe");
        }
        if (writePipe == null) {
            throw new NullPointerException("writePipe");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        Lock readPipeLock = readPipe.lockWrite();
        try {
            if (readPipe.isOpen()) {
                throw new IllegalArgumentException("readPipe is open");
            }
            Lock writePipeLock = writePipe.lockWrite();
            try {
                if (writePipe.isOpen()) {
                    throw new IllegalArgumentException("writePipe is open");
                }
                WinApi.checkPermission("CreatePipe");
                if (log.isTraceEnabled()) {
                    log.trace((Object)"CreatePipe0");
                }
                WinApi.CreatePipe0(readPipe, writePipe, securityAttributes, size);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"CreatePipe0 returned");
                    log.trace((Object)("Read handle " + readPipe));
                    log.trace((Object)("Write handle " + writePipe));
                }
            }
            finally {
                writePipeLock.unlock();
            }
        }
        finally {
            readPipeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CreateProcess(String applicationName, String commandLine, SecurityAttributes processAttributes, SecurityAttributes threadAttributes, boolean inheritHandles, int creationFlags, String environment, String currentDirectory, StartupInfo startupInfo, ProcessInformation processInformation) throws WindowsException {
        if (startupInfo == null) {
            throw new NullPointerException("startupInfo");
        }
        if (processInformation == null) {
            throw new NullPointerException("processInformation");
        }
        if (applicationName == null && commandLine == null) {
            throw new IllegalArgumentException("applicationName == null && commandLine == null");
        }
        Handle processHandle = processInformation.getProcess();
        Handle threadHandle = processInformation.getThread();
        if (processHandle == null) {
            throw new NullPointerException("processInformation.process");
        }
        if (threadHandle == null) {
            throw new NullPointerException("processInformation.thread");
        }
        applicationName = WinApi.createNulTerminatedString(applicationName);
        commandLine = WinApi.createNulTerminatedString(commandLine);
        currentDirectory = WinApi.createNulTerminatedString(currentDirectory);
        Lock processLock = processHandle.lockWrite();
        try {
            if (processHandle.isOpen()) {
                throw new IllegalArgumentException("processInformation.process is open");
            }
            Lock threadLock = threadHandle.lockWrite();
            try {
                if (threadHandle.isOpen()) {
                    throw new IllegalArgumentException("processInformation.thread is open");
                }
                WinApi.checkPermission("CreateProcess");
                if (log.isTraceEnabled()) {
                    log.trace((Object)"CreateProcess0");
                }
                WinApi.CreateProcess0(applicationName, commandLine, processAttributes, threadAttributes, inheritHandles, creationFlags, environment, currentDirectory, startupInfo, processInformation);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"CreateProcess0 returned");
                }
            }
            finally {
                threadLock.unlock();
            }
        }
        finally {
            processLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handle CreateFile(String fileName, int desiredAccess, int shareMode, SecurityAttributes securityAttributes, int creationDisposition, int flagsAndAttributes, Handle templateFile, RefInt lastError) throws WindowsException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        fileName = WinApi.createNulTerminatedString(fileName);
        Handle result = new Handle();
        Lock lock = result.lockWrite();
        try {
            WinApi.checkPermission("CreateFile");
            if (log.isTraceEnabled()) {
                log.trace((Object)"CreateFile0");
            }
            WinApi.CreateFile0(fileName, desiredAccess, shareMode, securityAttributes, creationDisposition, flagsAndAttributes, templateFile, result, lastError);
            if (log.isTraceEnabled()) {
                log.trace((Object)"CreateFile0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public static void CreateDirectory(String pathName, SecurityAttributes securityAttributes) throws WindowsException {
        if (pathName == null) {
            throw new NullPointerException("pathName");
        }
        pathName = WinApi.createNulTerminatedString(pathName);
        WinApi.checkPermission("CreateDirectory");
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateDirectory0");
        }
        WinApi.CreateDirectory0(pathName, securityAttributes);
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateDirectory0 returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void TerminateProcess(Handle process, int exitCode) throws WindowsException {
        if (process == null) {
            throw new NullPointerException("process");
        }
        Lock lock = process.lockWrite();
        try {
            if (!process.isOpen()) {
                throw new IllegalArgumentException("process handle is not open");
            }
            WinApi.checkPermission("TerminateProcess");
            if (log.isTraceEnabled()) {
                log.trace((Object)"TerminateProces0");
            }
            WinApi.TerminateProcess0(process, exitCode);
            if (log.isTraceEnabled()) {
                log.trace((Object)"TerminateProcess0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ReadFile(Handle file, byte[] buffer, int bufferOffset, int numberOfBytesToRead, RefInt numberOfBytesRead, Overlapped overlapped) throws WindowsException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException("bufferOffset < 0");
        }
        if (numberOfBytesToRead < 0) {
            throw new IndexOutOfBoundsException("numberOfBytesToRead < 0");
        }
        if (numberOfBytesToRead > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException("numberOfBytesToRead + bufferOffset > buffer.length");
        }
        if (numberOfBytesRead == null && overlapped == null) {
            throw new IllegalArgumentException("numberOfBytesRead == null && overlapped == null");
        }
        if (overlapped != null) {
            throw new UnsupportedOperationException("asynchronous io unsupported");
        }
        Lock lock = file.lockRead();
        try {
            if (!file.isOpen()) {
                throw new IllegalArgumentException("file is not open");
            }
            WinApi.checkPermission("ReadFile");
            if (log.isTraceEnabled()) {
                log.trace((Object)"ReadFile0");
            }
            WinApi.ReadFile0(file, buffer, bufferOffset, numberOfBytesToRead, numberOfBytesRead, overlapped);
            if (log.isTraceEnabled()) {
                log.trace((Object)"ReadFile0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteFile(Handle file, byte[] buffer, int bufferOffset, int numberOfBytesToWrite, RefInt numberOfBytesWritten, Overlapped overlapped) throws WindowsException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException("bufferOffset < 0");
        }
        if (numberOfBytesToWrite < 0) {
            throw new IndexOutOfBoundsException("numberOfBytesToWrite < 0");
        }
        if (numberOfBytesToWrite > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException("numberOfBytesToWrite + bufferOffset > buffer.length");
        }
        if (numberOfBytesWritten == null && overlapped == null) {
            throw new IllegalArgumentException("numberOfBytesWritten == null && overlapped == null");
        }
        if (overlapped != null) {
            throw new UnsupportedOperationException("asynchronous io unsupported");
        }
        Lock lock = file.lockRead();
        try {
            if (!file.isOpen()) {
                throw new IllegalArgumentException("file is not open");
            }
            WinApi.checkPermission("WriteFile");
            if (log.isTraceEnabled()) {
                log.trace((Object)"WriteFile0");
            }
            WinApi.WriteFile0(file, buffer, bufferOffset, numberOfBytesToWrite, numberOfBytesWritten, overlapped);
            if (log.isTraceEnabled()) {
                log.trace((Object)"WriteFile0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CloseHandle(Handle handle) throws WindowsException {
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        if (!(handle instanceof PseudoHandle)) {
            Lock lock = handle.lockWrite();
            try {
                if (handle.isOpen()) {
                    WinApi.checkPermission("CloseHandle");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"CloseHandle0");
                    }
                    WinApi.CloseHandle0(handle);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"CloseHandle0 returned");
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void CreateHardLink(String fileName, String existingFileName) throws WindowsException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (existingFileName == null) {
            throw new NullPointerException("existingFileName");
        }
        fileName = WinApi.createNulTerminatedString(fileName);
        existingFileName = WinApi.createNulTerminatedString(existingFileName);
        WinApi.checkPermission("CreateHardLink");
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateHardLink0");
        }
        WinApi.CreateHardLink0(fileName, existingFileName);
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateHardLink0 returned");
        }
    }

    public static void CreateSymbolicLink(String symlinkFileName, String targetFileName, int flags) throws WindowsException {
        if (symlinkFileName == null) {
            throw new NullPointerException("symlinkFileName");
        }
        if (targetFileName == null) {
            throw new NullPointerException("targetFileName");
        }
        symlinkFileName = WinApi.createNulTerminatedString(symlinkFileName);
        targetFileName = WinApi.createNulTerminatedString(targetFileName);
        WinApi.checkPermission("CreateSymbolicLink");
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateSymbolicLink0");
        }
        WinApi.CreateSymbolicLink0(symlinkFileName, targetFileName, flags);
        if (log.isTraceEnabled()) {
            log.trace((Object)"CreateSymbolicLink0 returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetHandleInformation(Handle object, int mask, int flags) throws WindowsException {
        if (object == null) {
            throw new NullPointerException("object");
        }
        Lock lock = object.lockRead();
        try {
            if (!object.isOpen()) {
                throw new IllegalArgumentException("object is not open");
            }
            WinApi.checkPermission("SetHandleInformation");
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetHandleInformation0");
            }
            WinApi.SetHandleInformation0(object, mask, flags);
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetHandleInformation0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GetExitCodeProcess(Handle process, RefInt exitCode) throws WindowsException {
        if (process == null) {
            throw new NullPointerException("process");
        }
        if (exitCode == null) {
            throw new NullPointerException("exitCode");
        }
        Lock lock = process.lockRead();
        try {
            if (!process.isOpen()) {
                throw new IllegalArgumentException("process handle is not open");
            }
            WinApi.checkPermission("GetExitCodeProcess");
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetExitCodeProcess0");
            }
            WinApi.GetExitCodeProcess0(process, exitCode);
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetExitCodeProcess0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GetHandleInformation(Handle object, RefInt flags) throws WindowsException {
        if (object == null) {
            throw new NullPointerException("process");
        }
        if (flags == null) {
            throw new NullPointerException("exitflags");
        }
        Lock lock = object.lockRead();
        try {
            if (!object.isOpen()) {
                throw new IllegalArgumentException("object is not open");
            }
            WinApi.checkPermission("GetHandleInformation");
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetHandleInformation0");
            }
            WinApi.GetHandleInformation0(object, flags);
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetHandleInformation0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handle GetStdHandle(int stdHandle) throws WindowsException {
        NoFinalizerHandle handle = new NoFinalizerHandle();
        Lock lock = handle.lockWrite();
        try {
            WinApi.checkPermission("GetStdHandle");
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetStdHandle0");
            }
            WinApi.GetStdHandle0(stdHandle, handle);
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetStdHandle0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        if (!handle.isOpen()) {
            handle = null;
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DuplicateHandle(Handle sourceProcessHandle, Handle sourceHandle, Handle targetProcessHandle, Handle targetHandle, int desiredAccess, boolean inheritHandle, int options) throws WindowsException {
        if (sourceProcessHandle == null) {
            throw new NullPointerException("sourceProcessHandle");
        }
        if (sourceHandle == null) {
            throw new NullPointerException("sourceHandle");
        }
        if (targetProcessHandle == null) {
            throw new NullPointerException("targetProcessHandle");
        }
        if (targetHandle == null) {
            throw new NullPointerException("targetHandle");
        }
        Lock sourceProcessLock = sourceProcessHandle.lockRead();
        try {
            if (!sourceProcessHandle.isOpen()) {
                throw new IllegalArgumentException("sourceProcessHandle is not open");
            }
            Lock sourceLock = sourceHandle.lockRead();
            try {
                if (!sourceHandle.isOpen()) {
                    throw new IllegalArgumentException("sourceHandle is not open");
                }
                Lock targetProcessLock = targetProcessHandle.lockRead();
                try {
                    if (!targetProcessHandle.isOpen()) {
                        throw new IllegalArgumentException("targetProcessHandle is not open");
                    }
                    Lock targetLock = targetHandle.lockWrite();
                    try {
                        if (targetHandle.isOpen()) {
                            throw new IllegalArgumentException("targetHandle is open");
                        }
                        WinApi.checkPermission("DuplicateHandle");
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"DuplicateHandle0");
                        }
                        WinApi.DuplicateHandle0(sourceProcessHandle, sourceHandle, targetProcessHandle, targetHandle, desiredAccess, inheritHandle, options);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"DuplicateHandle0 returned");
                        }
                    }
                    finally {
                        targetLock.unlock();
                    }
                }
                finally {
                    targetProcessLock.unlock();
                }
            }
            finally {
                sourceLock.unlock();
            }
        }
        finally {
            sourceProcessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handle GetCurrentProcess() {
        PseudoHandle handle = new PseudoHandle();
        Lock lock = handle.lockWrite();
        try {
            WinApi.checkPermission("GetCurrentProcess");
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetCurrentProcess0");
            }
            WinApi.GetCurrentProcess0(handle);
            if (log.isTraceEnabled()) {
                log.trace((Object)"GetCurrentProcess0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int WaitForSingleObject(Handle handle, int milliseconds) throws WindowsException {
        int result;
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        Lock lock = handle.lockRead();
        try {
            if (!handle.isOpen()) {
                throw new IllegalArgumentException("handle is not open");
            }
            WinApi.checkPermission("WaitForSingleObject");
            if (log.isTraceEnabled()) {
                log.trace((Object)"WaitForSingleObject0");
            }
            result = WinApi.WaitForSingleObject0(handle, milliseconds);
            if (log.isTraceEnabled()) {
                log.trace((Object)"WaitForSingleObject0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetEndOfFile(Handle file) throws WindowsException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        Lock lock = file.lockRead();
        try {
            if (!file.isOpen()) {
                throw new IllegalArgumentException("file is not open");
            }
            WinApi.checkPermission("SetEndOfFile");
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetEndOfFile0");
            }
            WinApi.SetEndOfFile0(file);
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetEndOfFile0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetFilePointerEx(Handle file, long distanceToMove, RefLong newFilePointer, int moveMethod) throws WindowsException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        Lock lock = file.lockRead();
        try {
            if (!file.isOpen()) {
                throw new IllegalArgumentException("file is not open");
            }
            WinApi.checkPermission("SetFilePointerEx");
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetFilePointerEx0");
            }
            WinApi.SetFilePointerEx0(file, distanceToMove, newFilePointer, moveMethod);
            if (log.isTraceEnabled()) {
                log.trace((Object)"SetFilePointerEx0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void KillProcessEx(int processId, boolean tree) throws WindowsException {
        WinApi.checkPermission("KillProcessEx");
        if (log.isTraceEnabled()) {
            log.trace((Object)"KillProcessEx0");
        }
        WinApi.KillProcessEx0(processId, tree);
        if (log.isTraceEnabled()) {
            log.trace((Object)"KillProcessEx0 returned");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegCloseKey(HKey hkey) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        if (!(hkey instanceof PredefinedHKey)) {
            Lock lock = hkey.lockWrite();
            try {
                if (hkey.isOpen()) {
                    WinApi.checkPermission("RegCloseKey");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"RegCloseKey0");
                    }
                    WinApi.RegCloseKey0(hkey);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"RegCloseKey0 returned");
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HKey RegOpenKeyEx(HKey hkey, String subKey, int samDesired) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        HKey result = new HKey();
        subKey = WinApi.createNulTerminatedString(subKey);
        Lock hkeyLock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            Lock resultLock = result.lockWrite();
            try {
                WinApi.checkPermission("RegOpenKeyEx");
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegOpenKeyEx0");
                }
                WinApi.RegOpenKeyEx0(hkey, subKey, samDesired, result);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegOpenKeyEx0 returned");
                }
            }
            finally {
                resultLock.unlock();
            }
        }
        finally {
            hkeyLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] RegQueryValueEx(HKey hkey, String valueName, RefInt type) throws WindowsException {
        byte[] buffer;
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        Lock lock = hkey.lockRead();
        try {
            boolean bufferFilled;
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            RefInt count = new RefInt();
            valueName = WinApi.createNulTerminatedString(valueName);
            WinApi.checkPermission("RegOpenKeyEx");
            count.value = WinApi.RegQueryValueExSize(hkey, valueName, null);
            do {
                buffer = new byte[count.value];
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegQueryValueEx0");
                }
                bufferFilled = WinApi.RegQueryValueEx0(hkey, valueName, type, buffer, count);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"RegQueryValueEx0 returned");
            } while (!bufferFilled);
        }
        finally {
            lock.unlock();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int RegQueryValueExSize(HKey hkey, String valueName, RefInt type) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        RefInt count = new RefInt();
        valueName = WinApi.createNulTerminatedString(valueName);
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegQueryValueEx");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegQueryValueEx0");
            }
            WinApi.RegQueryValueEx0(hkey, valueName, type, null, count);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegQueryValueEx0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return count.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] RegEnumValue(HKey hkey, int index, RefString valueName, RefInt type) throws WindowsException {
        byte[] buffer;
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        if (valueName == null) {
            throw new NullPointerException("valueName");
        }
        RefInt count = new RefInt();
        Lock lock = hkey.lockRead();
        try {
            boolean bufferFilled;
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegEnumValue");
            count.value = WinApi.RegEnumValueSize(hkey, index, valueName, null);
            do {
                if (count.value < 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                buffer = new byte[count.value];
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegEnumValue0");
                }
                bufferFilled = WinApi.RegEnumValue0(hkey, index, valueName, type, buffer, count);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"RegEnumValue0 returned");
            } while (!bufferFilled);
        }
        finally {
            lock.unlock();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int RegEnumValueSize(HKey hkey, int index, RefString valueName, RefInt type) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        if (valueName == null) {
            throw new NullPointerException("valueName");
        }
        RefInt count = new RefInt();
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegEnumValue");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegEnumValue0");
            }
            WinApi.RegEnumValue0(hkey, index, valueName, type, null, count);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegEnumValue0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return count.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String RegEnumKeyEx(HKey hkey, int index, RefFileTime lastWriteTime) throws WindowsException {
        String result;
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        RefLong refLastWriteTime = new RefLong();
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegEnumKeyEx");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegEnumKeyEx0");
            }
            result = WinApi.RegEnumKeyEx0(hkey, index, lastWriteTime != null ? refLastWriteTime : null);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegEnumKeyEx0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        if (lastWriteTime != null) {
            lastWriteTime.value = new FileTime(refLastWriteTime.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegSetValueEx(HKey hkey, String valueName, int type, byte[] data) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        valueName = WinApi.createNulTerminatedString(valueName);
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegSetValueEx");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegSetValueEx0");
            }
            WinApi.RegSetValueEx0(hkey, valueName, type, data);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegSetValueEx0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegDeleteValue(HKey hkey, String valueName) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        valueName = WinApi.createNulTerminatedString(valueName);
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegDeleteValue");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegDeleteValue0");
            }
            WinApi.RegDeleteValue0(hkey, valueName);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegDeleteValue0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegDeleteKey(HKey hkey, String subKey) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        if (subKey == null) {
            throw new NullPointerException("subKey");
        }
        subKey = WinApi.createNulTerminatedString(subKey);
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegDeleteKey");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegDeleteKey0");
            }
            WinApi.RegDeleteKey0(hkey, subKey);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegDeleteKey0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegFlushKey(HKey hkey) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        Lock lock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            WinApi.checkPermission("RegFlushKey");
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegFlushKey0");
            }
            WinApi.RegFlushKey0(hkey);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegFlushKey0 returned");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HKey RegCreateKeyEx(HKey hkey, String subKey, int options, int samDesired, SecurityAttributes securityAttributes, RefInt disposition) throws WindowsException {
        if (hkey == null) {
            throw new NullPointerException("hkey");
        }
        if (subKey == null) {
            throw new NullPointerException("subKey");
        }
        subKey = WinApi.createNulTerminatedString(subKey);
        HKey result = new HKey();
        Lock hkeyLock = hkey.lockRead();
        try {
            if (!hkey.isOpen()) {
                throw new IllegalArgumentException("hkey is not open");
            }
            Lock resultLock = result.lockWrite();
            try {
                WinApi.checkPermission("RegCreateKeyEx");
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegCreateKeyEx0");
                }
                WinApi.RegCreateKeyEx0(hkey, subKey, options, samDesired, securityAttributes, disposition, result);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"RegCreateKeyEx0 returned");
                }
            }
            finally {
                resultLock.unlock();
            }
        }
        finally {
            hkeyLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ResumeThread(Handle handle) throws WindowsException {
        int result;
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        Lock lock = handle.lockRead();
        try {
            if (!handle.isOpen()) {
                throw new IllegalArgumentException("handle is not open");
            }
            WinApi.checkPermission("ResumeThread");
            if (log.isTraceEnabled()) {
                log.trace((Object)"ResumeThread0");
            }
            result = WinApi.ResumeThread0(handle);
            if (log.isTraceEnabled()) {
                log.trace((Object)"ResumeThread0 returned");
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    static void closeInFinalizer(Handle handle) throws WindowsException {
        if (!(handle instanceof PseudoHandle)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Finalizing Handle; Handle instances should be closed explicitly");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"CloseHandle0");
            }
            WinApi.CloseHandle0(handle);
            if (log.isTraceEnabled()) {
                log.trace((Object)"CloseHandle0 returned");
            }
        }
    }

    static void closeInFinalizer(HKey hkey) throws WindowsException {
        if (!(hkey instanceof PredefinedHKey)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Finalizing HKey; HKey instances should be closed explicitly");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegCloseKey0");
            }
            WinApi.RegCloseKey0(hkey);
            if (log.isTraceEnabled()) {
                log.trace((Object)"RegCloseKey0 returned");
            }
        }
    }

    private static void checkPermission(String name) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Checking permission " + name));
            }
            WinApiPermission permission = new WinApiPermission(name);
            securityManager.checkPermission(permission);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Permission " + name + " granted"));
            }
        }
    }

    private static String createNulTerminatedString(String string) {
        if (string == null) {
            return null;
        }
        if (string.charAt(string.length() - 1) == '\u0000') {
            return string;
        }
        return string + '\u0000';
    }

    private static native void CreatePipe0(Handle var0, Handle var1, SecurityAttributes var2, int var3) throws WindowsException;

    private static native void CreateProcess0(String var0, String var1, SecurityAttributes var2, SecurityAttributes var3, boolean var4, int var5, String var6, String var7, StartupInfo var8, ProcessInformation var9) throws WindowsException;

    private static native void CreateFile0(String var0, int var1, int var2, SecurityAttributes var3, int var4, int var5, Handle var6, Handle var7, RefInt var8) throws WindowsException;

    private static native void TerminateProcess0(Handle var0, int var1) throws WindowsException;

    private static native void ReadFile0(Handle var0, byte[] var1, int var2, int var3, RefInt var4, Overlapped var5) throws WindowsException;

    private static native void WriteFile0(Handle var0, byte[] var1, int var2, int var3, RefInt var4, Overlapped var5) throws WindowsException;

    private static native void CloseHandle0(Handle var0) throws WindowsException;

    private static native void SetHandleInformation0(Handle var0, int var1, int var2) throws WindowsException;

    private static native void GetExitCodeProcess0(Handle var0, RefInt var1) throws WindowsException;

    private static native void GetHandleInformation0(Handle var0, RefInt var1) throws WindowsException;

    private static native void GetStdHandle0(int var0, Handle var1) throws WindowsException;

    private static native void DuplicateHandle0(Handle var0, Handle var1, Handle var2, Handle var3, int var4, boolean var5, int var6) throws WindowsException;

    private static native void GetCurrentProcess0(Handle var0);

    private static native int WaitForSingleObject0(Handle var0, int var1) throws WindowsException;

    private static native void SetEndOfFile0(Handle var0) throws WindowsException;

    private static native void SetFilePointerEx0(Handle var0, long var1, RefLong var3, int var4) throws WindowsException;

    private static native void KillProcessEx0(int var0, boolean var1) throws WindowsException;

    private static native void CreateHardLink0(String var0, String var1) throws WindowsException;

    private static native void CreateDirectory0(String var0, SecurityAttributes var1) throws WindowsException;

    private static native void CreateSymbolicLink0(String var0, String var1, int var2);

    private static native void RegCloseKey0(HKey var0) throws WindowsException;

    private static native void RegOpenKeyEx0(HKey var0, String var1, int var2, HKey var3) throws WindowsException;

    private static native boolean RegQueryValueEx0(HKey var0, String var1, RefInt var2, byte[] var3, RefInt var4) throws WindowsException;

    private static native boolean RegEnumValue0(HKey var0, int var1, RefString var2, RefInt var3, byte[] var4, RefInt var5) throws WindowsException;

    private static native String RegEnumKeyEx0(HKey var0, int var1, RefLong var2) throws WindowsException;

    private static native void RegSetValueEx0(HKey var0, String var1, int var2, byte[] var3) throws WindowsException;

    private static native void RegDeleteValue0(HKey var0, String var1) throws WindowsException;

    private static native void RegDeleteKey0(HKey var0, String var1) throws WindowsException;

    private static native void RegFlushKey0(HKey var0) throws WindowsException;

    private static native void RegCreateKeyEx0(HKey var0, String var1, int var2, int var3, SecurityAttributes var4, RefInt var5, HKey var6) throws WindowsException;

    private static native int ResumeThread0(Handle var0) throws WindowsException;

    private WinApi() {
    }

    static {
        String dllPath;
        log = Logger.getLogger(WinApi.class);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Loading winapi native library");
        }
        if ((dllPath = System.getProperty(DLL_PATH_PROPERTY)) == null) {
            System.loadLibrary("WinAPI");
        } else {
            System.load(dllPath);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Winapi native library loaded");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing JNI IDs for winapi");
        }
        WinApi.initIDs();
        if (log.isTraceEnabled()) {
            log.trace((Object)"JNI IDs initialized");
        }
    }
}

