import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String base_url           = new URL(props['rallyUrl']).getHost()
final String url                = props['rallyUrl'] + "/slm/webservice/" + props['rallyVer']+"/"
final String user               = props['rallyUser']
final String password           = props['rallyPass']
final String proxyHost          = props['proxyHost']
final String proxyPort          = props['proxyPort']
final String proxyPass          = props['proxyPass']
final String proxyUser          = props['proxyUser']
final String workspace          = props['workspace']

final String defectKey      = props['defectKey']
final String newState       = props['newState']

println "Server:\t" + props['rallyUrl']
println "Defect IDs:\t"+ defectKey
println "State:\t" + newState

//-------------------------------------------------------------------------
// Execute
//=========================================================================

ChangeDefectStatus cds = new ChangeDefectStatus()
cds.base_url = base_url
cds.url = url
cds.user = user
cds.password = password
cds.proxyHost = proxyHost
cds.proxyPort = proxyPort
cds.proxyPass = proxyPass
cds.proxyUser = proxyUser
cds.workspace = workspace

cds.defectKey = defectKey
cds.newState = newState

cds.execute()