/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String base_url           = new URL(props['rallyUrl']).getHost()
final String url                = props['rallyUrl'] + "/slm/webservice/" + props['rallyVer']+"/"
final String user               = props['rallyUser']
final String password           = props['rallyPass']
final String proxyHost          = props['proxyHost']
final String proxyPort          = props['proxyPort']
final String proxyPass          = props['proxyPass']
final String proxyUser          = props['proxyUser']
final String workspace          = props['workspace']

final String defectKey      = props['defectKey']
final String taskKey        = props['taskKey']
final String usKey          = props['usKey']
final String comment        = props['comment']

println "Server:\t" + props['rallyUrl']
println "Defect IDs:\t" + defectKey
println "Task IDs:\t" + taskKey
println "User Story IDs:\t" + usKey

//-------------------------------------------------------------------------
// Execute
//=========================================================================

AddComment ac = new AddComment()
ac.base_url = base_url
ac.url = url
ac.user = user
ac.password = password
ac.proxyHost = proxyHost
ac.proxyPort = proxyPort
ac.proxyPass = proxyPass
ac.proxyUser = proxyUser
ac.workspace = workspace

ac.defectKey = defectKey
ac.taskKey = taskKey
ac.usKey = usKey
ac.comment = comment

ac.execute()
