/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.automation;

import com.urbancode.air.*
import org.apache.http.client.HttpClient
import org.apache.http.client.methods.*
import org.apache.http.entity.*

import org.apache.commons.codec.*
import com.urbancode.commons.util.IO

public class CreateDefect extends AutomationBase {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************

    //**************************************************************************
    // INSTANCE
    //**************************************************************************
    
    String projectKey
    String requirementKey
    String defectName
    String defectDesc
    String priority
    String severity
    String state
    String submitter
    String environment
    String build
    
    public void execute() {
        setupHttpClient()
        
        createDefect()
    }
    
    private void createDefect() {
        def workspaceRef = configureWorkspace()
        
        def projId
        def reqId
        
        if (projectKey && projectKey.length() > 0) {
          def projectMethod = new HttpGet(url + "project?workspace=" + URLEncoder.encode(workspaceRef, "UTF-8") + "&query=" +
              URLEncoder.encode("(Name = \"" + projectKey + "\")" ,"UTF-8") + "&" + URLEncoder.encode("fetch", "UTF-8") + "=" +
                  URLEncoder.encode("true", "UTF-8"))
          client.execute(projectMethod)
          
          String responseText = IO.readText(projectMethod.getResponseBodyAsStream())
          projId = new XmlParser().parseText(responseText).Results.Object.ObjectID[0].text()
          if (projectMethod != null) {
             projectMethod.close()
          }
        }
        else {
          def requirementMethod = new HttpGet(url + "hierarchicalrequirement?workspace=" + URLEncoder.encode(workspaceRef, "UTF-8") +
              "&query=" + URLEncoder.encode("(FormattedID = " + requirementKey + ")" ,"UTF-8") + "&" + URLEncoder.encode("fetch", "UTF-8") +
                  "=" + URLEncoder.encode("true", "UTF-8"))
          client.execute(requirementMethod)
          
          String responseText = IO.readText(requirementMethod.getResponseBodyAsStream())
          reqId = new XmlParser().parseText(responseText).Results.Object.ObjectID[0].text()
          projId = new XmlParser().parseText(responseText).Results.Object.Project.'@ref'[0]
          if(requirementMethod != null) {
             requirementMethod.close()
          }
        }
        // Generate XML doc
        def writer = new StringWriter()
        def builder = new groovy.xml.MarkupBuilder(writer)
        builder.Defect(){
          Project(projId)
          if (requirementKey && requirementKey.length() >0) {
            Requirement(reqId)
          }
          Description(defectDesc)
          Name(defectName)
          Priority(priority)
          Severity(severity)
          State(state)
          Owner(submitter)
          Environment(environment)
          FoundInBuild(build)
          //Workspace(workspaceRef)
        }
        
        HttpPost method = new HttpPost(url + "defect/create")
        method.setEntity(new StringEntity(writer.toString(), ContentType.APPLICATION_XML));
        def result = client.execute(method)
        def response = IO.readText(method.getResponseBodyAsStream())
        
        //check results
        def createResult = new XmlParser().parseText(response);
        def errors = createResult.Errors.OperationResultError.size();
        def warnings = createResult.Warnings.OperationResultWarning.size();
        
        if (errors == 0 && warnings == 0) {
          println "Successfully created defect! ObjectRef =" + createResult.Object.'@ref';
          System.exit 0
        }
        else {
          println "ERROR!!! Rally Server could not create defect! "
          createResult.Errors.OperationResultError.each { println it.text() }
          createResult.Warnings.OperationResultWarning.each { println it.text() }
          System.exit 1
        }
    }
}