/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def out = System.out

//-------------------------------------------------------------------------
// Scripts variables
//=========================================================================

final def props = apTool.getStepProperties()

//get rally props for GETS and POSTS to rally
final String base_url           = new URL(props['rallyUrl']).getHost()
final String url                = props['rallyUrl'] + "/slm/webservice/" + props['rallyVer']+"/"
final String user               = props['rallyUser']
final String password           = props['rallyPass']
final String proxyHost          = props['proxyHost']
final String proxyPort          = props['proxyPort']
final String proxyPass          = props['proxyPass']
final String proxyUser          = props['proxyUser']
final String workspace          = props['workspace']

final String projectKey     = props['projectKey']
final String requirementKey = props['requirementKey']
final String defectName     = props['defectName']
final String defectDesc     = props['defectDesc']
final String priority       = props['priority']
final String severity       = props['severity']
final String state          = props['state']
final String submitter      = props['submitter']
final String environment    = props['env']
final String build          = props['build']

println "Server:\t" + props['rallyUrl']
println "Workspace Key:\t" + workspace
println "Project Key:\t" + projectKey
println "Requirement Key:\t" + requirementKey
println "Summary:\t" + defectName

//-----------------------------------------------------------------------------
// Execute
// =============================================================================

CreateDefect cd = new CreateDefect()
cd.base_url = base_url
cd.url = url
cd.user = user
cd.password = password
cd.proxyHost = proxyHost
cd.proxyPort = proxyPort
cd.proxyPass = proxyPass
cd.proxyUser = proxyUser
cd.workspace = workspace

cd.projectKey = projectKey
cd.requirementKey = requirementKey
cd.defectName = defectName
cd.defectDesc = defectDesc
cd.priority =  priority
cd.severity = severity
cd.state = state
cd.submitter = submitter
cd.environment = environment
cd.build = build

cd.execute()
