/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class EachFileAndDirectoryPIterator
extends AbstractSentinelIterator<File> {
    private final Iterator<File> iterator;
    private final Pattern filePattern;

    EachFileAndDirectoryPIterator(File directory, Pattern filePattern) {
        this.iterator = IO.listFiles(directory).iterator();
        this.filePattern = filePattern;
    }

    @Override
    protected File nextItem() {
        File result = null;
        while (this.iterator.hasNext()) {
            File file = this.iterator.next();
            String name = file.getName();
            if (file.isFile() && this.filePattern.matcher(name).matches()) {
                result = file;
                break;
            }
            if (!file.isDirectory()) continue;
            result = file;
            break;
        }
        return result;
    }
}

