/*******************************************************************************
 * (c) Copyright IBM Corporation 2009, 2013. All Rights Reserved.
 *******************************************************************************/
package com.ibm.rqm.url.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.xml.sax.SAXException;

public class RQMUrlPOST {
	
	private final String ATTACHMENT_RESOURCE_TYPE = "attachment";	
	private static final Pattern RESOURCE_PATTERN = Pattern.compile("http([s]?)://(.+)(:([0-9]+))?/(.+)/service/com.ibm.rqm.integration.service.IIntegrationService/resources/([^/]+)/([^/]+)(/(.*))?");

	public RQMUrlPOST(String sAttachURL, String sPath,
			RQMUrlUtlyJRSHttpsClient httpclient, RQMUrlUtlyLogin RQMUrlUtlyLogin, String policy)
			throws IOException {

		if(httpclient == null){
			httpclient = RQMUrlUtlyLogin.getHttpClient();
		}
		
		System.out
				.println("RQMUrlUtility: Calling [ HTTP POST ] method to upload XML from a specified file to URL");

		File f = new File(sPath);

		// Check for availability for file

		if (!f.exists() || !f.canRead()) {
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}

		PostMethod method = new PostMethod(sAttachURL);
		FilePart filePart = null;
		
		method.getParams().setCookiePolicy(policy);
		
		boolean isXMLContextType = true;
		Matcher matcher = RESOURCE_PATTERN.matcher(sAttachURL);
		if(matcher.matches()){
			String resourceType = matcher.group(7);
			if(resourceType.equals(ATTACHMENT_RESOURCE_TYPE)){
				isXMLContextType = false;
			}
		}
		
		boolean isAtomFeedType = false;
		
		try{
			if(isXMLContextType){
				isAtomFeedType=isAtomFeed(f);
				if(isAtomFeedType)
				{
					method.setRequestEntity(new InputStreamRequestEntity(new BufferedInputStream(new FileInputStream(f)), "application/atom+xml"));
				}
				else
				{
					filePart = new FilePart(f.getName(), f, "application/xml", "UTF-8");
				}
			} else{
				filePart = new FilePart(f.getName(), f, FilePart.DEFAULT_CHARSET, "UTF-8");
			}
		} catch (FileNotFoundException e){
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}
		
		if(!isAtomFeedType)
		{
			Part[] parts = { filePart };
			method.setRequestEntity(new MultipartRequestEntity(parts, method
				.getParams()));
		}

		/*
		 * Check for the Server Response for the GET Operation
		 */

		int responseCode = httpclient.executeMethod(method);

		System.out.println("RQMUrlUtility: Server Response code: "
				+ responseCode);

		if (responseCode < 400)
			System.out.println("RQMUrlUtility: [ SUCCESS ] File : \"" + sPath
					+ "\" successfully posted to URL : \"" + sAttachURL + " \"");

	}

	
	private boolean isAtomFeed(File f) 
	{
		
		DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
		try {
			docBuilderFactory.setNamespaceAware(true);
			docBuilder = docBuilderFactory.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        org.w3c.dom.Document doc = null;
	
			try {
				doc = docBuilder.parse(f);
			} catch (SAXException e) {
				// TODO Auto-generated catch block
				System.out.println("RQMUrlUtility can't parse the file\n");
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				System.out.println("Error to open the file\n");
				e.printStackTrace();
			}
	
		
		if(doc.getDocumentElement()!=null&doc.getElementsByTagName("feed").getLength() !=0)
			return true;
		
		return false;
	
	}
}
