/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs;

import com.urbancode.commons.util.crypto.SecureEquals;
import com.urbancode.commons.util.crypto.algs.AbstractCryptStringAlgorithm;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;

public abstract class AbstractCryptAlgorithm
extends AbstractCryptStringAlgorithm
implements CryptStringAlgorithm {
    private SecureRandom secureRandom = null;

    @Override
    public final boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        return SecureEquals.secureEquals(plainText, this.decode(cipherText));
    }

    @Override
    public final boolean isDecodeSupported() {
        return true;
    }

    @Override
    public boolean shouldReencode(String cipherText) throws GeneralSecurityException {
        return false;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    @Override
    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    @Override
    public boolean usesAlg(String enc) {
        return enc.startsWith(this.getAlgPrefix() + "{");
    }
}

