/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.iterator.ArrayAccessor;

final class FloatArrayAccessor
extends ArrayAccessor<Float> {
    private final float[] array;

    FloatArrayAccessor(float[] array) {
        this.array = Check.nonNull(array, "array");
    }

    @Override
    public Float get(int index) {
        return Float.valueOf(this.array[index]);
    }

    @Override
    public void set(int index, Float value) {
        this.array[index] = value.floatValue();
    }

    @Override
    public int length() {
        return this.array.length;
    }
}

